/*
 * Decompiled with CFR 0.152.
 */
package um.report;

import cn.DB;
import cn.Log;
import cn.Memory;
import cn.SapUser;
import cn.Utils;
import cn.report.CSVline;
import cn.task.Task;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import um.report.Parameters;
import um.report.Report;

class Fiori
extends Report {
    Fiori(Task task, Parameters params) {
        super(task, params);
    }

    @Override
    protected boolean populateRows(CSVline line) {
        String statement = this.getStatement();
        if (statement != null) {
            Log.log("ReportFiori getting data.\n" + statement);
            ResultSet rs = DB.getData(statement);
            int numberOfRows = DB.resultSetGetSize(rs);
            Log.log("ReportFiori found " + numberOfRows + " records.");
            int tellPoint = Utils.ceilDivider(numberOfRows, 25);
            int counter = 0;
            try {
                while (rs.next()) {
                    line.add(rs.getString("system"));
                    line.add(rs.getString("client"));
                    line.add(rs.getString("username"));
                    SapUser user = new SapUser(rs.getString("username"), rs.getString("system"), rs.getString("client"));
                    if (this.params.isSet("addName")) {
                        line.add(user.getFirstName());
                        line.add(user.getLastName());
                    }
                    if (this.params.isSet("addGroup")) {
                        line.add(user.getUserGroup());
                    }
                    if (this.params.isSet("addEmail")) {
                        line.add(user.getEmail());
                    }
                    line.add(rs.getString("fioriref"));
                    line.add(rs.getString("fiorilink"));
                    if (this.params.isSet("addMonthOfLastUsage")) {
                        line.add(rs.getString("lastUsage"));
                    }
                    if (this.params.isSet("addLock")) {
                        line.add(user.isLocked() ? this.translator.getText("Yes") : this.translator.getText("No"));
                    }
                    line.write();
                    if (++counter % tellPoint != 0) continue;
                    String s = this.translator.getText("Writing {1} of {2}", new String[]{"" + counter, "" + numberOfRows});
                    Log.log(Memory.statement(s));
                    this.task.setStatusDetails(s);
                }
                rs.close();
                String s = this.translator.getText("Writing {1} of {2}", new String[]{"" + counter, "" + numberOfRows});
                Log.log(Memory.statement(s));
                this.task.setStatusDetails(s);
            }
            catch (SQLException e) {
                Log.log("ReportFiori FAILED while retrieving data.");
                Log.logException(e);
            }
            Log.log("ReportFiori data insertion done.");
        }
        return true;
    }

    @Override
    protected ArrayList<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("System");
        headers.add("Client");
        headers.add("Username");
        if (this.params.isSet("addName")) {
            headers.add("First name");
            headers.add("Last name");
        }
        if (this.params.isSet("addGroup")) {
            headers.add("User group");
        }
        if (this.params.isSet("addEmail")) {
            headers.add("Email");
        }
        headers.add("Fiori");
        headers.add("Fiori link");
        if (this.params.isSet("addMonthOfLastUsage")) {
            headers.add("Last usage");
        }
        if (this.params.isSet("addLock")) {
            headers.add("Locked");
        }
        return headers;
    }

    private String getStatement() {
        Log.log("ReportFiori building statement.");
        String table = "um_usage_fiori_" + this.task.system.toLowerCase() + "_" + this.task.client.toLowerCase();
        if (DB.isTable(table)) {
            String statement = "SELECT t.*, (SELECT MAX(DATE(`timestamp`)) FROM `" + table + "` WHERE username = t.username AND fiorilink = t.fiorilink) lastUsage \nFROM `" + table + "` AS t \nLEFT JOIN um_user ON um_user.user = t.username AND um_user.system = t.system AND um_user.client = t.client \nWHERE 1 \n";
            if (this.user_ids.length > 0) {
                statement = statement + "AND um_user.id IN (" + Utils.toQuotedString(this.user_ids) + ") \n";
            } else {
                if (this.params.excludeUsersExpired()) {
                    statement = statement + "AND (um_user.valid_to IS NULL OR um_user.valid_to >= CURDATE() OR um_user.valid_to = '0000-00-00') \n";
                }
                if (this.params.excludeUsersLocked()) {
                    statement = statement + "AND IFNULL(um_user.locked, 'U') <> 'L' \n";
                }
            }
            if (this.params.getFromDate() != null) {
                statement = statement + "AND DATE(`timestamp`) >= '" + this.params.getFromDate() + "' \n";
            }
            if (this.params.getToDate() != null) {
                statement = statement + "AND DATE(`timestamp`) <= '" + this.params.getToDate() + "' \n";
            }
            if (this.params.getString("group").equalsIgnoreCase("u")) {
                statement = statement + "ORDER BY um_user.user, lastUsage DESC \n";
            }
            statement = statement + "LIMIT 1048576;";
            return statement;
        }
        Log.log(table + " does not exist. There is no data to get.");
        return null;
    }
}

