/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Arguments;
import cn.DB;
import cn.Log;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TransferAuthObjectsAndFields {
    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String guiid = myArgs.get("guiid");
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("TransferAuthObjectsAndFields starting transfer for " + system + " / " + client);
        TransferAuthObjectsAndFields.transferAuthObjectsAndFields(system, client, guiid);
        Log.log("TransferAuthObjectsAndFields ending transfer for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    private static void transferAuthObjectsAndFields(String system, String client, String guiid) {
        Log.log("Transfering fields using guiid '" + guiid + "'.");
        DB.transactionStart();
        DB.update("UPDATE sod_auth_field SET deleted=1 WHERE `system` = '" + system + "' AND client = '" + client + "';");
        DB.update("INSERT INTO sod_auth_field (`system`, client, field, text) SELECT '" + system + "' AS `system`, '" + client + "' AS `client`, `field`, `text` FROM temp_field AS t WHERE guiid = '" + guiid + "' ON DUPLICATE KEY UPDATE text=t.text, deleted=0;");
        if (!DB.transactionCommit()) {
            Log.log("Transfering fields failed!");
        } else {
            DB.clearTempTable(guiid, "temp_field");
        }
        Log.log("Transfering object classes using guiid '" + guiid + "'.");
        DB.transactionStart();
        DB.update("UPDATE sod_auth_class SET deleted=1 WHERE `system` = '" + system + "' AND client = '" + client + "';");
        DB.update("INSERT INTO sod_auth_class (`system`, client, class, text) SELECT '" + system + "' AS `system`, '" + client + "' AS `client`, `class`, `text` FROM temp_object_class AS t WHERE guiid = '" + guiid + "' ON DUPLICATE KEY UPDATE text=t.text, deleted=0;");
        DB.update("INSERT INTO sod_auth_class (`system`, client, class) SELECT '" + system + "' AS `system`, '" + client + "' AS `client`, `class` FROM temp_object AS t WHERE guiid = '" + guiid + "' GROUP BY class ON DUPLICATE KEY UPDATE deleted=0;");
        if (!DB.transactionCommit()) {
            Log.log("Transfering object classes failed!");
        } else {
            DB.clearTempTable(guiid, "temp_object_class");
        }
        Log.log("Transfering objects - setting deleted = 1 in sod_auth_object for " + system + " / " + client + ".");
        DB.transactionStart();
        DB.update("UPDATE sod_auth_object SET deleted=1 WHERE `system` = '" + system + "' AND client = '" + client + "';");
        Log.log("Transfering objects - getting data.");
        ResultSet rs = DB.getData("SELECT object, text, (SELECT id FROM sod_auth_class WHERE `system` = '" + system + "' AND client='" + client + "' AND class=t.class) AS class_id, (SELECT id FROM sod_auth_field WHERE `system` = '" + system + "' AND client='" + client + "' AND field=t.field1) AS field1, (SELECT id FROM sod_auth_field WHERE `system` = '" + system + "' AND client='" + client + "' AND field=t.field2) AS field2, (SELECT id FROM sod_auth_field WHERE `system` = '" + system + "' AND client='" + client + "' AND field=t.field3) AS field3, (SELECT id FROM sod_auth_field WHERE `system` = '" + system + "' AND client='" + client + "' AND field=t.field4) AS field4, (SELECT id FROM sod_auth_field WHERE `system` = '" + system + "' AND client='" + client + "' AND field=t.field5) AS field5, (SELECT id FROM sod_auth_field WHERE `system` = '" + system + "' AND client='" + client + "' AND field=t.field6) AS field6, (SELECT id FROM sod_auth_field WHERE `system` = '" + system + "' AND client='" + client + "' AND field=t.field7) AS field7, (SELECT id FROM sod_auth_field WHERE `system` = '" + system + "' AND client='" + client + "' AND field=t.field8) AS field8, (SELECT id FROM sod_auth_field WHERE `system` = '" + system + "' AND client='" + client + "' AND field=t.field9) AS field9, (SELECT id FROM sod_auth_field WHERE `system` = '" + system + "' AND client='" + client + "' AND field=t.field10) AS field10 FROM temp_object AS t WHERE guiid = '" + guiid + "'; ");
        int resultSize = DB.resultSetGetSize(rs);
        Log.log("temp_object containing: " + resultSize + ". Preparing statements.");
        PreparedStatement ps = DB.prepareStatement("INSERT INTO sod_auth_object ( \t`deleted`, `system`, `client`, `class_id`, `object`, `text`, \tfield1_id, field2_id, field3_id, field4_id, field5_id, \tfield6_id, field7_id, field8_id, field9_id, field10_id ) VALUES( \t0, '" + system + "', '" + client + "', ?, ?, ?, \t?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) ON DUPLICATE KEY UPDATE `deleted` = 0, \t`text` = VALUES(`text`), \t`field1_id` = VALUES(`field1_id`), \t`field2_id` = VALUES(`field2_id`), \t`field3_id` = VALUES(`field3_id`), \t`field4_id` = VALUES(`field4_id`), \t`field5_id` = VALUES(`field5_id`), \t`field6_id` = VALUES(`field6_id`), \t`field7_id` = VALUES(`field7_id`), \t`field8_id` = VALUES(`field8_id`), \t`field9_id` = VALUES(`field9_id`), \t`field10_id` = VALUES(`field10_id`);");
        int filledFields = 0;
        String field = "field";
        try {
            while (rs.next()) {
                ps.setInt(1, rs.getInt(3));
                ps.setString(2, rs.getString(1));
                ps.setString(3, rs.getString(2));
                for (int i = 1; i <= 10; ++i) {
                    String fieldname = "field" + i;
                    String content = rs.getString(fieldname);
                    if (Utils.isEmpty(content)) {
                        ps.setString(3 + i, null);
                        continue;
                    }
                    ps.setInt(3 + i, rs.getInt(fieldname));
                    ++filledFields;
                }
                ps.addBatch();
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("transferAuthObjectsAndFields Preparing statements failed.");
            Log.logException(e);
        }
        if (resultSize > 0) {
            Log.log("Transfering objects - updating sod_auth_object with " + resultSize + " entries. Found " + filledFields + " fields.");
            try {
                int[] affectedRows = ps.executeBatch();
                Log.log("Transfering objects - update of sod_auth_object affected " + affectedRows.length + " rows.");
            }
            catch (SQLException e) {
                Log.log("transferAuthObjectsAndFields updating sod_auth_object failed.");
                Log.logException(e);
            }
        }
        Log.log("done tranferring objects - clearing temp_object");
        if (!DB.transactionCommit()) {
            Log.log("Transfering objects failed!");
        } else {
            DB.clearTempTable(guiid, "temp_object");
        }
        DB.resetAutoIncrement("sod_auth_object", null);
    }
}

