/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import um.Usage;

public class Trace {
    static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " um/dashboard/Trace ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("Trace starting for " + system + " / " + client);
        Trace.trace(system, client);
        Log.log("Trace ending for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    private static void trace(String system, String client) {
        Log.log("Trace buildUsageDates.");
        String inActiveUsersTable = "`um_dash_inactive_users_" + system.toLowerCase() + "_" + client.toLowerCase() + "`";
        Log.log("Dropping " + inActiveUsersTable);
        DB.update("DROP TABLE IF EXISTS " + inActiveUsersTable);
        Log.log("Creating " + inActiveUsersTable + " with um_user data and null as last active date.");
        DB.update("CREATE TABLE " + inActiveUsersTable + " ( `user` varchar(12) COLLATE utf8mb4_bin NOT NULL,  `last_active_date` date,  `um_delete` tinyint(4),  PRIMARY KEY (user) ) SELECT um_user.user, null AS last_active_date, um_user.um_delete FROM um_user WHERE `system`= '" + system + "' AND client = '" + client + "' ;");
        Log.log("Populating max last_active_date for " + system + " / " + client);
        String usageTable = Usage.getUsageTable(system, client);
        if (DB.isTable(usageTable)) {
            ResultSet data = DB.getData("SELECT user, MAX(date) AS max, MIN(date) AS min FROM `" + usageTable + "` WHERE `date` <> '0000-00-00' GROUP BY user;");
            int total = DB.resultSetGetSize(data);
            if (total > 0) {
                PreparedStatement inActive = DB.prepareStatement("UPDATE " + inActiveUsersTable + " SET last_active_date = ? WHERE user = ? ;");
                Date higest = null;
                Date lowest = null;
                try {
                    while (data.next()) {
                        Date max = data.getDate("max");
                        Date min = data.getDate("min");
                        String user = data.getString("user");
                        if (higest == null && max != null || max.compareTo(higest) > 0) {
                            higest = max;
                        }
                        if (lowest == null && min != null || min.compareTo(lowest) < 0) {
                            lowest = min;
                        }
                        inActive.setDate(1, max);
                        inActive.setString(2, user);
                        inActive.addBatch();
                    }
                    Log.log(system + " / " + client + " had " + total + " records; max date: " + higest + "; min date: " + lowest);
                    data.close();
                    Log.log("Saving user max dates for " + system + " / " + client);
                    inActive.executeBatch();
                }
                catch (SQLException e) {
                    Log.log("FAILED! Trace reading user max dates or saving inactive users failed.");
                    Log.logException(e);
                }
            } else {
                Log.log("NO VALUES TO CALCULATE FROM ON " + system + " / " + client);
            }
        } else {
            Log.log("NO USAGE EXISTS for " + system + " / " + client);
        }
        Log.log("Trace buildUsageDates DONE.\n");
    }
}

