/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.Role;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RTR {
    private static final int batchSizeMin = 10000;
    private static final String SQL_low_high = "INSERT INTO um_role_tcode (role_id, tcode_id, delete_flag, `system`, client, um_delete) SELECT ?, id, 0, ?, ?, 0 FROM um_tcode WHERE `system` = ? AND client = ? AND tcode BETWEEN ? AND ? AND nonexistent != 'X' ON DUPLICATE KEY UPDATE delete_flag=0, um_delete=0;";
    private static final String SQL_wildcard = "INSERT INTO um_role_tcode (role_id, tcode_id, delete_flag, `system`, client, um_delete) SELECT ?, id, 0, ?, ?, 0 FROM um_tcode WHERE `system` = ? AND client = ? AND tcode LIKE ? AND nonexistent != 'X' ON DUPLICATE KEY UPDATE delete_flag=0, um_delete=0;";
    private static final String SQL_low_only = "INSERT INTO um_role_tcode (role_id, tcode_id, delete_flag, `system`, client, um_delete) SELECT ?, id, 0, ?, ?, 0 FROM um_tcode WHERE `system` = ? AND client = ? AND tcode = ? AND nonexistent != 'X' ON DUPLICATE KEY UPDATE delete_flag=0, um_delete=0;";

    static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " um/dashboard/RTR ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("RTR starting transfer for " + system + " / " + client);
        RTR.transferUMRoleTcodeRanges(system, client);
        Log.log("RTR ending transfer for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    private static void transferUMRoleTcodeRanges(String system, String client) {
        Log.log("RTR transferUMRoleTcodeRanges for " + system + " / " + client + ".");
        int count = DB.getOneInt("SELECT COUNT(DISTINCT role_id) AS total FROM um_role_auth JOIN um_role ON um_role.id = um_role_auth.role_id WHERE\t`system` = '" + system + "' AND client = '" + client + "' AND transferred = 0 AND um_role_auth.um_delete = 0 AND \t\t`object` = 'S_TCODE' AND `field` = 'TCD' ;");
        Log.log("Found " + count + " untransferred roles in um_role_auth for " + system + " / " + client + ".");
        ResultSet roles = DB.getData("SELECT role_id, low, high FROM um_role_auth JOIN um_role ON um_role.id = um_role_auth.role_id WHERE\t`system` = '" + system + "' AND client = '" + client + "' AND transferred = 0 AND um_role_auth.um_delete = 0 AND \t\t`object` = 'S_TCODE' AND `field` = 'TCD' ;");
        int i = 0;
        try {
            PreparedStatement um_delete = DB.prepareStatement("UPDATE um_role_tcode SET um_delete=1 WHERE role_id IN (?);");
            PreparedStatement low_high = DB.prepareStatement(SQL_low_high);
            PreparedStatement wildcard = DB.prepareStatement(SQL_wildcard);
            PreparedStatement low_only = DB.prepareStatement(SQL_low_only);
            PreparedStatement transferred = DB.prepareStatement("UPDATE um_role_auth SET transferred=1 WHERE role_id IN (?);");
            int last_id = 0;
            int currentCounter = 0;
            int role_id = 0;
            while (roles.next()) {
                role_id = roles.getInt("role_id");
                if (role_id != last_id) {
                    if (currentCounter > 10000) {
                        Log.log("Prepared " + i + " batch statements and will now send batch of " + currentCounter + ".");
                        Log.log("Marking roles as deleted in um_role.");
                        um_delete.executeBatch();
                        Log.log("Sending batch of " + currentCounter + ". " + i + " statements send to database in batches.");
                        Log.log("Sending Low high.");
                        low_high.executeBatch();
                        Log.log("Low high done. Sending wildcard.");
                        wildcard.executeBatch();
                        Log.log("Wildcard done. Sending low only.");
                        low_only.executeBatch();
                        Log.log("Low only done. Setting roles to transferred.");
                        transferred.executeBatch();
                        Log.log("Transferred done. Clearing batches.");
                        um_delete.clearBatch();
                        low_high.clearBatch();
                        wildcard.clearBatch();
                        low_only.clearBatch();
                        transferred.clearBatch();
                        currentCounter = 0;
                        Log.log("Batches clear.");
                    }
                    um_delete.setInt(1, role_id);
                    um_delete.addBatch();
                    transferred.setInt(1, role_id);
                    transferred.addBatch();
                    last_id = role_id;
                }
                String low = roles.getString("low");
                String high = roles.getString("high");
                if (high.length() > 0) {
                    low_high.setInt(1, role_id);
                    low_high.setString(2, system);
                    low_high.setString(3, client);
                    low_high.setString(4, system);
                    low_high.setString(5, client);
                    low_high.setString(6, low);
                    low_high.setString(7, high);
                    low_high.addBatch();
                } else if (low.indexOf(42) > -1) {
                    wildcard.setInt(1, role_id);
                    wildcard.setString(2, system);
                    wildcard.setString(3, client);
                    wildcard.setString(4, system);
                    wildcard.setString(5, client);
                    wildcard.setString(6, low.replace('*', '%'));
                    wildcard.addBatch();
                } else if (low.length() > 0) {
                    low_only.setInt(1, role_id);
                    low_only.setString(2, system);
                    low_only.setString(3, client);
                    low_only.setString(4, system);
                    low_only.setString(5, client);
                    low_only.setString(6, low);
                    low_only.addBatch();
                } else {
                    Role r = Role.getById(role_id);
                    if (r == null) {
                        Log.log("RTR low and/or high are both empty. Role id = " + role_id + ". Data will be ignored. Role likely does not exist.");
                    } else {
                        Log.log("RTR low and/or high are both empty. Role id = " + role_id + ". Data will be ignored for role " + r.toString() + ".");
                    }
                }
                ++currentCounter;
                if (++i % 10000 != 0) continue;
                Log.log("Prepared " + i + " batch statements so far.");
            }
            Log.log("Prepared " + i + " batch statements and will now send final batch of " + currentCounter + ".");
            Log.log("Marking roles as deleted in um_role.");
            um_delete.executeBatch();
            Log.log("Sending batch of " + currentCounter + ". " + i + " statements send to database in batches.");
            Log.log("Sending Low high.");
            low_high.executeBatch();
            Log.log("Low high done. Sending wildcard.");
            wildcard.executeBatch();
            Log.log("Wildcard done. Sending low only.");
            low_only.executeBatch();
            Log.log("Low only done. Setting roles to transferred.");
            transferred.executeBatch();
            Log.log("Transferred done. Closing statements.");
            um_delete.close();
            low_high.close();
            wildcard.close();
            low_only.close();
            transferred.close();
            roles.close();
        }
        catch (SQLException e) {
            Log.log("roles.next() Failed in um.etl.RTR!");
            Log.logException(e);
        }
        Log.log("RTR done.\n");
    }
}

