/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class Dashboard_ProgramUsage {
    Dashboard_ProgramUsage() {
    }

    static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " um/dashboard/Dashboard_ProgramUsage ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("ProgramUsage for " + system + " / " + client);
        Dashboard_ProgramUsage.regularProgramUsage(system, client);
        Dashboard_ProgramUsage.fioriProgramUsage(system, client);
        Log.log("ProgramUsage for " + system + " / " + client + " done.\n");
        DB.close();
        Log.close();
    }

    private static void regularProgramUsage(String system, String client) {
        Log.log("Regular ProgramUsage for " + system + " / " + client);
        String tablename = "um_usage_" + system.toLowerCase() + "_" + client.toLowerCase();
        if (DB.isTable(tablename)) {
            String savetablename = "um_dash_program_usage_" + system.toLowerCase() + "_" + client.toLowerCase();
            if (DB.isTable(savetablename)) {
                String sql = "INSERT IGNORE INTO `" + savetablename + "` (`month`, `count`, `program`) SELECT LAST_DAY(NOW()) AS `month`, count(program) AS `count`, `program` FROM `" + tablename + "` WHERE MONTH(`date`) = MONTH(NOW()) AND YEAR(`date`) = YEAR(NOW()) GROUP BY `program` ORDER BY `count` DESC, `program` ASC LIMIT 10;";
                DB.update(sql);
            } else {
                Dashboard_ProgramUsage.firstRunRegular(tablename, savetablename);
            }
        } else {
            Log.log("Regular ProgramUsage found NO usage table for " + system + " / " + client + " `" + tablename + "`");
        }
        Log.log("Regular ProgramUsage for " + system + " / " + client + " done.");
    }

    private static void fioriProgramUsage(String system, String client) {
        Log.log("Fiori ProgramUsage for " + system + " / " + client);
        String tablename = "um_usage_fiori_" + system.toLowerCase() + "_" + client.toLowerCase();
        if (DB.isTable(tablename)) {
            String savetablename = "um_dash_fiori_usage_" + system.toLowerCase() + "_" + client.toLowerCase();
            if (DB.isTable(savetablename)) {
                String sql = "INSERT IGNORE INTO `" + savetablename + "` (`month`, `count`, `program`) SELECT LAST_DAY(NOW()) AS `month`, COUNT(fiorilink) AS `count`, `fiorilink` AS `program` FROM `" + tablename + "` WHERE MONTH(`timestamp`) = MONTH(NOW()) AND YEAR(`timestamp`) = YEAR(NOW()) GROUP BY `program` ORDER BY `count` DESC, `program` ASC LIMIT 10;";
                DB.update(sql);
            } else {
                Dashboard_ProgramUsage.firstRunFiori(tablename, savetablename);
            }
        } else {
            Log.log("Fiori usage found NO fiori usage table for " + system + " / " + client + " `" + tablename + "`");
        }
        Log.log("Fiori ProgramUsage for " + system + " / " + client + " done.");
    }

    private static void firstRunRegular(String tablename, String savetablename) {
        Log.log("firstRunRegular: creating table " + savetablename);
        DB.update("CREATE TABLE IF NOT EXISTS `" + savetablename + "` (\t`month` DATE NOT NULL, \t`program` VARCHAR(40) NOT NULL, \t`count` INT NOT NULL DEFAULT '0', PRIMARY KEY (`month`, `program`));");
        Log.log("firstRunRegular: calculating from " + tablename + " for 12 months.");
        int[] usageMonths = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        String sql = "INSERT IGNORE INTO `" + savetablename + "` (`month`, `count`, `program`) SELECT LAST_DAY(`date`) AS `month`, count(program) AS `count`, `program` FROM `" + tablename + "` WHERE `date` >= SUBDATE(NOW(), INTERVAL 1 YEAR) AND MONTH(`date`) = ? GROUP BY `month`, program ORDER BY `count` DESC, `program` ASC LIMIT 10;";
        PreparedStatement insertProgramUsage = DB.prepareStatementInsert(sql);
        try {
            for (int usageMonth : usageMonths) {
                insertProgramUsage.setInt(1, usageMonth);
                insertProgramUsage.addBatch();
            }
            Log.log("firstRunRegular: saving to " + savetablename + " for 12 months.");
            insertProgramUsage.executeBatch();
        }
        catch (SQLException e) {
            Log.log("firstRunRegular: updating program usage failed!");
            Log.logException(e);
        }
        Log.log("firstRunRegular: done!");
    }

    private static void firstRunFiori(String tablename, String savetablename) {
        Log.log("firstRunFiori: creating table " + savetablename);
        DB.update("CREATE TABLE IF NOT EXISTS `" + savetablename + "` (\t`month` DATE NOT NULL, \t`program` VARCHAR(512) NOT NULL, \t`count` INT NOT NULL DEFAULT '0', PRIMARY KEY (`month`, `program`));");
        Log.log("firstRunFiori: calculating from " + tablename + " for 12 months.");
        int[] usageMonths = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        String sql = "INSERT IGNORE INTO `" + savetablename + "` (`month`, `count`, `program`) SELECT LAST_DAY(`timestamp`) AS `month`, COUNT(fiorilink) AS `count`, `fiorilink` AS `program` FROM `" + tablename + "` WHERE `timestamp` >= SUBDATE(NOW(), INTERVAL 1 YEAR) AND MONTH(`timestamp`) = ? GROUP BY `program` ORDER BY `count` DESC, `program` ASC LIMIT 10;";
        PreparedStatement insertFioriUsage = DB.prepareStatementInsert(sql);
        try {
            for (int usageMonth : usageMonths) {
                insertFioriUsage.setInt(1, usageMonth);
                insertFioriUsage.addBatch();
            }
            Log.log("firstRunFiori: saving to " + savetablename + " for 12 months.");
            insertFioriUsage.executeBatch();
        }
        catch (SQLException e) {
            Log.log("firstRunFiori: updating program usage failed!");
            Log.logException(e);
        }
        Log.log("firstRunFiori: done!");
    }
}

