/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Language;
import cn.Log;
import cn.Translator;
import cn.report.Spreadsheet;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import um.LicenseCategory;
import um.Usage;
import um.dashboard.Algorithm;
import um.dashboard.Dashboard_1;

class Dashboard_L1 {
    private static PreparedStatement SINGLESUM;

    Dashboard_L1() {
    }

    static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " um/dashboard/Dashboard_L1 ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("Dashboard_L1 starting for " + system + " / " + client);
        Dashboard_L1.go(system, client);
        Log.log("Dashboard_L1 ending for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    private static void go(String system, String client) {
        Log.log("Build basic licenses (SUBTYPE_DASH_L1).");
        SINGLESUM = DB.prepareStatement("INSERT IGNORE INTO um_dash_license_alloc_history \t(`system`, client, date, alloc_type, category_id, count, sum_cost) VALUES \t(?, ?, ?, ?, ?, ?, ?);");
        Dashboard_L1.buildUserList(system, client);
        Date startDate = Dashboard_1.getStartDate();
        Date endDate = Dashboard_1.getEndDate();
        Log.log("Start date: " + startDate + " - End date: " + endDate);
        Dashboard_L1.buildUsage(system, client, startDate, endDate);
        Dashboard_L1.buildSums(system, client, endDate);
        Dashboard_L1.buildUserComparisonReport(system, client);
        Log.log("Build basic licenses (SUBTYPE_DASH_L1) done.\n");
    }

    private static void buildUserList(String system, String client) {
        Log.log("buildUserList() getting user_ids from um_dash_license_alloc");
        PreparedStatement clean = DB.prepareStatement("DELETE FROM um_dash_license_alloc WHERE `user_id` = ? ;");
        ResultSet rs = DB.getData("SELECT `user_id` FROM um_dash_license_alloc WHERE `system` = '" + system + "' AND `client` = '" + client + "';");
        try {
            while (rs.next()) {
                clean.setInt(1, rs.getInt(1));
                clean.addBatch();
            }
            rs.close();
            Log.log("buildUserList() deleting user_ids from um_dash_license_alloc");
            clean.executeBatch();
        }
        catch (SQLException e) {
            Log.log("FAILED! cleaning um_dash_license_alloc;");
            Log.logException(e);
        }
        Log.log("buildUserList() Populate user list in table um_dash_license_alloc.");
        DB.update("INSERT INTO um_dash_license_alloc (`user_id`, `system`, `client`, `user`, `cat_s`, `cat_u`) SELECT u.id AS user_id, \t'" + system + "' AS `system`, \t'" + client + "' AS `client`, \tu.user, \tIFNULL(c.id, 0) AS cat_s, \t-1 AS cat_u FROM um_user AS u LEFT JOIN license_category AS c \tON c.system = '" + system + "' AND c.client = '" + client + "' AND u.license_type = c.license_map_su01 WHERE \tu.um_delete=0 AND locked='U' AND \t(valid_from <= CURDATE() OR valid_from = DATE('0000-00-00')) AND \t(valid_to >= CURDATE() OR valid_to = DATE('0000-00-00')) AND \tu.system = '" + system + "' AND \tu.client = '" + client + "' ON DUPLICATE KEY UPDATE cat_s = IFNULL(c.id, 0), cat_u = -1;");
        Log.log("buildUserList() add in role-based license categories");
        DB.update("UPDATE um_dash_license_alloc AS a SET cat_r = IFNULL(\t(SELECT c.id FROM um_user_role AS ur \t\tJOIN um_role AS r ON r.system = '" + system + "' AND r.client = '" + client + "' AND r.id = ur.role_id \t\tJOIN license_category AS c ON c.id = r.license_category_id AND c.system = '" + system + "' AND c.client = '" + client + "' \tWHERE \t\tur.user_id = a.user_id AND \t\tur.um_delete = 0 AND \t\tr.um_delete = 0 AND \t\tur.system = '" + system + "' AND \t\tur.client = '" + client + "' \tORDER BY c.cost DESC, c.license_map_su01 ASC LIMIT 1), 0);");
    }

    private static void buildUsage(String system, String client, Date startDate, Date endDate) {
        Log.log("buildUsage() add in usage-based license categories. Usage " + system + " / " + client);
        Usage usage = Usage.getInstance(system, client, startDate, endDate);
        HashMap<Integer, int[]> userRoles = Algorithm.getUserRoleUsageLazy(system, client, usage);
        if (!userRoles.isEmpty()) {
            PreparedStatement update = DB.prepareStatement("UPDATE um_dash_license_alloc SET cat_u = ? WHERE user_id = ? ;");
            LicenseCategory.setSystemClient(system, client);
            for (Map.Entry<Integer, int[]> entry : userRoles.entrySet()) {
                int[] role_ids = entry.getValue();
                int lc = role_ids.length == 0 ? -2 : (role_ids.length == 1 && role_ids[0] == 0 ? -3 : LicenseCategory.getLicenseCategoryIdOfHighestCostRole(role_ids));
                try {
                    update.setInt(1, lc);
                    update.setInt(2, entry.getKey());
                    update.addBatch();
                }
                catch (SQLException e) {
                    Log.log("FAILED! dashboard L1 buildUsage adding batch of " + lc + " " + entry.getKey());
                    Log.logException(e);
                }
            }
            Log.log("Updating table `um_dash_license_alloc` with " + userRoles.entrySet().size() + " rows.");
            try {
                update.executeBatch();
            }
            catch (SQLException e) {
                Log.log("FAILED! dashboard L1 buildUsage executing batch of statements");
                Log.logException(e);
            }
            Log.log("buildUsage2 done.");
        } else {
            Log.log("buildUsage2 done with no data.");
        }
    }

    private static void buildSums(String system, String client, Date date) {
        Log.log("Calculate sums by type and category for history table");
        for (LicenseCategory lc : LicenseCategory.getLicenseCategories()) {
            Log.log("buildSums() processing " + system + "/" + client + " cat " + lc.getId() + " " + lc.getName());
            Dashboard_L1.buildSingleSum(system, client, date, lc, "cat_s", "S");
            Dashboard_L1.buildSingleSum(system, client, date, lc, "cat_r", "R");
            Dashboard_L1.buildSingleSum(system, client, date, lc, "cat_u", "U");
        }
        for (LicenseCategory lc : LicenseCategory.getPseudoLicenseCategories()) {
            Log.log("buildSums() processing " + system + "/" + client + " cat " + lc.getId() + " " + lc.getName());
            Dashboard_L1.buildSingleSum(system, client, date, lc, "cat_u", "U");
        }
        try {
            SINGLESUM.executeBatch();
        }
        catch (SQLException e) {
            Log.log("Dashboard_L1 updating database failed.");
            Log.logException(e);
        }
        Log.log("UM Dashboard L1 buildSums DONE.\n");
    }

    private static void buildSingleSum(String system, String client, Date date, LicenseCategory lc, String typeField, String typeValue) {
        Log.log("buildSingleSum: " + system + "/" + client + " " + typeField + " " + lc.getName());
        int count = DB.getOneInt("SELECT COUNT(user) c FROM um_dash_license_alloc WHERE `system` = '" + system + "' AND client = '" + client + "' AND " + typeField + " = " + lc.getId() + ";");
        int cost = count * lc.getCost();
        Log.log("buildSingleSum: " + system + "/" + client + " " + typeField + " " + lc.getName() + " count: " + count + " cost:" + cost + " entered for " + date.toString());
        try {
            SINGLESUM.setString(1, system);
            SINGLESUM.setString(2, client);
            SINGLESUM.setString(3, date.toString());
            SINGLESUM.setString(4, typeValue);
            SINGLESUM.setInt(5, lc.getId());
            SINGLESUM.setInt(6, count);
            SINGLESUM.setInt(7, cost);
            SINGLESUM.addBatch();
        }
        catch (SQLException e) {
            Log.log("UM Dashboard L1 buildSingleSum failed.");
            Log.logException(e);
        }
    }

    private static void buildUserComparisonReport(String system, String client) {
        Language[] languages;
        Log.log("UM Dashboard L1 Starting user license comparison reports");
        for (Language language : languages = Language.getAvailableLanguages()) {
            Log.log("Starting user license comparison report in " + language.title);
            Translator translator = Translator.getInstance(language.isoString);
            String sql = "SELECT *, (IF(\t`" + translator.getText("SU01") + "`=`" + translator.getText("Roles") + "` AND \t`" + translator.getText("Roles") + "`=`" + translator.getText("Usage") + "`,'C','NC')) AS `" + translator.getText("Compliance") + "` FROM (SELECT \tuser AS `" + translator.getText("User") + "`, \t(SELECT category FROM license_category WHERE `system` = '" + system + "' AND `client` = '" + client + "' AND id=a.cat_s) `" + translator.getText("SU01") + "`, \t(SELECT category FROM license_category WHERE `system` = '" + system + "' AND `client` = '" + client + "' AND id=a.cat_r) `" + translator.getText("Roles") + "`, \t(CASE a.cat_u \t\tWHEN -1 THEN '" + translator.getText("No usage") + "' \t\tWHEN -2 THEN '" + translator.getText("Usage w/o role") + "' \t\tWHEN -3 THEN '" + translator.getText("WebDynpro only") + "' \t\tELSE (SELECT category FROM license_category WHERE `system` = '" + system + "' AND client = '" + client + "' AND id = a.cat_u) \tEND) AS `" + translator.getText("Usage") + "` \tFROM um_dash_license_alloc AS a \tWHERE `system` = '" + system + "' AND `client` = '" + client + "' ) AS q";
            String filename = Config.getReportPath() + "UM_UserLicenseComparison-" + system + "_" + client + ".xlsx";
            boolean success = Spreadsheet.ExcelFromStatement(filename, sql, translator.getText("UserLicenseComparison"));
            if (success) {
                Log.log(filename + " saved successfully.");
                continue;
            }
            Log.log(filename + " FAILED!");
        }
        Log.log("UM Dashboard L1 User license comparison reports DONE.\n");
    }
}

