/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Config;
import cn.DB;
import cn.Frequency;
import cn.Language;
import cn.Log;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

class Dashboard_HighUsageSettings {
    final String system;
    final String client;
    final int max_rows = 1000;
    int retention;
    int minimum_threshold;
    int minimum_dynpro;
    int default_threshold;
    int default_dynpro;
    int default_days;
    String default_userfilter;
    boolean notifications_send;
    boolean notifications_regardless;
    Frequency notifications_interval;
    String notifications_sender;
    String notifications_emails;
    String notifications_language;
    Timestamp last_send_mail;

    Dashboard_HighUsageSettings(String system, String client) {
        this.system = system;
        this.client = client;
        this.standardValues();
        this.loadValues();
    }

    void updateLastSentMail() {
        DB.update("UPDATE um_dash_settings_high_usage SET last_send_mail = CURRENT_TIMESTAMP WHERE `system` = '" + this.system + "' AND client = '" + this.client + "'; ");
        this.loadValues();
    }

    private void standardValues() {
        this.retention = 60;
        this.minimum_threshold = 25;
        this.minimum_dynpro = 50;
        this.default_threshold = 50;
        this.default_dynpro = 100;
        this.default_days = 7;
        this.default_userfilter = "";
        this.notifications_send = false;
        this.notifications_regardless = false;
        this.notifications_interval = new Frequency(3);
        this.notifications_language = Config.getFallbackLanguageISO();
        this.notifications_sender = "";
        this.notifications_emails = "";
        this.last_send_mail = Timestamp.valueOf("0001-01-01 00:00:00");
    }

    private void loadValues() {
        Log.log("Loading High Usage Settings from um_dash_settings_high_usage for " + this.system + " / " + this.client);
        ResultSet rs = DB.getData("SELECT * FROM um_dash_settings_high_usage WHERE `system` = '" + this.system + "' AND client = '" + this.client + "';");
        try {
            while (rs.next()) {
                this.retention = rs.getInt("retention") > 0 ? rs.getInt("retention") : this.retention;
                this.minimum_threshold = rs.getInt("minimum_threshold") > 0 ? rs.getInt("minimum_threshold") : this.minimum_threshold;
                this.minimum_dynpro = rs.getInt("minimum_dynpro") > 0 ? rs.getInt("minimum_dynpro") : this.minimum_dynpro;
                this.default_threshold = rs.getInt("default_threshold") > 0 ? rs.getInt("default_threshold") : this.default_threshold;
                this.default_dynpro = rs.getInt("default_dynpro") > 0 ? rs.getInt("default_dynpro") : this.default_dynpro;
                this.default_days = rs.getInt("default_days") > 0 ? rs.getInt("default_days") : this.default_days;
                this.notifications_interval = new Frequency(rs.getInt("notifications_interval"));
                this.notifications_send = rs.getBoolean("notifications_send");
                this.notifications_regardless = rs.getBoolean("notifications_regardless");
                this.notifications_sender = rs.getString("notifications_sender");
                this.notifications_emails = rs.getString("notifications_emails");
                this.notifications_language = Language.isLanguageAvailable(rs.getString("notifications_language")) ? rs.getString("notifications_language") : this.notifications_language;
                this.last_send_mail = rs.getTimestamp("last_send_mail") != null ? rs.getTimestamp("last_send_mail") : this.last_send_mail;
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("FAILED! loading UM high usage settings");
            Log.logException(e);
        }
    }

    public String[] getEmails() {
        String[] emails = this.notifications_emails.split(";");
        return emails;
    }
}

