/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Email;
import cn.EmailContent;
import cn.Log;
import cn.Translator;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.mail.internet.InternetAddress;
import um.dashboard.Dashboard_HighUsageSettings;

class Dashboard_HighUsage {
    Dashboard_HighUsage() {
    }

    static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " um/dashboard/Dashboard_HighUsage ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("Dashboard_HighUsage starting for " + system + " / " + client);
        Dashboard_HighUsage.go(system, client);
        Log.log("Dashboard_HighUsage ending for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    private static void go(String system, String client) {
        Log.log("SUBTYPE_HIGH_USAGE starting.");
        Dashboard_HighUsageSettings hus = new Dashboard_HighUsageSettings(system, client);
        if (hus.notifications_send) {
            Dashboard_HighUsage.sendMails(hus);
        } else {
            Log.log("High Usage mails turned off on " + system + " / " + client);
            Dashboard_HighUsage.retentionUphold(hus);
        }
        Log.log("SUBTYPE_HIGH_USAGE DONE.\n");
    }

    private static void sendMails(Dashboard_HighUsageSettings hus) {
        InternetAddress[] emails = Email.convertEmailString(hus.notifications_emails);
        if (hus.notifications_send && emails != null && Email.isValidEmail(hus.notifications_sender)) {
            if (hus.notifications_interval.isOverdue(new Date(hus.last_send_mail.getTime()))) {
                Log.log("Receiver emails are: " + hus.notifications_emails);
                Dashboard_HighUsage.createMails(emails, hus);
                Log.log("Send mails is turned on and should be sent.\n");
                Dashboard_HighUsage.retentionUphold(hus);
            } else {
                Log.log("No mails sent. Last mails sent: " + hus.last_send_mail + " - Notification frequency is " + hus.notifications_interval);
            }
        } else {
            Log.log("Not sending mails as some settings are invalid for sending emails.\n\tsend mails:\t " + hus.notifications_send + "\n\tfrom mail: \t " + hus.notifications_sender + "\n\tto mails:  \t " + hus.notifications_emails + "\n\tFrequency: \t " + hus.notifications_interval);
        }
    }

    private static void createMails(InternetAddress[] emails, Dashboard_HighUsageSettings hus) {
        Translator translator = Translator.getInstance(hus.notifications_language);
        hus.notifications_interval.findTimePeriod(new Date(hus.last_send_mail.getTime()));
        Date date_from = hus.notifications_interval.getPeriodStart();
        Date date_to = hus.notifications_interval.getPeriodEnd();
        String tablecontent = Dashboard_HighUsage.getTableContent(date_from, date_to, hus);
        String[] dates = new String[]{date_from.toString(), date_to.toString()};
        String headline = translator.getText("High Tcode Activity from {0} to {1}", dates);
        Log.log("Mail headline: " + headline);
        if (tablecontent.length() == 0 && !hus.notifications_regardless) {
            Log.log("No content for mail. Regardless flag not set. Aborting sending mails.");
            return;
        }
        String content = "<h1>" + headline + "</h1>";
        if (tablecontent.length() == 0) {
            content = content + translator.getText("No recorded activity!");
        } else {
            String[] headers = new String[]{"Date", "User", "First name", "Last name", "Tcode", "Hits", "Dynpro", "Type"};
            content = content + EmailContent.makeTableHeader(headers, translator) + tablecontent + "</table>";
        }
        content = content + "<br /><br />" + translator.getText("Tcode threshold") + ": " + hus.default_threshold + "<br />" + translator.getText("Dynpro threshold") + ": " + hus.default_dynpro + "<br />" + translator.getText("User filter") + ": " + hus.default_userfilter + "<br />" + translator.getText("Maximum number of rows") + ": " + hus.max_rows + "<br />" + translator.getText("Email interval") + ": " + translator.getText(hus.notifications_interval.toString());
        String subject = "CNS Usage Monitor " + hus.system + "/" + hus.client + ": " + translator.getText("High Tcode Activity");
        Email mail = new Email(hus.notifications_sender, emails, subject, content);
        mail.send();
        Log.log("Mail sent.");
        hus.updateLastSentMail();
        Log.log("Last sent mail timestamp updated.");
    }

    private static String getTableContent(Date date_from, Date date_to, Dashboard_HighUsageSettings hus) {
        Log.log("Getting data for mail from " + date_from + " to " + date_to + ".");
        Object content = "";
        Object userfilter = "";
        if (hus.default_userfilter != null) {
            String f = hus.default_userfilter.replace("*", "%");
            userfilter = " AND (user LIKE '" + f + "' OR user = '" + f + "')";
        }
        String sql = "SELECT \tdatatable.date, \tdatatable.user, \tum_user.first_name, \tum_user.last_name, \ttcode, \ttcode_hits_that_day AS hits, \tdynpro_hits_that_day AS dynpro, \ttasktype FROM ( \tSELECT \t\tdate, \t\t`system`,        client,         user,        tcode, \t\ttasktype,        SUM(hits) AS tcode_hits_that_day,        SUM(dynpro) AS dynpro_hits_that_day     FROM prd_trace_view_hits \tWHERE \t\thits > 0 AND `system` = '" + hus.system + "' AND client = '" + hus.client + "}' AND \t\tdate >= '" + date_from + "' AND date <= '" + date_to + "' \t\t" + (String)userfilter + " \tGROUP BY user, date, tcode   ) AS datatable LEFT JOIN um_user ON um_user.system = '" + hus.system + "' AND um_user.client = '" + hus.client + "' AND um_user.user = datatable.user WHERE \t(tcode_hits_that_day >= " + hus.default_threshold + " AND \tdynpro_hits_that_day >= " + hus.default_dynpro + ") ORDER BY date DESC, tcode_hits_that_day DESC, dynpro_hits_that_day DESC LIMIT " + hus.max_rows + ";";
        ResultSet rs = DB.getData(sql);
        int resultTotal = DB.resultSetGetSize(rs);
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            Log.log("Found " + resultTotal + " entries.");
            while (rs.next()) {
                content = (String)content + "<tr>";
                for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                    int columnType = rsmd.getColumnType(columnIndex);
                    content = columnType == 4 || columnType == 2 ? (String)content + EmailContent.makeTableCell(rs.getString(columnIndex), "text-align:right;") : (String)content + EmailContent.makeTableCell(rs.getString(columnIndex), null);
                }
                content = (String)content + "</tr>";
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("FAILED! Dashboard_HighUsage.getTableContent failed to put data into table cells");
            Log.logException(e);
        }
        Log.log("Data content created.");
        return content;
    }

    private static void retentionUphold(Dashboard_HighUsageSettings hus) {
        Log.log("High Usage data retention for " + hus.system + " / " + hus.client);
        Object sql = "";
        sql = hus.retention == 0 ? "SELECT id FROM prd_trace_view_hits WHERE `system` = '" + hus.system + "' AND `client` = '" + hus.client + "';" : "SELECT id FROM prd_trace_view_hits WHERE `system` = '" + hus.system + "' AND `client` = '" + hus.client + "' AND date < DATE_SUB(curdate(), INTERVAL " + hus.retention + " DAY);";
        ResultSet recordsToDelete = DB.getData((String)sql);
        int noOfRecords = DB.resultSetGetSize(recordsToDelete);
        Log.log(noOfRecords + " records older than " + hus.retention + " days in prd_trace_view_hits " + hus.system + " / " + hus.client);
        if (noOfRecords > 0) {
            PreparedStatement update = DB.prepareStatement("DELETE FROM prd_trace_view_hits WHERE id = ? ;");
            try {
                while (recordsToDelete.next()) {
                    int recordId = recordsToDelete.getInt(1);
                    update.setInt(1, recordId);
                    update.addBatch();
                }
                update.executeBatch();
                recordsToDelete.close();
            }
            catch (SQLException e) {
                Log.log("FAILED! Dashboard_HighUsage.retentionUphold deleting records.");
                Log.logException(e);
            }
        }
    }
}

