/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.Timer;
import cn.Utils;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import um.RoleAssignments;
import um.Usage;
import um.dashboard.Dashboard_1;

class Dashboard_B {
    Dashboard_B() {
    }

    static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " um/dashboard/Dashboard_B ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("Dashboard_B (role journal usage) starting for " + system + " / " + client);
        Log.log("apm.ini feature.rolejournal can turn off rolejournal role usage calculations.");
        Dashboard_B.go(system, client);
        Log.log("Dashboard_B (role journal usage) ending for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    private static void go(String system, String client) {
        Log.log("Build Role Journal Usage system / client");
        Date startDate = Dashboard_1.getStartDate();
        Date endDate = Dashboard_1.getEndDate();
        Log.log("Start date: " + startDate + " - End date: " + endDate);
        Log.log("Getting Usage for system client");
        Usage usage = Usage.getInstance(system, client, startDate, endDate);
        Log.log("Getting id and role for system client");
        ResultSet res = DB.getData("SELECT id, role, IF(`type` = 'C', 1, 0) AS composite FROM um_role WHERE `system` = '" + system + "' AND client = '" + client + "' AND id IN (\tSELECT DISTINCT(role_id) FROM um_user_role WHERE um_delete=0 AND `system` = '" + system + "' AND client = '" + client + "');");
        int numberOfRows = DB.resultSetGetSize(res);
        if (numberOfRows > 0) {
            Log.log("Creating RJ data for " + numberOfRows + " roles.");
            PreparedStatement update = DB.prepareStatement("UPDATE um_role_journal SET usage_users = ? ,usage_tcodes = ? , last_used = ? WHERE role_id = ? ");
            int totalTcodeCount = 0;
            int totalUserCount = 0;
            int i = 0;
            int countUserUsage = 0;
            ArrayList<Integer> usedTcodes = new ArrayList<Integer>();
            Date lastUsage = null;
            int tellPoint = Utils.ceilDivider(numberOfRows, 25);
            try {
                while (res.next()) {
                    int role_id = res.getInt("id");
                    Timer t = Timer.start("Role id " + role_id);
                    int[] user_ids = RoleAssignments.getUsersWithRoleAndUsage(role_id, usage);
                    if (user_ids.length <= 0) continue;
                    totalUserCount += user_ids.length;
                    int[] tcode_ids = res.getBoolean("composite") ? RoleAssignments.getTcodesInCompositeRoleWithUsage(role_id, usage) : RoleAssignments.getTcodesInRoleWithUsage(role_id, usage);
                    if (tcode_ids.length <= 0) continue;
                    totalTcodeCount += tcode_ids.length;
                    countUserUsage = 0;
                    usedTcodes.clear();
                    boolean used = false;
                    for (int user_id : user_ids) {
                        used = false;
                        for (int tcode_id : tcode_ids) {
                            Date usageDate = usage.getLastUsage(user_id, tcode_id);
                            if (usageDate == null) continue;
                            usedTcodes.add(tcode_id);
                            used = true;
                            if (lastUsage != null) {
                                if (!usageDate.after(lastUsage)) continue;
                                lastUsage = usageDate;
                                continue;
                            }
                            lastUsage = usageDate;
                        }
                        if (!used) continue;
                        ++countUserUsage;
                    }
                    t.logTime();
                    update.setInt(1, countUserUsage);
                    update.setInt(2, Utils.countUnique(usedTcodes));
                    update.setDate(3, lastUsage);
                    update.setInt(4, role_id);
                    update.addBatch();
                    if (++i % tellPoint != 0) continue;
                    Log.log("Analyzed " + totalTcodeCount + " tcodes in " + i + " / " + numberOfRows + " roles held by " + totalUserCount + " users.");
                    update.executeBatch();
                    update.clearBatch();
                    Log.log("Saved batch");
                }
                Log.log("Analyzed " + totalTcodeCount + " tcodes in " + i + " / " + numberOfRows + " roles held by " + totalUserCount + " users.");
                res.close();
                Log.log("Updating RJ role usage data.");
                update.executeBatch();
            }
            catch (SQLException e) {
                Log.log("FAILED! updating RJ data in Dashboard_B.go().");
                Log.logException(e);
            }
        }
        Log.log("RJ usage Done.\n");
    }
}

