/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import java.sql.Date;
import um.Usage;
import um.dashboard.Algorithm;

class Dashboard_5 {
    Dashboard_5() {
    }

    static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " um/dashboard/Dashboard_5 ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("Dashboard_5 starting for " + system + " / " + client);
        Dashboard_5.go(system, client);
        Log.log("Dashboard_5 ending for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    private static void go(String system, String client) {
        Log.log("build role assignment history (SUBTYPE_DASH_5).");
        Date date = DB.getDate("SELECT DATE_SUB(CURDATE(), INTERVAL 1 DAY) date;");
        Log.log("build used roles history (SUBTYPE_DASH_5) for " + date);
        Dashboard_5.buildUsedRolesHistory(system, client, date);
        Log.log("build role assignment history (SUBTYPE_DASH_5) for " + date);
        Dashboard_5.buildRoleAssignmentHistory(system, client, date);
        Log.log("build role assignment history (SUBTYPE_DASH_5) DONE.\n");
    }

    private static void buildUsedRolesHistory(String system, String client, Date date) {
        String syscli = " `system` = '" + system + "' AND `client` = '" + client + "' ";
        Log.log("Inserting into um_dash_used_roles_history ");
        DB.update("INSERT IGNORE INTO um_dash_used_roles_history SELECT `system`, client, DATE_SUB(CURDATE(), INTERVAL 1 DAY) date, ( \tSELECT count(DISTINCT role_id) \tFROM um_user_role \tWHERE um_delete = 0 AND " + syscli + ")  allocated_roles, 0 used_roles FROM um_info AS u WHERE timestamp < curdate() AND " + syscli + "GROUP BY `system`, client;");
        Log.log("Inserting into um_dash_used_roles_history DONE");
        Usage usage = Usage.getInstance(system, client, date, null);
        int usedRolesCount = Algorithm.getUsedRolesCount(system, client, usage);
        Log.log("usedRoles(" + system + " / " + client + ", " + date + ") = " + usedRolesCount);
        DB.update("UPDATE um_dash_used_roles_history SET used_roles = " + usedRolesCount + " WHERE date = '" + date + "' AND " + syscli);
    }

    private static void buildRoleAssignmentHistory(String system, String client, Date date) {
        String syscli = " `system` = '" + system + "' AND `client` = '" + client + "' ";
        Log.log("INSERT IGNORE INTO um_dash_role_assignment_history ");
        DB.update("INSERT IGNORE INTO um_dash_role_assignment_history SELECT `system`, `client`, DATE_SUB(CURDATE(), INTERVAL 1 DAY) date, (\tSELECT count(*) \tFROM um_user_role AS ur \tWHERE um_delete = 0 AND " + syscli + ")  role_assignments, 0 role_usages FROM um_info AS i WHERE timestamp < curdate() AND " + syscli + "GROUP BY `system`, client;");
        Log.log("INSERT IGNORE INTO um_dash_role_assignment_history DONE");
        Usage usage = Usage.getInstance(system, client, date, null);
        int roleUsageCount = Algorithm.getRoleUsageCount(system, client, usage);
        Log.log("roleUsage (" + system + " / " + client + ", " + date + ") = " + roleUsageCount);
        DB.update("UPDATE um_dash_role_assignment_history SET role_usages = " + roleUsageCount + " WHERE date = '" + date + "' AND " + syscli + ";");
    }
}

