/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;

class Dashboard_1 {
    private static Date startDate;
    private static Date endDate;
    private static String unusedTcodesTable;
    private static String umUnusedTcodesTable;

    Dashboard_1() {
    }

    static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " um/dashboard/Dashboard_1 ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("Dashboard_1 starting for " + system + " / " + client);
        Dashboard_1.go(system, client);
        Log.log("Dashboard_1 ending for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    static Date getStartDate() {
        if (startDate == null || endDate == null) {
            Dashboard_1.loadDates();
        }
        return startDate;
    }

    static Date getEndDate() {
        if (startDate == null || endDate == null) {
            Dashboard_1.loadDates();
        }
        return endDate;
    }

    private static void go(String system, String client) {
        Log.log("build unused tcodes and history (SUBTYPE_DASH_1) done.");
        unusedTcodesTable = "`um_dash_unused_tcodes_" + system.toLowerCase() + "_" + client.toLowerCase() + "`";
        umUnusedTcodesTable = "'um_usage_" + system.toLowerCase() + "_" + client.toLowerCase() + "'";
        Log.log("build unused tcodes (SUBTYPE_DASH_1) from " + Dashboard_1.getStartDate() + " to " + Dashboard_1.getEndDate() + ".");
        Dashboard_1.buildUnusedTcodes(system, client);
        Log.log("build unused tcodes history (SUBTYPE_DASH_1) from " + Dashboard_1.getStartDate() + " to " + Dashboard_1.getEndDate() + ".");
        Dashboard_1.buildUnusedTcodesHistory(system, client);
        Log.log("build unused tcodes and history (SUBTYPE_DASH_1) done.\n");
    }

    private static void loadDates() {
        ResultSet rs = DB.getData("SELECT CURDATE() end, DATE_SUB(CURDATE(), INTERVAL 12 MONTH) start");
        try {
            if (rs.next()) {
                startDate = rs.getDate("start");
                endDate = rs.getDate("end");
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("FAILED Dashboard_1 getting start date and end date");
            Log.logException(e);
        }
    }

    private static void buildUnusedTcodes(String system, String client) {
        Log.log("Build Unused Tcodes for " + system + " / " + client + " begin.");
        Log.log("Dropping " + unusedTcodesTable);
        DB.update("DROP TABLE IF EXISTS " + unusedTcodesTable + ";");
        Log.log("Creating " + unusedTcodesTable + " with assigned tcodes.");
        DB.update("CREATE TABLE " + unusedTcodesTable + " ( \t`tcode_id` int(11) NOT NULL, \t`last_used_date` date NOT NULL DEFAULT '0000-00-00', \tPRIMARY KEY (`tcode_id`) )SELECT DISTINCT(tcode_id) AS tcode_id FROM um_role_tcode WHERE `system` = '" + system + "' AND `client` = '" + client + "' AND (um_delete = 0 OR um_delete IS NULL);");
        long startTime = System.nanoTime();
        Log.log("Get Tcode Last Used Dates.");
        DB.update("call um_update_unused_tcodes(" + umUnusedTcodesTable + ",'" + system.toLowerCase() + "','" + client.toLowerCase() + "');");
        long endTime = System.nanoTime();
        Log.log("Build Unused Tcodes took " + (endTime - startTime) + " NanoSec");
        Log.log("Build Unused Tcodes for " + system + " / " + client + " complete.\n");
    }

    private static void buildUnusedTcodesHistory(String system, String client) {
        Log.log("Building um_dash_unused_tcodes_history for " + system + " / " + client);
        Log.log("Calculate and update unused Tcodes.");
        int count_unused_tcodes = DB.getOneInt("SELECT COUNT(tcode_id) AS count_unused_tcodes FROM " + unusedTcodesTable + " WHERE last_used_date < DATE_SUB(CURDATE(), INTERVAL 12 MONTH);");
        Log.log("Found " + count_unused_tcodes + " unused tcodes found in " + unusedTcodesTable);
        int count_allocated_tcodes = DB.getOneInt("SELECT COUNT(tcode_id) AS count_allocated_tcodes FROM " + unusedTcodesTable);
        Log.log("Found " + count_allocated_tcodes + " allocated tcodes found in " + unusedTcodesTable);
        DB.update("INSERT INTO um_dash_unused_tcodes_history \t\t(`system`, client, date, count_allocated_tcodes, count_unused_tcodes) VALUES ('" + system + "', '" + client + "', CURDATE(), " + count_allocated_tcodes + "," + count_unused_tcodes + ") AS myData ON DUPLICATE KEY UPDATE \t`count_allocated_tcodes` = myData.count_allocated_tcodes, `count_unused_tcodes` = myData.count_unused_tcodes;");
        Log.log("Updated um_dash_unused_tcodes_history for " + system + " / " + client + " with " + count_allocated_tcodes + " allocated and " + count_unused_tcodes + " unused.\n");
    }
}

