/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.task.Task;
import cn.task.TaskHandler;
import um.dashboard.Dashboard_1;
import um.dashboard.Dashboard_2;
import um.dashboard.Dashboard_4;
import um.dashboard.Dashboard_5;
import um.dashboard.Dashboard_6;
import um.dashboard.Dashboard_7;
import um.dashboard.Dashboard_9;
import um.dashboard.Dashboard_A;
import um.dashboard.Dashboard_B;
import um.dashboard.Dashboard_HighUsage;
import um.dashboard.Dashboard_L1;
import um.dashboard.Dashboard_OrgLevelFields;
import um.dashboard.Dashboard_ProgramUsage;
import um.dashboard.Dashboard_SapStar;
import um.dashboard.RTR;
import um.dashboard.Trace;

public class Dashboard {
    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        Task task = Task.getById(myArgs.getInt("taskid"));
        if (task.system.equalsIgnoreCase("---") || task.client.equalsIgnoreCase("---")) {
            Log.log("IGNORING SYSTEM / CLIENT " + task.system + " / " + task.client);
        } else {
            Log.log("Ready to start Dashboard calculations (" + task.system + " / " + task.client + ").\n");
            String params = "inifile=" + Config.getIniPath() + " user=" + Config.getRemoteUser() + " system=" + task.system + " client=" + task.client + " ";
            String logfile = "logfile=" + Log.getFilename();
            task.setName("ETL RTR");
            TaskHandler.executeJVM(RTR.getExecutionString() + params + logfile + "_RTR.log", task);
            task.setName("ETL Trace");
            TaskHandler.executeJVM(Trace.getExecutionString() + params + logfile + "_Trace.log", task);
            task.setName("ETL 1");
            TaskHandler.executeJVM(Dashboard_1.getExecutionString() + params + logfile + "_ETL-1.log", task);
            Dashboard_2.go(task.system, task.client);
            Dashboard_4.go(task.system, task.client);
            task.setName("ETL 5");
            TaskHandler.executeJVM(Dashboard_5.getExecutionString() + params + logfile + "_ETL-5.log", task);
            Dashboard_6.go(task.system, task.client);
            Dashboard_7.go(task.system, task.client);
            Dashboard_9.go(task.system, task.client);
            Dashboard_A.go(task.system, task.client);
            task.setName("ETL Licenses and user comparison report");
            TaskHandler.executeJVM(Dashboard_L1.getExecutionString() + params + logfile + "_ETL-L1.log", task);
            if (Config.isFeature("rolejournal", true)) {
                task.setName("ETL Role Journal usage");
                TaskHandler.executeJVM(Dashboard_B.getExecutionString() + params + logfile + "_ETL-B(rolejournalusage).log", task);
            } else {
                Log.log("apm.ini feature.rolejournal has turned off rolejournal role usage calculations.");
            }
            task.setName("ETL High Usage");
            TaskHandler.executeJVM(Dashboard_HighUsage.getExecutionString() + params + logfile + "_ETL-HighUsage.log", task);
            task.setName("ETL Program Usage");
            TaskHandler.executeJVM(Dashboard_ProgramUsage.getExecutionString() + params + logfile + "_ETL-ProgramUsage.log", task);
            Dashboard_OrgLevelFields.go(task.system, task.client);
            Dashboard_SapStar.go(task.system, task.client);
            Log.log("Dashboard calculations job finished.\n");
        }
        DB.close();
        Log.close();
    }
}

