/*
 * Decompiled with CFR 0.152.
 */
package um.dashboard;

import cn.Log;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import um.RoleAssignments;
import um.Usage;
import um.UsageRecord;

class Algorithm {
    Algorithm() {
    }

    public static int getUsedRolesCount(String system, String client, Usage usage) {
        int roleCount = 0;
        UsageRecord[] uts = usage.getUsageArray();
        if (uts != null) {
            Log.log("Algorithm.getUsedRolesCount " + uts.length + " usage records");
            for (int role_id : RoleAssignments.getRoleIds(system, client)) {
                boolean roleShouldBeCounted = true;
                int[] users = RoleAssignments.getUsersWithRole(role_id);
                int[] tcodes = RoleAssignments.getTcodesInRole(role_id);
                for (UsageRecord ut : uts) {
                    if (!roleShouldBeCounted || !ArrayUtils.contains((int[])users, (int)ut.getUser_id()) || !ArrayUtils.contains((int[])tcodes, (int)ut.getTcode_id())) continue;
                    ++roleCount;
                    roleShouldBeCounted = false;
                }
            }
        }
        return roleCount;
    }

    public static int getRoleUsageCount(String system, String client, Usage usage) {
        HashMap<CallSite, Integer> allUserRoles = new HashMap<CallSite, Integer>();
        UsageRecord[] uts = usage.getUsageArray();
        if (uts != null) {
            Log.log("Algorithm.getRoleUsageCount " + uts.length + " usage records");
            for (int role_id : RoleAssignments.getRoleIds(system, client)) {
                int[] users = RoleAssignments.getUsersWithRole(role_id);
                int[] tcodes = RoleAssignments.getTcodesInRole(role_id);
                for (UsageRecord ut : uts) {
                    if (!ArrayUtils.contains((int[])users, (int)ut.getUser_id()) || !ArrayUtils.contains((int[])tcodes, (int)ut.getTcode_id())) continue;
                    String userRoleKey = ut.getUser_id() + "-" + role_id;
                    allUserRoles.put((CallSite)((Object)userRoleKey), 1);
                }
            }
        }
        return allUserRoles.size();
    }

    public static HashMap<Integer, int[]> getUserRoleUsageLazy(String system, String client, Usage usage) {
        HashMap<Integer, ArrayList> allUserRoles = new HashMap<Integer, ArrayList>();
        UsageRecord[] uts = usage.getUsageArray();
        HashMap<Integer, Integer> tcodeCountPerUser = new HashMap<Integer, Integer>();
        UsageRecord[] usageRecordArray = uts;
        int n = usageRecordArray.length;
        for (int j = 0; j < n; ++j) {
            UsageRecord ut = usageRecordArray[j];
            if (!allUserRoles.containsKey(ut.getUser_id())) {
                allUserRoles.put(ut.getUser_id(), new ArrayList());
                tcodeCountPerUser.put(ut.getUser_id(), 0);
            }
            if (ut.getTcode_id() == 0) {
                ArrayList value = (ArrayList)allUserRoles.get(ut.getUser_id());
                value.add(0, 0);
                allUserRoles.put(ut.getUser_id(), value);
                continue;
            }
            int next = (Integer)tcodeCountPerUser.get(ut.getUser_id()) + 1;
            tcodeCountPerUser.put(ut.getUser_id(), next);
        }
        for (Map.Entry entry : tcodeCountPerUser.entrySet()) {
            if ((Integer)entry.getValue() <= 0) continue;
            allUserRoles.put((Integer)entry.getKey(), new ArrayList());
        }
        for (int role_id : RoleAssignments.getRoleIds(system, client)) {
            int[] users = RoleAssignments.getUsersWithRole(role_id);
            int[] tcodes = RoleAssignments.getTcodesInRole(role_id);
            for (UsageRecord ut : uts) {
                ArrayList role_ids;
                if (!ArrayUtils.contains((int[])users, (int)ut.getUser_id()) || !ArrayUtils.contains((int[])tcodes, (int)ut.getTcode_id()) || (role_ids = (ArrayList)allUserRoles.get(ut.getUser_id())).contains(role_id)) continue;
                role_ids.add(role_id);
                allUserRoles.put(ut.getUser_id(), role_ids);
            }
        }
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        for (Map.Entry entry : allUserRoles.entrySet()) {
            int[] myFinalRoleIds = ((ArrayList)entry.getValue()).stream().mapToInt(i -> i).toArray();
            hashMap.put((Integer)entry.getKey(), myFinalRoleIds);
        }
        return hashMap;
    }
}

