/*
 * Decompiled with CFR 0.152.
 */
package um;

import cn.DB;
import cn.Log;
import cn.Role;
import cn.SapUser;
import cn.Tcode;
import cn.Utils;
import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import um.LicenseCategory;

public class UsageRole
extends Role {
    private static final HashMap<Integer, UsageRole> loadedRoles = new HashMap();
    public static final UsageRole[] EMPTY_ROLEARRAY = new UsageRole[0];
    private UsageRole[] compositeChildren = null;
    private ArrayList<Tcode> umTcodes = null;
    private String[] umTcodeNames = null;
    public final int license_category_id;
    public boolean dash_ignore_tcodes = false;
    private int tcount = -1;
    private int ucount = -1;
    private static PreparedStatement PS_LOAD_CHILDREN = null;
    private static final ArrayList<UsageRole> children = new ArrayList();
    private static PreparedStatement PS_UMtcodes = null;
    public static long timeSpentLoadingUserCount = 0L;
    private static PreparedStatement PS_loadUserCount = null;
    private String[] usernames = null;
    private SapUser[] userRoleAssigned = null;
    public static long timeSpentLoadingUsers = 0L;
    private static PreparedStatement ps_getUsers = null;
    private static HashMap<String, UsageRole[]> rolesByTcode = new HashMap();
    private static boolean allNotLoaded = true;
    private static PreparedStatement PS_getRolesForUser = null;

    public UsageRole(int id, String name, String description, boolean isComposite, String system, String client, int license_category_id) {
        super(id, name, description, isComposite, system, client);
        this.license_category_id = license_category_id;
    }

    public static boolean exists(int role_id) {
        return loadedRoles.containsKey(role_id);
    }

    public static UsageRole getExisting(int role_id) {
        return loadedRoles.get(role_id);
    }

    public static UsageRole create(int id, String name, String description, boolean isComposite, String system, String client, int license_category_id) {
        UsageRole role = new UsageRole(id, name, description, isComposite, system, client, license_category_id);
        loadedRoles.put(id, role);
        return role;
    }

    public String getLicenseCategoryName() {
        LicenseCategory lc = LicenseCategory.getById(this.license_category_id);
        return lc == null ? "" : lc.getName();
    }

    public LicenseCategory getLicenseCategory() {
        return LicenseCategory.getById(this.license_category_id);
    }

    public String[] getUMTcodeNames() {
        if (this.umTcodeNames == null) {
            this.getUMTcodes();
        }
        return this.umTcodeNames;
    }

    private UsageRole[] getCompositeChildren() {
        if (this.compositeChildren == null) {
            children.clear();
            if (PS_LOAD_CHILDREN == null) {
                PS_LOAD_CHILDREN = DB.prepareStatement("SELECT r.id, r.role, r.description, r.system, r.client, r.license_category_id FROM um_role_comp AS rc JOIN um_role AS r ON rc.single=r.id AND rc.um_delete=0 WHERE rc.composite = ?;");
            }
            try {
                PS_LOAD_CHILDREN.setInt(1, this.id);
                ResultSet rs = PS_LOAD_CHILDREN.executeQuery();
                while (rs.next()) {
                    int role_id = rs.getInt("id");
                    if (UsageRole.exists(role_id)) {
                        children.add(UsageRole.getExisting(role_id));
                        continue;
                    }
                    children.add(new UsageRole(role_id, rs.getString("role"), rs.getString("description"), false, rs.getString("system"), rs.getString("client"), rs.getInt("license_category_id")));
                }
                rs.close();
            }
            catch (Exception e) {
                Log.log("um.UsageRole.getCompositeChildren() FAILED to load children of composite role risk id: " + this.id);
                Log.logException(e);
            }
            this.compositeChildren = children.toArray(EMPTY_ROLEARRAY);
        }
        return this.compositeChildren;
    }

    public ArrayList<Tcode> getUMTcodes() {
        if (this.umTcodes == null) {
            this.umTcodes = new ArrayList();
            if (this.isComposite) {
                ArrayList<String> umTcodeNamesTmp = new ArrayList<String>();
                for (UsageRole child : this.getCompositeChildren()) {
                    for (Tcode tcode : child.getUMTcodes()) {
                        this.umTcodes.add(tcode);
                        umTcodeNamesTmp.add(tcode.name);
                    }
                }
                this.umTcodeNames = umTcodeNamesTmp.toArray(Utils.EMPTYSTRINGARRAY);
                this.tcount = this.umTcodes.size();
            } else {
                this.loadUMTcodes(this.id);
            }
        }
        return this.umTcodes;
    }

    private void loadUMTcodes(int role_id) {
        if (PS_UMtcodes == null) {
            PS_UMtcodes = DB.prepareStatement("SELECT um_tcode.id, um_tcode.tcode, um_tcode.description FROM um_role_tcode \nINNER JOIN um_tcode ON um_tcode.id = um_role_tcode.tcode_id \nWHERE role_id = ? AND um_role_tcode.um_delete = 0 AND um_tcode.um_delete = 0;");
        }
        try {
            ArrayList<String> umTcodeNamesTmp = new ArrayList<String>();
            PS_UMtcodes.setInt(1, this.id);
            ResultSet rs = PS_UMtcodes.executeQuery();
            while (rs.next()) {
                this.umTcodes.add(Tcode.create(rs.getInt(1), rs.getString(2), rs.getString(3)));
                umTcodeNamesTmp.add(rs.getString(2));
            }
            rs.close();
            this.umTcodeNames = umTcodeNamesTmp.toArray(Utils.EMPTYSTRINGARRAY);
            this.tcount = this.umTcodes.size();
        }
        catch (Exception e) {
            Log.log("cn.Role.getUMTcodes() loading UM tcodes FAILED!");
            Log.logException(e);
        }
    }

    public void setTcodeCount(int tcount) {
        this.tcount = tcount;
    }

    public int getTcodeCount() {
        if (this.tcount < 0) {
            if (this.isComposite) {
                this.tcount = 0;
                for (UsageRole child : this.getCompositeChildren()) {
                    this.tcount += child.getTcodeCount();
                }
            } else {
                this.tcount = this.getUMTcodes().size();
            }
        }
        return this.tcount;
    }

    public boolean hasTcode(String tcode) {
        for (String tcodeInRole : this.getUMTcodeNames()) {
            if (!tcode.contentEquals(tcodeInRole)) continue;
            return true;
        }
        return false;
    }

    public void setUserCount(int ucount) {
        this.ucount = ucount;
    }

    public int getUserCount() {
        long startTime = System.currentTimeMillis();
        if (this.ucount < 0) {
            if (PS_loadUserCount == null) {
                String sql = "SELECT COUNT(user_id) AS c FROM um_user_role WHERE role_id = ? ;";
                Log.log("cn.Role getUserCount preparing statement: " + sql);
                PS_loadUserCount = DB.prepareStatement(sql);
            }
            try {
                PS_loadUserCount.setInt(1, this.id);
            }
            catch (Exception e) {
                Log.log("cn.Role getUserCount FAILED!");
                Log.logException(e);
            }
            this.ucount = DB.preparedStatementGetCount(PS_loadUserCount);
        }
        timeSpentLoadingUserCount += System.currentTimeMillis() - startTime;
        return this.ucount;
    }

    public String[] getUserNames() {
        if (this.usernames == null) {
            this.getUsers();
        }
        return this.usernames;
    }

    public SapUser[] getUsers() {
        if (this.userRoleAssigned == null) {
            UsageRole.loadUsers(this);
        }
        return this.userRoleAssigned;
    }

    private static void loadUsers(UsageRole role) {
        long startTime = System.currentTimeMillis();
        if (ps_getUsers == null) {
            String sql = "SELECT u.id, u.user FROM um_user AS u INNER JOIN um_user_role AS ur ON ur.user_id = u.id WHERE ur.role_id = ? AND u.um_delete = 0 AND ur.um_delete = 0;";
            Log.log("cn.Role loadUsers preparing statement:\n" + sql);
            ps_getUsers = DB.prepareStatement(sql);
        }
        ArrayList<SapUser> users = new ArrayList<SapUser>();
        ArrayList<String> usernames = new ArrayList<String>();
        try {
            ps_getUsers.setInt(1, role.id);
            ResultSet rs = ps_getUsers.executeQuery();
            while (rs.next()) {
                users.add(SapUser.createUser(rs.getInt(1), rs.getString(2), role.system, role.client));
                usernames.add(rs.getString(2));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("cn.Role loadUsers FAILED!");
            Log.logException(e);
        }
        role.userRoleAssigned = users.toArray(new SapUser[0]);
        role.usernames = usernames.toArray(Utils.EMPTYSTRINGARRAY);
        role.ucount = role.userRoleAssigned.length;
        timeSpentLoadingUsers += System.currentTimeMillis() - startTime;
    }

    public static UsageRole[] getRolesWithTcode(String tcode, String system, String client) {
        if (!rolesByTcode.containsKey(tcode)) {
            ArrayList<UsageRole> rolesWtcode = new ArrayList<UsageRole>();
            for (UsageRole role : UsageRole.getAllRoles(system, client)) {
                if (!role.hasTcode(tcode)) continue;
                rolesWtcode.add(role);
            }
            rolesByTcode.put(tcode, rolesWtcode.toArray(EMPTY_ROLEARRAY));
        }
        return rolesByTcode.get(tcode);
    }

    private static UsageRole[] getAllRoles(String system, String client) {
        Integer[] loadedRoleIds;
        if (allNotLoaded) {
            loadedRoleIds = loadedRoles.keySet().toArray(new Integer[0]);
            ArrayList<String> sids = new ArrayList<String>();
            for (Integer i : loadedRoleIds) {
                sids.add(i.toString());
            }
            String loadedIds = Utils.toQuotedString(sids.toArray(Utils.EMPTYSTRINGARRAY));
            String sql = "SELECT id, `type`, `role`, `description`, `license_category_id` FROM um_role WHERE `system` = '" + system + "' AND `client` = '" + client + "' AND um_delete = 0 ";
            if (loadedIds.length() > 0) {
                sql = sql + "AND id NOT IN (" + loadedIds + ")";
            }
            ResultSet rs = DB.getData(sql);
            try {
                while (rs.next()) {
                    int role_id = rs.getInt(1);
                    UsageRole role = new UsageRole(role_id, rs.getString(3), rs.getString(4), rs.getString(2).contentEquals("C"), system, client, rs.getInt(5));
                    loadedRoles.put(role_id, role);
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("UsageRole getAllRoles failed!");
                Log.logException(e);
            }
        }
        loadedRoleIds = loadedRoles.keySet().toArray(new Integer[0]);
        UsageRole[] allRoles = new UsageRole[loadedRoleIds.length];
        for (int i = 0; i < loadedRoleIds.length; ++i) {
            allRoles[i] = loadedRoles.get(loadedRoleIds[i]);
        }
        return allRoles;
    }

    private static UsageRole[] getRoles(String system, String client, int[] role_ids) {
        ArrayList<CallSite> sids = new ArrayList<CallSite>();
        for (int role_id : role_ids) {
            if (loadedRoles.containsKey(role_id)) continue;
            sids.add((CallSite)((Object)("" + role_id)));
        }
        String loadIds = Utils.toQuotedString(sids.toArray(Utils.EMPTYSTRINGARRAY));
        if (loadIds.length() > 0) {
            String sql = "SELECT id, `type`, `role`, `description`, `license_category_id` FROM um_role WHERE `system` = '" + system + "' AND `client` = '" + client + "' AND um_delete = 0 AND id IN (" + loadIds + ")";
            ResultSet rs = DB.getData(sql);
            try {
                while (rs.next()) {
                    int role_id;
                    role_id = rs.getInt(1);
                    UsageRole role = new UsageRole(role_id, rs.getString(3), rs.getString(4), rs.getString(2).contentEquals("C"), system, client, rs.getInt(5));
                    loadedRoles.put(role_id, role);
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("UsageRole getAllRoles failed!");
                Log.logException(e);
            }
        }
        UsageRole[] roles = new UsageRole[role_ids.length];
        for (int i = 0; i < role_ids.length; ++i) {
            roles[i] = loadedRoles.get(role_ids[i]);
        }
        return roles;
    }

    public static UsageRole[] getRolesForUser(SapUser user) {
        if (PS_getRolesForUser == null) {
            PS_getRolesForUser = DB.prepareStatement("SELECT role_id FROM um_user_role WHERE `system` = '" + user.system + "' AND `client` = '" + user.client + "' AND um_delete = 0 AND user_id = ?;");
        }
        try {
            PS_getRolesForUser.setInt(1, user.getId());
            int[] role_ids = DB.preparedStatementGetOneIntColumn(PS_getRolesForUser);
            return UsageRole.getRoles(user.system, user.client, role_ids);
        }
        catch (SQLException e) {
            Log.log("um.UsageRole getRolesForUser FAILED!");
            Log.logException(e);
            return EMPTY_ROLEARRAY;
        }
    }
}

