/*
 * Decompiled with CFR 0.152.
 */
package um;

import cn.DB;
import cn.Log;
import cn.SapUser;
import cn.Tcode;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import um.UsageRecord;
import um.UsageRole;

public class Usage {
    private static final ArrayList<Usage> currentUsage = new ArrayList();
    private final String system;
    private final String client;
    private final Date startDate;
    private final Date endDate;
    private final UsageRecord[] usageArray;
    private final HashMap<Integer, ArrayList<UsageRecord>> usageMapTcode = new HashMap();
    private final HashMap<Integer, ArrayList<UsageRecord>> usageMapUsers = new HashMap();
    private static SapUser currentUser = new SapUser("", "", "");
    private static HashMap<String, Integer> sapUserDaysUsedTcode = new HashMap();
    private static PreparedStatement PS_getDaysUsed = null;
    private HashMap<String, String> typeDescriptions = null;

    public static String getUsageTable(String system, String client) {
        return "um_usage_" + system.toLowerCase() + "_" + client.toLowerCase();
    }

    public static Usage getInstance(String system, String client, Date startDate, Date endDate) {
        for (Usage u : currentUsage) {
            if (!(u.endDate == null ? u.system.equalsIgnoreCase(system) && u.client.equalsIgnoreCase(client) && u.startDate.compareTo(startDate) == 0 && u.endDate == endDate : u.system.equalsIgnoreCase(system) && u.client.equalsIgnoreCase(client) && u.startDate.compareTo(startDate) == 0 && u.endDate.compareTo(endDate) == 0)) continue;
            return u;
        }
        Usage u = new Usage(system, client, startDate, endDate);
        currentUsage.add(u);
        return u;
    }

    private Usage(String system, String client, Date startDate, Date endDate) {
        this.system = system;
        this.client = client;
        this.startDate = startDate;
        this.endDate = endDate;
        this.usageArray = this.loadStandardUsageArray();
    }

    private Usage(String system, String client, Date startDate, Date endDate, String sqlStatement) {
        this.system = system;
        this.client = client;
        this.startDate = startDate;
        this.endDate = endDate;
        this.usageArray = this.loadCustomUsageArray(sqlStatement);
    }

    public UsageRecord[] getUsageArray() {
        return this.usageArray;
    }

    public int getNumberOfUser() {
        return this.usageMapUsers.keySet().size();
    }

    public Set<Integer> getUserIds() {
        return this.usageMapUsers.keySet();
    }

    public ArrayList<Tcode> getTcodesUsedByUser(int user_id) {
        ArrayList<Tcode> tcodes = new ArrayList<Tcode>();
        for (UsageRecord ur : this.usageMapUsers.get(user_id)) {
            tcodes.add(Tcode.getById(ur.tcode_id));
        }
        return tcodes;
    }

    public boolean isUsedUser(int user_id) {
        return this.usageMapUsers.containsKey(user_id);
    }

    public boolean isUsedTcode(int tcode_id) {
        return this.usageMapTcode.containsKey(tcode_id);
    }

    public int getDaysUsed(SapUser user, Tcode tcode) {
        int count;
        block4: {
            count = 0;
            if (!this.isUsedUser(user.getId()) || !this.isUsedTcode(tcode.id)) break block4;
            if (this.usageMapUsers.get(user.getId()).size() > this.usageMapTcode.get(tcode.id).size()) {
                for (UsageRecord ur : this.usageMapTcode.get(tcode.id)) {
                    if (ur.user_id != user.getId()) continue;
                    return ur.usage;
                }
            } else {
                for (UsageRecord ur : this.usageMapUsers.get(user.getId())) {
                    if (ur.tcode_id != tcode.id) continue;
                    return ur.usage;
                }
            }
        }
        return count;
    }

    public static int getDaysUsed(SapUser sapUser, String tcodename) {
        if (!sapUser.username.contentEquals(Usage.currentUser.username)) {
            if (PS_getDaysUsed == null) {
                Date startDate = DB.getDate("SELECT DATE_SUB(NOW(), INTERVAL 1 YEAR);");
                Date endDate = DB.getDate("SELECT NOW();");
                String table = Usage.getUsageTable(sapUser.system, sapUser.client);
                PS_getDaysUsed = DB.prepareStatement("SELECT `tcode`, COUNT(DISTINCT(usagetable.date)) AS `usage` FROM `" + table + "` AS usagetable\nWHERE \t`user` = ? AND \t`date` >= '" + startDate.toString() + "' AND \t`date` <= '" + endDate.toString() + "' AND \t`date` <> '0000-00-00' GROUP BY `tcode`;");
            }
            currentUser = sapUser;
            sapUserDaysUsedTcode.clear();
            try {
                PS_getDaysUsed.setString(1, sapUser.username);
                ResultSet rs = PS_getDaysUsed.executeQuery();
                while (rs.next()) {
                    sapUserDaysUsedTcode.put(rs.getString(1), rs.getInt(2));
                }
            }
            catch (Exception e) {
                Log.log("Usage.getDaysUsed Error getting usage for " + sapUser.getToFullString());
            }
        }
        if (sapUserDaysUsedTcode.containsKey(tcodename)) {
            return sapUserDaysUsedTcode.get(tcodename);
        }
        return 0;
    }

    public Date getLastUsage(int user_id, int tcode_id) {
        block4: {
            if (!this.isUsedUser(user_id) || !this.isUsedTcode(tcode_id)) break block4;
            if (this.usageMapUsers.get(user_id).size() > this.usageMapTcode.get(tcode_id).size()) {
                for (UsageRecord ur : this.usageMapTcode.get(tcode_id)) {
                    if (ur.user_id != user_id) continue;
                    return ur.last_used;
                }
            } else {
                for (UsageRecord ur : this.usageMapUsers.get(user_id)) {
                    if (ur.tcode_id != tcode_id) continue;
                    return ur.last_used;
                }
            }
        }
        return null;
    }

    public Date getLastUsage(int tcode_id, int[] user_ids) {
        Date lastUsed = Date.valueOf("0001-01-01");
        if (this.isUsedTcode(tcode_id)) {
            for (UsageRecord ur : this.usageMapTcode.get(tcode_id)) {
                for (int user_id : user_ids) {
                    if (ur.getUser_id() != user_id || ur.getLast_used().compareTo(lastUsed) <= 0) continue;
                    lastUsed = ur.getLast_used();
                }
            }
        }
        return lastUsed;
    }

    public Date getLastUsage(int tcode_id) {
        Date lastUsed = Date.valueOf("0001-01-01");
        if (this.isUsedTcode(tcode_id)) {
            for (UsageRecord ur : this.usageMapTcode.get(tcode_id)) {
                if (ur.getLast_used().compareTo(lastUsed) <= 0) continue;
                lastUsed = ur.getLast_used();
            }
        }
        return lastUsed;
    }

    public String getLastUsage(UsageRole role) {
        Date lastUsed = Date.valueOf("0001-01-01");
        for (SapUser su : role.getUsers()) {
            if (!this.isUsedUser(su.getId())) continue;
            for (Tcode tcode : role.getUMTcodes()) {
                if (!this.isUsedTcode(tcode.id)) continue;
                for (UsageRecord ur : this.usageMapUsers.get(su.getId())) {
                    if (ur.getTcode_id() != tcode.id || ur.getLast_used().compareTo(lastUsed) <= 0) continue;
                    lastUsed = ur.getLast_used();
                }
            }
        }
        if (lastUsed.toString().equalsIgnoreCase("0001-01-01")) {
            return "";
        }
        return lastUsed.toString();
    }

    public String getLastUsage(int user_id, UsageRole role) {
        Date lastUsed = Date.valueOf("0001-01-01");
        if (this.isUsedUser(user_id)) {
            for (Tcode tcode : role.getUMTcodes()) {
                if (!this.isUsedTcode(tcode.id)) continue;
                for (UsageRecord ur : this.usageMapUsers.get(user_id)) {
                    if (ur.getTcode_id() != tcode.id || ur.getLast_used().compareTo(lastUsed) <= 0) continue;
                    lastUsed = ur.getLast_used();
                }
            }
        }
        if (lastUsed.toString().equalsIgnoreCase("0001-01-01")) {
            return "";
        }
        return lastUsed.toString();
    }

    public String getLastUsage(Tcode tcode, UsageRole role) {
        Date lastUsed = Date.valueOf("0001-01-01");
        if (this.isUsedTcode(tcode.id)) {
            for (SapUser su : role.getUsers()) {
                if (!this.isUsedUser(su.getId())) continue;
                for (UsageRecord ur : this.usageMapUsers.get(su.getId())) {
                    if (ur.getTcode_id() != tcode.id || ur.getLast_used().compareTo(lastUsed) <= 0) continue;
                    lastUsed = ur.getLast_used();
                }
            }
        }
        if (lastUsed.toString().equalsIgnoreCase("0001-01-01")) {
            return "";
        }
        return lastUsed.toString();
    }

    public static Usage getUsageFromStatement(String sql, String system, String client, Date from, Date to) {
        return new Usage(system, client, from, to, sql);
    }

    private UsageRecord[] loadCustomUsageArray(String statement) {
        Log.log("Loading custom usage for " + this.system + " / " + this.client + " " + this.startDate + " " + this.endDate);
        try {
            ResultSet rs = DB.getData(statement);
            int totalUsageRows = DB.resultSetGetSize(rs);
            Log.log("Loaded original usage. Found " + totalUsageRows + " rows of usage.");
            UsageRecord[] orgUsage = new UsageRecord[totalUsageRows];
            int i = 0;
            while (rs.next()) {
                UsageRecord ur = new UsageRecord(rs.getString("user"), rs.getString("tcode"), rs.getString("type"), rs.getString("program"), rs.getDate("last_used"), rs.getInt("usage"));
                orgUsage[i++] = ur;
            }
            rs.close();
            return this.handleUsageRecords(orgUsage);
        }
        catch (Exception e) {
            Log.log("um.Usage loadCustomUsageArray FAILED! Statement:\n" + statement);
            Log.logException(e);
            Log.log("NO USAGE EXISTS for " + this.system + " / " + this.client);
            return new UsageRecord[0];
        }
    }

    private UsageRecord[] loadStandardUsageArray() {
        Log.log("Loading standard usage for " + this.system + " / " + this.client + " " + this.startDate + " " + this.endDate);
        String usageTable = Usage.getUsageTable(this.system, this.client);
        if (DB.isTable(usageTable)) {
            String dateClaus = this.endDate == null ? "`date` = '" + this.startDate + "' " : "`date` BETWEEN '" + this.startDate + "' AND '" + this.endDate + "'";
            String statement = "SELECT user, tcode, COUNT(DISTINCT(`date`)) AS `usage`, MAX(date) AS last_used FROM `" + usageTable + "` WHERE (" + dateClaus + ") AND \t`tcode` <> '' AND \t`tcode` NOT IN (SELECT service FROM um_service WHERE `system` = '" + this.system + "' AND `client` = '" + this.client + "') AND \t`tcode` NOT IN (SELECT `start` FROM um_start WHERE `system` = '" + this.system + "' AND `client` = '" + this.client + "') AND \t`date` <> '0000-00-00' GROUP BY user, tcode;";
            try {
                ResultSet rs = DB.getData(statement);
                int totalUsageRows = DB.resultSetGetSize(rs);
                Log.log("Loaded original usage. Found " + totalUsageRows + " rows of usage.");
                UsageRecord[] orgUsage = new UsageRecord[totalUsageRows];
                int i = 0;
                while (rs.next()) {
                    UsageRecord ur = new UsageRecord(rs.getString("user"), rs.getString("tcode"), rs.getInt("usage"), rs.getDate("last_used"));
                    orgUsage[i++] = ur;
                }
                rs.close();
                Log.log("DONE Loading standard usage for " + this.system + " / " + this.client + " " + this.startDate + " " + this.endDate);
                return this.handleUsageRecords(orgUsage);
            }
            catch (Exception e) {
                Log.log("um.Usage loadStandardUsageArray FAILED!");
                Log.logException(e);
            }
        }
        Log.log("NO USAGE EXISTS for " + this.system + " / " + this.client);
        return new UsageRecord[0];
    }

    private UsageRecord[] handleUsageRecords(UsageRecord[] orgUsage) {
        Log.log("Organizing and analyzing usage records. Found " + orgUsage.length + " rows of usage.");
        UsageRecord[] tmpUsageArray = null;
        try {
            CharSequence[] users = new String[orgUsage.length];
            CharSequence[] tcodes = new String[orgUsage.length];
            for (int i = 0; i < orgUsage.length; ++i) {
                users[i] = orgUsage[i].getUser();
                tcodes[i] = orgUsage[i].getTcode();
            }
            HashMap<String, Integer> userMap = new HashMap<String, Integer>();
            HashMap<String, Integer> tcodeMap = new HashMap<String, Integer>();
            if (orgUsage.length > 0 && users.length > 0) {
                Log.log("Reading user ids.");
                String userString = String.join((CharSequence)"', '", users);
                ResultSet rs = DB.getData("SELECT DISTINCT(id) AS id, user FROM um_user WHERE um_delete = 0 AND `system` = '" + this.system + "' AND `client` = '" + this.client + "' AND `user` IN ('" + userString + "');");
                int totalNumberOfUsers = DB.resultSetGetSize(rs);
                while (rs.next()) {
                    userMap.putIfAbsent(rs.getString("user"), rs.getInt("id"));
                }
                rs.close();
                Log.log("Loaded " + totalNumberOfUsers + " user ids.");
                if (tcodes.length > 0) {
                    Log.log("Loading tcode ids.");
                    String tcodeString = String.join((CharSequence)"', '", tcodes);
                    rs = DB.getData("SELECT DISTINCT(id) AS id, tcode FROM um_tcode WHERE\t(um_delete=0 OR um_delete IS NULL) AND `system` = '" + this.system + "' AND `client` = '" + this.client + "' AND `tcode` IN ('" + tcodeString + "');");
                    while (rs.next()) {
                        tcodeMap.putIfAbsent(rs.getString("tcode"), rs.getInt("id"));
                    }
                    rs.close();
                    Log.log("Loaded " + tcodeMap.size() + " tcode ids.");
                } else {
                    Log.log("NO tcode ids to load.");
                }
                ArrayList<UsageRecord> usageAcc = new ArrayList<UsageRecord>();
                this.usageMapTcode.clear();
                this.usageMapUsers.clear();
                int zeroTcodeIds = 0;
                ArrayList<String> webdynprousage = new ArrayList<String>();
                for (UsageRecord record : orgUsage) {
                    int myTcodeId;
                    if (!userMap.containsKey(record.getUser())) continue;
                    record.setUser_id((Integer)userMap.get(record.getUser()));
                    int n = myTcodeId = tcodeMap.containsKey(record.getTcode()) ? (Integer)tcodeMap.get(record.getTcode()) : 0;
                    if (myTcodeId == 0) {
                        if (!webdynprousage.contains(record.getTcode())) {
                            Log.log("Usage.loadUsage will consider usage on '" + record.getTcode() + "' as webdynpro usage.");
                            webdynprousage.add(record.getTcode());
                        }
                        ++zeroTcodeIds;
                    }
                    record.setTcode_id(myTcodeId);
                    usageAcc.add(record);
                    if (!this.usageMapTcode.containsKey(myTcodeId)) {
                        this.usageMapTcode.put(myTcodeId, new ArrayList());
                    }
                    this.usageMapTcode.get(myTcodeId).add(record);
                    if (!this.usageMapUsers.containsKey(record.getUser_id())) {
                        this.usageMapUsers.put(record.getUser_id(), new ArrayList());
                    }
                    this.usageMapUsers.get(record.getUser_id()).add(record);
                }
                webdynprousage.clear();
                UsageRecord[] usageFinal = usageAcc.toArray(new UsageRecord[0]);
                tmpUsageArray = usageFinal;
                Log.log("Found " + zeroTcodeIds + " tcodes where id is set to zero. WebDynpro assumed for these usage records.");
            }
        }
        catch (Exception e) {
            Log.log("um.Usage loadUsage FAILED!");
            Log.logException(e);
        }
        if (tmpUsageArray == null) {
            tmpUsageArray = new UsageRecord[]{};
        }
        Log.log("DEBUG: this.usageArray contains " + tmpUsageArray.length + " records.");
        Log.log("Loaded usage for " + this.system + " / " + this.client + " " + this.startDate + " " + this.endDate + " DONE.\n");
        return tmpUsageArray;
    }

    public String getTypeDescription(String type) {
        if (this.typeDescriptions == null) {
            this.typeDescriptions = Usage.loadTypeDescriptions(this.system, this.client);
        }
        if (this.typeDescriptions.containsKey(type)) {
            return this.typeDescriptions.get(type);
        }
        return "";
    }

    private static HashMap<String, String> loadTypeDescriptions(String system, String client) {
        Log.log("Usage loading usage type description for " + system + "/" + client);
        HashMap<String, String> tmpTypeDescriptions = new HashMap<String, String>();
        ResultSet rs = DB.getData("SELECT `type`, `description` FROM um_usage_type WHERE `system` = '" + system + "' AND `client` = '" + client + "';");
        try {
            while (rs.next()) {
                tmpTypeDescriptions.put(rs.getString(1), rs.getString(2));
                Log.log("Usage loaded usage type description " + rs.getString(1) + " " + rs.getString(2));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("um.Usage getTypeDescriptions FAILED!");
            Log.logException(e);
        }
        return tmpTypeDescriptions;
    }
}

