/*
 * Decompiled with CFR 0.152.
 */
package um;

import cn.DB;
import cn.Log;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import um.Usage;

public class RoleAssignments {
    private static HashMap<Integer, int[]> tcodesInRole = new HashMap();
    private static final PreparedStatement PS_tcodesInRole = DB.prepareStatement("SELECT tcode_id FROM um_role_tcode WHERE um_delete = 0 AND role_id = ? ;");
    private static final PreparedStatement PS_tcodesInComposite = DB.prepareStatement("SELECT tcode_id FROM um_role_tcode WHERE um_delete = 0 AND role_id IN (\tSELECT single AS id FROM um_role_comp \tWHERE um_role_comp.composite = ? AND um_role_comp.um_delete = 0 );");
    private static HashMap<Integer, int[]> userWithRole = new HashMap();
    private static final PreparedStatement usersWithRolePS = DB.prepareStatement("SELECT user_id FROM um_user_role WHERE um_delete=0 AND role_id = ? ;");
    private static int[] role_ids = null;

    public static int[] getTcodesInRole(int role_id) {
        if (!tcodesInRole.containsKey(role_id)) {
            try {
                PS_tcodesInRole.setInt(1, role_id);
                ResultSet rs = PS_tcodesInRole.executeQuery();
                ArrayList<Integer> tcodes = new ArrayList<Integer>();
                while (rs.next()) {
                    tcodes.add(rs.getInt(1));
                }
                int[] finalResult = tcodes.stream().mapToInt(i -> i).toArray();
                tcodesInRole.put(role_id, finalResult);
                rs.close();
            }
            catch (SQLException e) {
                Log.log("FAILED! reading tcodes in RoleAssignments.getTcodesInRole().");
                Log.logException(e);
            }
        }
        return tcodesInRole.get(role_id);
    }

    public static int[] getTcodesInCompositeRole(int role_id) {
        if (!tcodesInRole.containsKey(role_id)) {
            try {
                PS_tcodesInComposite.setInt(1, role_id);
                ResultSet rs = PS_tcodesInComposite.executeQuery();
                ArrayList<Integer> tcodes = new ArrayList<Integer>();
                while (rs.next()) {
                    tcodes.add(rs.getInt(1));
                }
                int[] finalResult = Utils.unique(tcodes).stream().mapToInt(i -> i).toArray();
                tcodesInRole.put(role_id, finalResult);
                rs.close();
            }
            catch (SQLException e) {
                Log.log("FAILED! reading tcodes in RoleAssignments.getTcodesInRole().");
                Log.logException(e);
            }
        }
        return tcodesInRole.get(role_id);
    }

    public static int[] getUsersWithRole(int role_id) {
        if (!userWithRole.containsKey(role_id)) {
            try {
                usersWithRolePS.setInt(1, role_id);
                ResultSet rs = usersWithRolePS.executeQuery();
                ArrayList<Integer> users = new ArrayList<Integer>();
                while (rs.next()) {
                    users.add(rs.getInt(1));
                }
                int[] finalResult = users.stream().mapToInt(i -> i).toArray();
                userWithRole.put(role_id, finalResult);
                rs.close();
            }
            catch (SQLException e) {
                Log.log("FAILED! reading user ids in RoleAssignments.getUsersWithRole().");
                Log.logException(e);
            }
        }
        return userWithRole.get(role_id);
    }

    public static int[] getRoleIds(String system, String client) {
        if (role_ids == null) {
            ResultSet rs = DB.getData("SELECT DISTINCT r.id FROM um_role AS r JOIN um_role_tcode AS rt JOIN um_user_role AS ur \tON r.id=rt.role_id AND r.id=ur.role_id WHERE r.system = '" + system + "' AND r.client = '" + client + "' AND r.um_delete=0 AND rt.um_delete=0 AND ur.um_delete=0;");
            role_ids = new int[DB.resultSetGetSize(rs)];
            int i = 0;
            try {
                while (rs.next()) {
                    RoleAssignments.role_ids[i++] = rs.getInt("id");
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("FAILED! reading role ids in RoleAssignments.getRoleIds().");
                Log.logException(e);
            }
        }
        return role_ids;
    }

    public static int[] getRoleIdsExceptIgnored(String system, String client) {
        ResultSet rs = DB.getData("SELECT r.* FROM um_role AS r WHERE r.system = '" + system + "' AND r.client = '" + client + "' AND r.um_delete = 0 AND (SELECT count(*) FROM um_role_tcode WHERE role_id = r.id AND um_delete = 0) > 0 AND (SELECT count(*) FROM um_user_role WHERE role_id = r.id AND um_delete = 0) > 0 AND dash_ignore_tcodes <> 1;");
        int[] role_ids = new int[DB.resultSetGetSize(rs)];
        try {
            int i = 0;
            while (rs.next()) {
                role_ids[i++] = rs.getInt("id");
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("FAILED! reading roles in RoleAssignments.getRoles().");
            Log.logException(e);
        }
        return role_ids;
    }

    public static int[] getCompositeSubRoles(int role_id) {
        ResultSet rs = DB.getData("SELECT single AS id FROM um_role_comp WHERE um_role_comp.composite = '" + role_id + "' AND um_role_comp.um_delete=0 ;");
        int[] role_ids = new int[DB.resultSetGetSize(rs)];
        try {
            int i = 0;
            while (rs.next()) {
                role_ids[i++] = rs.getInt("id");
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("FAILED! reading roles in RoleAssignments.getRoles().");
            Log.logException(e);
        }
        return role_ids;
    }

    public static int[] getUsersWithRoleAndUsage(int role_id, Usage usage) {
        try {
            usersWithRolePS.setInt(1, role_id);
            ResultSet rs = usersWithRolePS.executeQuery();
            ArrayList<Integer> users = new ArrayList<Integer>();
            while (rs.next()) {
                int user_id = rs.getInt(1);
                if (!usage.isUsedUser(user_id)) continue;
                users.add(rs.getInt(1));
            }
            rs.close();
            return users.stream().mapToInt(i -> i).toArray();
        }
        catch (SQLException e) {
            Log.log("FAILED! reading user ids in RoleAssignments.getUsersWithRoleAndUsage().");
            Log.logException(e);
            return new int[0];
        }
    }

    public static int[] getTcodesInCompositeRoleWithUsage(int role_id, Usage usage) {
        try {
            PS_tcodesInComposite.setInt(1, role_id);
            ResultSet rs = PS_tcodesInComposite.executeQuery();
            ArrayList<Integer> tcodes = new ArrayList<Integer>();
            while (rs.next()) {
                int tcode_id = rs.getInt(1);
                if (!usage.isUsedTcode(tcode_id)) continue;
                tcodes.add(tcode_id);
            }
            rs.close();
            return Utils.unique(tcodes).stream().mapToInt(i -> i).toArray();
        }
        catch (SQLException e) {
            Log.log("FAILED! reading tcodes in RoleAssignments.getTcodesInCompositeRoleWithUsage().");
            Log.logException(e);
            return new int[0];
        }
    }

    public static int[] getTcodesInRoleWithUsage(int role_id, Usage usage) {
        try {
            PS_tcodesInRole.setInt(1, role_id);
            ResultSet rs = PS_tcodesInRole.executeQuery();
            ArrayList<Integer> tcodes = new ArrayList<Integer>();
            while (rs.next()) {
                int tcode_id = rs.getInt(1);
                if (!usage.isUsedTcode(tcode_id)) continue;
                tcodes.add(tcode_id);
            }
            rs.close();
            return Utils.integerListToIntArray(tcodes);
        }
        catch (SQLException e) {
            Log.log("FAILED! reading tcodes in RoleAssignments.getTcodesInRoleWithUsage().");
            Log.logException(e);
            return Utils.EMPTYINTARRAY;
        }
    }
}

