/*
 * Decompiled with CFR 0.152.
 */
package um;

import cn.DB;
import cn.Log;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class LicenseCategory {
    private int id;
    private String category;
    private int cost;
    private static LicenseCategory[] licenseCategories = null;
    private static HashMap<Integer, LicenseCategory> rolesAndCategories = null;
    private static String SYSTEM;
    private static String CLIENT;

    private LicenseCategory(int id, String category, int cost, boolean dash_incl, String dash_abbr, String license_map_su01, int license_category_consolidated_id) {
        this.id = id;
        this.category = category;
        this.cost = cost;
    }

    public int getId() {
        return this.id;
    }

    public int getCost() {
        return this.cost;
    }

    public String getName() {
        return this.category;
    }

    public static LicenseCategory[] getLicenseCategories() {
        if (licenseCategories == null) {
            ResultSet rs = DB.getData("SELECT * FROM license_category WHERE `system` ='" + SYSTEM + "' AND client='" + CLIENT + "';");
            LicenseCategory[] lcs = new LicenseCategory[DB.resultSetGetSize(rs)];
            int i = 0;
            try {
                while (rs.next()) {
                    Log.log("Loading list of license categories. Creating '" + rs.getString("category") + "'.");
                    lcs[i++] = new LicenseCategory(rs.getInt("id"), rs.getString("category"), rs.getInt("cost"), rs.getBoolean("dash_incl"), rs.getString("dash_abbr"), rs.getString("license_map_su01"), rs.getInt("license_category_consolidated_id"));
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("FAILED! LicenseCategory loading license categories.");
                Log.logException(e);
            }
            licenseCategories = lcs;
            Log.log("Loaded list of " + lcs.length + " license categories.");
        }
        return licenseCategories;
    }

    public static LicenseCategory[] getPseudoLicenseCategories() {
        LicenseCategory[] lcs = new LicenseCategory[]{new LicenseCategory(-1, "No usage", 0, true, "No usage", "", 0), new LicenseCategory(-2, "Usage w/o role", 0, true, "Usage w/o role", "", 0), new LicenseCategory(-3, "WebDynpro usage only", 0, true, "WebDynpro usage only", "", 0)};
        return lcs;
    }

    private static HashMap<Integer, LicenseCategory> getRolesAndCategories() {
        if (rolesAndCategories == null) {
            rolesAndCategories = new HashMap();
            ResultSet rs = DB.getData("SELECT r.id AS role_id, lc.id AS license_category_id FROM um_role AS r JOIN license_category AS lc ON r.license_category_id=lc.id AND r.system = '" + SYSTEM + "' AND r.client = '" + CLIENT + "' WHERE r.system = '" + SYSTEM + "' AND r.client = '" + CLIENT + "' AND r.um_delete = 0 ;");
            try {
                while (rs.next()) {
                    rolesAndCategories.put(rs.getInt("role_id"), LicenseCategory.getById(rs.getInt("license_category_id")));
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("FAILED! LicenseCategory getting license categories.");
                Log.logException(e);
            }
        }
        return rolesAndCategories;
    }

    public static LicenseCategory getById(int id) {
        for (LicenseCategory lc : LicenseCategory.getLicenseCategories()) {
            if (lc.id != id) continue;
            return lc;
        }
        Log.log("LicenseCategory getById is returning NULL for id:" + id + "  " + SYSTEM + " / " + CLIENT);
        return null;
    }

    public static void setSystemClient(String system, String client) {
        SYSTEM = system;
        CLIENT = client;
        Log.log("um.LicenseCategory.setSystemClient(" + system + "/" + client + ")");
    }

    public static int getLicenseCategoryIdOfHighestCostRole(int[] role_ids) {
        int cat_id = 0;
        int highCost = -1;
        for (int role_id : role_ids) {
            LicenseCategory lc;
            if (!LicenseCategory.getRolesAndCategories().containsKey(role_id) || (lc = LicenseCategory.getRolesAndCategories().get(role_id)) == null || lc.cost <= highCost) continue;
            highCost = lc.cost;
            cat_id = lc.id;
        }
        return cat_id;
    }
}

