/*
 * Decompiled with CFR 0.152.
 */
package ic;

import cn.Config;
import cn.DB;
import cn.Frequency;
import cn.Language;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

class Settings {
    private static final HashMap<String, Settings> instances = new HashMap();
    private String system;
    private String client;
    private Frequency frequency;
    private Language language;
    private String sender_mail;
    private boolean mail_on_response;
    private boolean mail_to_executer;

    private Settings(String system, String client, String languageISO, String sender_mail, int overdue_frequency, boolean mail_on_response, boolean mail_to_executer) {
        this.language = Language.getLanguage(languageISO);
        this.sender_mail = sender_mail;
        this.mail_on_response = mail_on_response;
        this.mail_to_executer = mail_to_executer;
        this.frequency = overdue_frequency < 1 || overdue_frequency > 6 ? new Frequency(1) : new Frequency(overdue_frequency);
    }

    String getSystem() {
        return this.system;
    }

    String getClient() {
        return this.client;
    }

    Frequency getFrequency() {
        return this.frequency;
    }

    Language getLanguage() {
        return this.language;
    }

    String getSender_mail() {
        return this.sender_mail;
    }

    boolean isMail_on_response() {
        return this.mail_on_response;
    }

    boolean isMail_to_executer() {
        return this.mail_to_executer;
    }

    static Settings getSettings(String system, String client) {
        String token = system + " / " + client;
        if (!instances.containsKey(token)) {
            PreparedStatement ps = DB.prepareStatement("SELECT * FROM settings_ic WHERE settings_ic.system = '" + system + "' AND settings_ic.client = '" + client + "'; ");
            try {
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    instances.put(token, new Settings(system, client, rs.getString("notification_language"), rs.getString("notification_sender_mail"), rs.getInt("notification_overdue_frequency"), rs.getBoolean("mail_on_response"), rs.getBoolean("mail_to_executer")));
                } else {
                    Log.log("ic.Settings getSettings did not find any IC settings in the database. -using default Settings.");
                    instances.put(token, Settings.getDefaultSettings(system, client));
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("ic.Settings getSettings FAILED! -using default Settings.");
                Log.logException(e);
                instances.put(token, Settings.getDefaultSettings(system, client));
            }
        }
        return instances.get(token);
    }

    private static Settings getDefaultSettings(String system, String client) {
        String notification_language = Config.getFallbackLanguageISO();
        String notification_sender_mail = "support@compliancenow.eu";
        int notification_overdue_frequency = 1;
        Settings settings = new Settings(system, client, notification_language, notification_sender_mail, notification_overdue_frequency, false, false);
        return settings;
    }
}

