/*
 * Decompiled with CFR 0.152.
 */
package ic;

import cn.DB;
import cn.Frequency;
import cn.Log;
import cn.Memory;
import cn.task.Task;
import ic.Control;
import ic.Notifications;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class Scheduler {
    private static final PreparedStatement getControls = DB.prepareStatement("SELECT DISTINCT(ic_control.id) AS `control_id`, \t`frequency`, \t`start_date`, \t(SELECT MAX(ic_check.created) FROM ic_check \tWHERE control_id = ic_control.id) AS last_created_check FROM ic_control JOIN ic_group ON ic_group.id = ic_control.group AND ic_group.system = ? AND ic_group.client = ? WHERE ic_control.`derived` = 1 OR ic_control.`active` = 1 ORDER BY ic_control.frequency ASC;");

    public static boolean schedule(Task task) {
        ResultSet result = DB.getData("SELECT `system`, `client` FROM `ic_group` GROUP BY `system`, `client` ORDER BY `system`, `client`;");
        try {
            while (result.next()) {
                String system = result.getString(1);
                String client = result.getString(2);
                Log.log("Starting scheduling for " + system + " / " + client);
                Notifications notifications = new Notifications(system, client);
                ArrayList<Control> controls = Scheduler.getControlsForScheduling(system, client);
                Log.log("ic.Scheduler found " + controls.size() + " controls to schedule on " + system + " / " + client);
                for (Control control : controls) {
                    ArrayList<Integer> created_check_ids = Control.scheduleChecks(task, control);
                    if (notifications.settings.isMail_to_executer() && control.send_mail) {
                        notifications.sendToExecuter(created_check_ids);
                    }
                    Memory.garbageCollector();
                }
                Log.log("Starting to send out of overdue mails for " + system + " / " + client);
                notifications.sendOverdueChecks();
            }
            result.close();
        }
        catch (SQLException e) {
            Log.log("IC.Scheduler schedule failed getting active system clients.");
            Log.logException(e);
            return false;
        }
        return true;
    }

    private static ArrayList<Control> getControlsForScheduling(String system, String client) {
        ArrayList<Control> controls = new ArrayList<Control>();
        try {
            getControls.setString(1, system);
            getControls.setString(2, client);
            ResultSet rs = getControls.executeQuery();
            while (rs.next()) {
                int control_id = rs.getInt("control_id");
                Frequency f = new Frequency(rs.getInt("frequency"));
                Date s = rs.getDate("start_date");
                Date l = rs.getDate("last_created_check");
                String lString = l == null ? "NULL" : l.toString();
                Log.debug("Control: " + control_id + " \t checking start date: " + s.toString() + " " + f.isOverdue(s) + " last scheduled: " + lString + " " + f.isOverdue(l) + " frequency: " + f.toString());
                if (!f.isOverdue(s) || !f.isOverdue(l) && l != null) continue;
                controls.add(Control.getById(control_id));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("IC.Scheduler scheduleControls failed getting active controls.");
            Log.logException(e);
        }
        return controls;
    }
}

