/*
 * Decompiled with CFR 0.152.
 */
package ic;

import cn.DB;
import cn.Email;
import cn.Log;
import cn.Translator;
import cn.Utils;
import ic.Approver;
import ic.Check;
import ic.NotificationContent;
import ic.Settings;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

class Notifications {
    int id;
    String system;
    String client;
    Settings settings;
    Translator translator;

    Notifications(String system, String client) {
        this.system = system;
        this.client = client;
        this.settings = Settings.getSettings(system, client);
        this.translator = Translator.getInstance(this.settings.getLanguage().isoString);
    }

    void sendToExecuter(ArrayList<Integer> check_ids) {
        if (this.settings.isMail_to_executer()) {
            for (int check_id : check_ids) {
                Log.log("ic.Notifications sending executer email for created checks on " + this.system + " / " + this.client + ", " + check_id);
                Check check = Check.getById(check_id);
                this.sendNewToExecuter(check);
                Check.updateMailed(check_id);
            }
        } else {
            Log.log("ic.Notifications will not be sending executer email for created checks on " + this.system + " / " + this.client + " due to settings.");
        }
    }

    private boolean sendNewToExecuter(Check check) {
        ArrayList<Check> checks = new ArrayList<Check>();
        checks.add(check);
        ArrayList<Approver> executers = new ArrayList<Approver>();
        for (int executer_id : check.executer_ids) {
            executers.add(Approver.getById(executer_id));
        }
        Object object = executers.iterator();
        while (object.hasNext()) {
            Approver executer = (Approver)object.next();
            if (!Utils.isEmpty(executer.getEmail())) {
                Email email = new Email(this.settings.getSender_mail(), Email.convertEmailString(executer.getEmail()), "CN " + this.translator.getText("Internal Controls {1}/{2}", new String[]{this.system, this.client}) + ": " + this.translator.getText("Upcoming control to execute"), NotificationContent.ExecuterContent(checks, this.translator));
                return email.send();
            }
            Log.log("No valid email on approver " + executer.toString());
        }
        return false;
    }

    void sendOverdueChecks() {
        Log.log("ic.Notifications Start sending emails for overdue checks on " + this.system + " / " + this.client);
        Date last_overdue = this.getLastSentOverdueCheck();
        if (this.settings.getFrequency().isOverdue(last_overdue)) {
            this.dueToApprover();
            this.dueToExecuter();
            this.setLastSentOverdueCheck();
        } else {
            Log.log("Already sent on " + last_overdue.toString() + ", Frequency " + this.settings.getFrequency().toString() + " is not overdue - yet.");
        }
        Log.log("DONE (sending emails of check overdues).");
    }

    private Date getLastSentOverdueCheck() {
        Date last_overdue = null;
        PreparedStatement ps = DB.prepareStatement("SELECT MAX(ic_overdue_check.timestamp) AS timestamp FROM ic_overdue_check WHERE ic_overdue_check.system = ? AND ic_overdue_check.client = ? ;");
        try {
            ps.setString(1, this.system);
            ps.setString(2, this.client);
            last_overdue = DB.preparedStatementGetDate(ps);
        }
        catch (SQLException e) {
            Log.log("ic.Notifications FAILED to getLastSentOverdueCheck.");
            Log.logException(e);
        }
        last_overdue = last_overdue == null ? Date.valueOf("0001-01-01") : last_overdue;
        return last_overdue;
    }

    private void setLastSentOverdueCheck() {
        PreparedStatement ps = DB.prepareStatement("INSERT INTO ic_overdue_check (`system`, `client`,`timestamp`) VALUES (?, ?, now()) ON DUPLICATE KEY UPDATE timestamp = now();");
        try {
            ps.setString(1, this.system);
            ps.setString(2, this.client);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            Log.log("ic.Notifications setOverdue");
            Log.logException(e);
        }
    }

    private void dueToApprover() {
        Log.log("Start sending weekly emails to approver for overdue checks this week.");
        ArrayList<Approver> approvers = Approver.getOverdueApprovers(this.system, this.client);
        for (Approver approver : approvers) {
            ArrayList<Check> checks = approver.getOverdueApprovals();
            if (checks.size() > 0 && !Utils.isEmpty(approver.getEmail())) {
                if (this.sendDueToApprover(approver, checks)) {
                    Log.log("Sent Next Week Due To Approver mail for : " + approver.approver + " (" + approver.user + ")");
                    continue;
                }
                Log.log("Failed to send Next Week Due To Approver mail for : " + approver.approver + " (" + approver.user + ")");
                continue;
            }
            if (approver.getEmail() == null) {
                Log.log("No valid email on approver " + approver.approver);
                continue;
            }
            Log.log("No checks for approver " + approver.approver);
        }
        Log.log("DONE sending weekly emails to approver for overdue checks this week.");
    }

    private boolean sendDueToApprover(Approver approver, ArrayList<Check> checks) {
        Log.log("Start sending " + checks.size() + " checks to approver " + approver.approver + " overdue this week.");
        Email email = new Email(this.settings.getSender_mail(), Email.convertEmailString(approver.getEmail()), "CN " + this.translator.getText("Internal Controls {1}/{2}", new String[]{this.system, this.client}) + ": " + this.translator.getText("Due controls to approve this week"), NotificationContent.approverContent(checks, this.translator));
        return email.send();
    }

    private void dueToExecuter() {
        Log.log("Start sending emails to executer for due checks.");
        ArrayList<Approver> executers = Approver.getOverdueExecuters(this.system, this.client);
        for (Approver executer : executers) {
            ArrayList<Check> checks = executer.getOverdueChecks();
            if (checks.size() > 0 && executer.getEmail() != null) {
                if (this.sendDueToExecuter(executer, checks)) {
                    Log.log("Sent overdue checks mail to executer for : " + executer.approver + " (" + executer.user + ")");
                    continue;
                }
                Log.log("Failed to send overdue checks mail to executer for : " + executer.approver + " (" + executer.user + ")");
                continue;
            }
            if (executer.getEmail() == null) {
                Log.log("No valid email on approver " + executer.approver);
                continue;
            }
            Log.log("No checks for approver " + executer.approver);
        }
    }

    private boolean sendDueToExecuter(Approver executer, ArrayList<Check> checks) {
        Log.log("Start sending " + checks.size() + " checks to executer " + executer.approver + " overdue.");
        Email email = new Email(this.settings.getSender_mail(), Email.convertEmailString(executer.getEmail()), "CN " + this.translator.getText("Internal Controls {1}/{2}", new String[]{this.system, this.client}) + ": " + this.translator.getText("Overdue controls to execute"), NotificationContent.ExecuterContent(checks, this.translator));
        return email.send();
    }
}

