/*
 * Decompiled with CFR 0.152.
 */
package ic;

import cn.EmailContent;
import cn.Log;
import cn.Translator;
import ic.Approver;
import ic.Check;
import java.util.ArrayList;

class NotificationContent {
    NotificationContent() {
    }

    static String approverContent(ArrayList<Check> checks, Translator translator) {
        String[] headlines = new String[]{"Due date", "ID", "Name", "Executer", "Compliance manager", "Status", "Finding", "Auto approved"};
        StringBuilder content = new StringBuilder();
        content.append("<h3>" + translator.getText("Controls for approval") + "</h3>");
        content.append(EmailContent.makeTableHeader(headlines, translator));
        Log.log("ic.NotificationContent approverContent looping " + checks.size() + " checks.");
        for (Check check : checks) {
            if (check != null) {
                content.append("<tr>");
                content.append(EmailContent.makeTableCell(check.due_date.toString(), null));
                content.append(EmailContent.makeTableCell(check.control_id + "-" + check.id, null));
                content.append(EmailContent.makeTableCell(check.name, null));
                content.append(check.executer_ids == null ? "" : EmailContent.makeTableCell(Approver.idsToText(check.executer_ids), null));
                content.append(check.mitigator_ids == null ? "" : EmailContent.makeTableCell(Approver.idsToText(check.mitigator_ids), null));
                content.append(EmailContent.makeTableCell(Check.getStatusText(check.status, translator), null));
                content.append(EmailContent.makeTableCell(check.finding ? translator.getText("Yes") : translator.getText("No"), null));
                content.append(EmailContent.makeTableCell(check.approval_not_required ? translator.getText("Yes") : translator.getText("No"), null));
                content.append("</tr>");
                continue;
            }
            Log.log("ic.NotificationContent approverContent received NULL check.");
        }
        content.append("</table>");
        content.append("<h3>" + translator.getText("Please go to transaction /n/APPLISOL/ICAPPROVE in SAP to preview the Controls ready for approval.") + "</h3>");
        return content.toString();
    }

    static String ExecuterContent(ArrayList<Check> checks, Translator translator) {
        String[] headlines = new String[]{"Due date", "ID", "Name", "Approver", "Auto approved", "Returned", "Created by"};
        StringBuilder content = new StringBuilder();
        content.append("<h3>" + translator.getText("Controls to Execute") + "</h3>");
        content.append(EmailContent.makeTableHeader(headlines, translator));
        for (Check check : checks) {
            content.append("<tr>");
            content.append(EmailContent.makeTableCell(check.due_date.toString(), null));
            content.append(EmailContent.makeTableCell(check.control_id + "-" + check.id, null));
            content.append(EmailContent.makeTableCell(check.name, null));
            content.append(check.approver_ids == null ? "" : EmailContent.makeTableCell(Approver.idsToText(check.approver_ids), null));
            content.append(EmailContent.makeTableCell(check.approval_not_required ? translator.getText("Yes") : translator.getText("No"), null));
            content.append(EmailContent.makeTableCell(check.status == 3 ? translator.getText("Yes") : translator.getText("No"), null));
            content.append(EmailContent.makeTableCell(check.created_by, null));
            content.append("</tr>");
        }
        content.append("</table>");
        content.append("<h3>" + translator.getText("Please go to transaction /n/APPLISOL/ICCONTROL in SAP to preview the Controls ready to be executed.") + "</h3>");
        return content.toString();
    }
}

