/*
 * Decompiled with CFR 0.152.
 */
package ic;

import cn.DB;
import cn.Frequency;
import cn.Log;
import cn.Utils;
import cn.task.Task;
import ic.Area;
import ic.AutoReport;
import ic.Check;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

class Control {
    private static final PreparedStatement ps_GetControl = DB.prepareStatement("SELECT \n\tic_control.*,\n\tic_group.name AS group_name,\n\tic_group.description AS group_description,\n\tic_group.system AS `system`,\n\tic_group.client AS `client`,\n\tic_system_location.text AS system_location_text,\n\t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_control_executer ON ic_approvers.id = ic_control_executer.approver_id WHERE ic_control_executer.control_id = ic_control.id) AS `executer_ids`,\n\t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_control_approver ON ic_approvers.id = ic_control_approver.approver_id WHERE ic_control_approver.control_id = ic_control.id) AS `approver_ids`,\n\t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_control_mitigator ON ic_approvers.id = ic_control_mitigator.approver_id WHERE ic_control_mitigator.control_id = ic_control.id) AS `mitigator_ids`\nFROM ic_control \nLEFT JOIN ic_group ON ic_control.group = ic_group.id \nLEFT JOIN ic_system_location on ic_system_location.id = ic_control.system_location_id\nWHERE ic_control.id = ? ;");
    private static final PreparedStatement ps_CreateCheck = DB.prepareStatementInsert("INSERT INTO ic_check ( \n\t\tcontrol_id,`system`, client, \n\t\tcreated_by, group_name, group_description, system_location_text, \t\tdependencies, name, reference_to_risk, days, \n\t\tmitigation_purpose, mitigation_description, mitigation_execution, mitigation_parameters, mitigation_documentation, mitigation_reaction, \n\t\tfrequency, criticality, start_date, gdpr_active, gdpr_text, \n\t\tapproval_not_required, send_mail, active, derived, due_date, status, mailed) \n\tVALUES ( \n\t\t?, ?, ?, \n\t\t?, ?, ?, ?, \n\t\t?, ?, ?, ?, \n\t\t?, ?, ?, \n\t\t?, ?, ?, \n\t\t?, ?, ?, ?, ?, \n\t\t?, ?, ?, ?, ?, ?, ?\n\t);");
    int control_id;
    String system;
    String client;
    int group;
    int system_location_id;
    int criticality;
    int days;
    String created_by;
    String origin;
    String name;
    String dependencies;
    String reference_to_risk;
    String mitigation_purpose;
    String mitigation_description;
    String mitigation_execution;
    String mitigation_parameters;
    String mitigation_documentation;
    String mitigation_reaction;
    String gdpr_text;
    String group_name;
    String group_description;
    Frequency frequency;
    Date start_date;
    Timestamp created;
    int[] executer_ids;
    int[] approver_ids;
    int[] mitigator_ids;
    int executer_minimum;
    int approver_minimum;
    int ac_risk;
    boolean gdpr_active;
    boolean approval_not_required;
    boolean send_mail;
    boolean active;
    boolean derived;
    boolean ac_auto_report;
    String system_location_text = null;
    private static final PreparedStatement ps_UpdateAreaInformation = DB.prepareStatementInsert("UPDATE ic_check SET area_id = ?, area_name = ?, area_description = ?, area_extra_information = ?, system_location_text = ? WHERE id = ?");
    private static final PreparedStatement ps_GetActiveAreas = DB.prepareStatement("SELECT GROUP_CONCAT(area_id) AS area_ids FROM ic_control_area WHERE control_id = ? AND `active` = 1;");

    static Control getById(int control_id) {
        Control control = null;
        try {
            ps_GetControl.setInt(1, control_id);
            ResultSet rs = ps_GetControl.executeQuery();
            while (rs.next()) {
                control = new Control();
                Control.addPropertiesFromRS(control_id, control, rs);
                try {
                    control.group = rs.getInt("group");
                    control.system_location_id = rs.getInt("system_location_id");
                    control.origin = rs.getString("origin");
                }
                catch (Exception e) {
                    Log.log("Control.getById could not add properties.");
                    Log.logException(e);
                }
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("IC Control getById failed.");
            Log.logException(e);
        }
        return control;
    }

    protected static void addPropertiesFromRS(int control_id, Control control, ResultSet rs) {
        control.control_id = control_id;
        try {
            control.system = rs.getString("system");
            control.client = rs.getString("client");
            control.group_name = rs.getString("group_name");
            control.group_description = rs.getString("group_description");
            control.dependencies = rs.getString("dependencies");
            control.criticality = rs.getInt("criticality");
            control.days = rs.getInt("days");
            control.gdpr_active = rs.getBoolean("gdpr_active");
            control.approval_not_required = rs.getBoolean("approval_not_required");
            control.send_mail = rs.getBoolean("send_mail");
            control.active = rs.getBoolean("active");
            control.derived = rs.getBoolean("derived");
            control.created_by = rs.getString("created_by");
            control.name = rs.getString("name");
            control.reference_to_risk = rs.getString("reference_to_risk");
            control.mitigation_purpose = rs.getString("mitigation_purpose");
            control.mitigation_description = rs.getString("mitigation_description");
            control.mitigation_execution = rs.getString("mitigation_execution");
            control.mitigation_parameters = rs.getString("mitigation_parameters");
            control.mitigation_documentation = rs.getString("mitigation_documentation");
            control.mitigation_reaction = rs.getString("mitigation_reaction");
            control.gdpr_text = rs.getString("gdpr_text");
            control.system_location_text = rs.getString("system_location_text");
            control.frequency = new Frequency(rs.getInt("frequency"));
            control.start_date = rs.getDate("start_date");
            control.created = rs.getTimestamp("created");
            control.executer_ids = Utils.getIdsFromString(rs.getString("executer_ids"));
            control.approver_ids = Utils.getIdsFromString(rs.getString("approver_ids"));
            control.mitigator_ids = Utils.getIdsFromString(rs.getString("mitigator_ids"));
            control.ac_risk = rs.getInt("ac_risk");
            control.ac_auto_report = control.ac_risk > 0 ? rs.getBoolean("ac_auto_report") : false;
        }
        catch (Exception e) {
            Log.log("Control.addPropertiesFromRS could not add properties.");
            Log.logException(e);
        }
    }

    static ArrayList<Integer> scheduleChecks(Task task, Control control) {
        ArrayList<Integer> created_check_ids = new ArrayList<Integer>();
        if (control.derived) {
            created_check_ids.addAll(control.scheduleDerivedCheck());
        } else {
            created_check_ids.add(control.scheduleCheck());
        }
        if (control.ac_risk > 0) {
            Check.updateACrisk(Utils.integerListToIntArray(created_check_ids), control.ac_risk, control.ac_auto_report);
            if (control.ac_auto_report) {
                Log.log("ic.Control creating report for " + control.ac_risk);
                String filename = AutoReport.makeAutoReport(task, control.ac_risk, control.system, control.client);
                Log.log("ic.Control attaching report for " + control.ac_risk + " as if it was uploaded by system or admin.");
                AutoReport.attachAutoReport(control.ac_risk, created_check_ids, filename);
                Log.log("ic.Control report attached for " + control.ac_risk + " as if it was uploaded by system or admin.");
            }
        }
        return created_check_ids;
    }

    protected Control() {
    }

    private int scheduleCheck() {
        int check_id = -1;
        Calendar date = Calendar.getInstance();
        date.add(5, this.days);
        Date dueDate = new Date(date.getTimeInMillis());
        try {
            ps_CreateCheck.setInt(1, this.control_id);
            ps_CreateCheck.setString(2, this.system);
            ps_CreateCheck.setString(3, this.client);
            ps_CreateCheck.setString(4, this.created_by);
            ps_CreateCheck.setString(5, this.group_name);
            ps_CreateCheck.setString(6, this.group_description);
            ps_CreateCheck.setString(7, this.system_location_text);
            ps_CreateCheck.setString(8, this.dependencies);
            ps_CreateCheck.setString(9, this.name);
            ps_CreateCheck.setString(10, this.reference_to_risk);
            ps_CreateCheck.setInt(11, this.days);
            ps_CreateCheck.setString(12, this.mitigation_purpose);
            ps_CreateCheck.setString(13, this.mitigation_description);
            ps_CreateCheck.setString(14, this.mitigation_execution);
            ps_CreateCheck.setString(15, this.mitigation_parameters);
            ps_CreateCheck.setString(16, this.mitigation_documentation);
            ps_CreateCheck.setString(17, this.mitigation_reaction);
            ps_CreateCheck.setInt(18, this.frequency.getIntegerValue());
            ps_CreateCheck.setInt(19, this.criticality);
            ps_CreateCheck.setDate(20, this.start_date);
            ps_CreateCheck.setBoolean(21, this.gdpr_active);
            ps_CreateCheck.setString(22, this.gdpr_text);
            ps_CreateCheck.setBoolean(23, this.approval_not_required);
            ps_CreateCheck.setBoolean(24, this.send_mail);
            ps_CreateCheck.setBoolean(25, this.active);
            ps_CreateCheck.setBoolean(26, this.derived);
            ps_CreateCheck.setDate(27, dueDate);
            ps_CreateCheck.setInt(28, 0);
            ps_CreateCheck.setBoolean(29, false);
        }
        catch (SQLException e) {
            Log.log("ic.Control scheduleCheck FAILED!");
            Log.logException(e);
        }
        try {
            ps_CreateCheck.executeUpdate();
            ResultSet rs = ps_CreateCheck.getGeneratedKeys();
            if (rs.next()) {
                check_id = rs.getInt(1);
                Check.updateExecuters(check_id, this.executer_ids);
                Check.updateApprovers(check_id, this.approver_ids);
                Check.updateMitigators(check_id, this.mitigator_ids);
            }
            rs.close();
            Log.log("Created check for " + this.control_id + " " + this.name + " with ID " + check_id);
        }
        catch (SQLException e) {
            Log.log("ic.Control scheduleCheck single check ps_CreateCheck.executeUpdate FAILED!");
            Log.logException(e);
        }
        return check_id;
    }

    private ArrayList<Integer> scheduleDerivedCheck() {
        int[] activeAreas;
        ArrayList<Integer> check_ids = new ArrayList<Integer>();
        for (int activeArea : activeAreas = this.getActiveAreaIds()) {
            int check_id = this.scheduleCheck();
            Area area = Area.getByControlAreaId(this.control_id, activeArea);
            try {
                ps_UpdateAreaInformation.setInt(1, area.id);
                ps_UpdateAreaInformation.setString(2, area.name);
                ps_UpdateAreaInformation.setString(3, area.description);
                ps_UpdateAreaInformation.setString(4, area.information);
                ps_UpdateAreaInformation.setString(5, area.system_location_text);
                ps_UpdateAreaInformation.setInt(6, check_id);
                ps_UpdateAreaInformation.executeUpdate();
                Check.updateExecuters(check_id, area.executer_ids);
                Check.updateApprovers(check_id, area.approver_ids);
                Check.updateMitigators(check_id, area.mitigator_ids);
                check_ids.add(check_id);
                Log.log("Created check for " + this.control_id + " " + this.name + " area: " + area.name);
            }
            catch (SQLException e) {
                Log.log("ic.Control scheduleCheck derived check ps_UpdateAreaInformation.executeUpdate FAILED!");
                Log.logException(e);
            }
        }
        Log.log("ic.Control created " + activeAreas.length + " checks for derived areas.");
        return check_ids;
    }

    private int[] getActiveAreaIds() {
        try {
            ps_GetActiveAreas.setInt(1, this.control_id);
        }
        catch (SQLException e) {
            Log.log("ic.Control getActiveAreaIds FAILED!");
            Log.logException(e);
        }
        String activeAreas = DB.preparedStatementGetOne(ps_GetActiveAreas);
        if (activeAreas != null) {
            return Utils.getIdsFromString(activeAreas);
        }
        return new int[0];
    }
}

