/*
 * Decompiled with CFR 0.152.
 */
package ic;

import cn.DB;
import cn.Log;
import cn.Translator;
import ic.Control;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class Check
extends Control {
    static final int STATUS_NEW = 0;
    static final int STATUS_SUBMITTED = 1;
    static final int STATUS_REJECTED = 2;
    static final int STATUS_RETURNED = 3;
    static final int STATUS_PARKED = 4;
    static final int STATUS_APPROVED = 5;
    static final int STATUS_CANCELED = 7;
    static final int STATUS_MITIGATION = 8;
    static final int STATUS_MITIGATED = 9;
    int id;
    int status;
    Date due_date;
    boolean finding;
    private static final PreparedStatement ps_ClearExecuters = DB.prepareStatement("DELETE FROM `ic_check_executers` WHERE `check_id` = ? ;");
    private static final PreparedStatement ps_UpdateExecuters = DB.prepareStatement("INSERT INTO `ic_check_executers`(`check_id`, `approver_id`) VALUES (?, ?)");
    private static final PreparedStatement ps_ClearApprovers = DB.prepareStatement("DELETE FROM `ic_check_approvers` WHERE `check_id` = ? ;");
    private static final PreparedStatement ps_UpdateApprovers = DB.prepareStatement("INSERT INTO `ic_check_approvers`(`check_id`, `approver_id`) VALUES (?, ?)");
    private static final PreparedStatement ps_ClearMitigators = DB.prepareStatement("DELETE FROM `ic_check_mitigator` WHERE `check_id` = ? ;");
    private static final PreparedStatement ps_UpdateMitigators = DB.prepareStatement("INSERT INTO `ic_check_mitigator`(`check_id`, `approver_id`) VALUES (?, ?)");
    private static final PreparedStatement ps_updateMailed = DB.prepareStatement("UPDATE ic_check SET mailed = 1 WHERE id = ?;");
    private static final PreparedStatement ps_updateACrisk = DB.prepareStatement("UPDATE ic_check SET ac_risk = ?, ac_auto_report = ? WHERE id = ?;");
    private static final PreparedStatement ps_getById = DB.prepareStatement("SELECT  ic_check.*, \t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_check_executers ON ic_approvers.id = ic_check_executers.approver_id WHERE ic_check_executers.check_id = ic_check.id) `executer_ids`, \t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_check_approvers ON ic_approvers.id = ic_check_approvers.approver_id WHERE ic_check_approvers.check_id = ic_check.id) `approver_ids`, \t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_check_mitigator ON ic_approvers.id = ic_check_mitigator.approver_id WHERE ic_check_mitigator.check_id = ic_check.id) `mitigator_ids` FROM ic_check WHERE id = ? ;");

    Check() {
    }

    static String getStatusText(int status, Translator translator) {
        switch (status) {
            case 5: {
                return translator.getText("Approved");
            }
            case 7: {
                return translator.getText("Canceled");
            }
            case 0: {
                return translator.getText("New");
            }
            case 4: {
                return translator.getText("Parked");
            }
            case 2: {
                return translator.getText("Rejected");
            }
            case 3: {
                return translator.getText("Returned");
            }
            case 1: {
                return translator.getText("Submitted");
            }
            case 8: {
                return translator.getText("Compliance check");
            }
            case 9: {
                return translator.getText("Compliance checked");
            }
        }
        return "UNKOWN STATUS '" + status + "'";
    }

    static void updateExecuters(int check_id, int[] executer_ids) {
        try {
            ps_ClearExecuters.setInt(1, check_id);
            ps_ClearExecuters.executeUpdate();
        }
        catch (SQLException e) {
            Log.log("ic.Check updateExecuters clear tables FAILED!");
            Log.logException(e);
        }
        try {
            if (executer_ids.length > 0) {
                for (int executer_id : executer_ids) {
                    ps_UpdateExecuters.setInt(1, check_id);
                    ps_UpdateExecuters.setInt(2, executer_id);
                    ps_UpdateExecuters.addBatch();
                }
                ps_UpdateExecuters.executeBatch();
            }
        }
        catch (SQLException e) {
            Log.log("ic.Check updateExecuters update executers FAILED!");
            Log.logException(e);
        }
    }

    static void updateApprovers(int check_id, int[] approver_ids) {
        try {
            ps_ClearApprovers.setInt(1, check_id);
            ps_ClearApprovers.executeUpdate();
        }
        catch (SQLException e) {
            Log.log("ic.Check updateApprovers clear tables FAILED!");
            Log.logException(e);
        }
        try {
            if (approver_ids.length > 0) {
                for (int approver_id : approver_ids) {
                    ps_UpdateApprovers.setInt(1, check_id);
                    ps_UpdateApprovers.setInt(2, approver_id);
                    ps_UpdateApprovers.addBatch();
                }
                ps_UpdateApprovers.executeBatch();
            }
        }
        catch (SQLException e) {
            Log.log("ic.Check updateApprovers update executers FAILED!");
            Log.logException(e);
        }
    }

    static void updateMitigators(int check_id, int[] mitigator_ids) {
        try {
            ps_ClearMitigators.setInt(1, check_id);
            ps_ClearMitigators.executeUpdate();
        }
        catch (SQLException e) {
            Log.log("ic.Check updateMitigators clear tables FAILED!");
            Log.logException(e);
        }
        try {
            if (mitigator_ids.length > 0) {
                for (int executer_id : mitigator_ids) {
                    ps_UpdateMitigators.setInt(1, check_id);
                    ps_UpdateMitigators.setInt(2, executer_id);
                    ps_UpdateMitigators.addBatch();
                }
                ps_UpdateMitigators.executeBatch();
            }
        }
        catch (SQLException e) {
            Log.log("ic.Check updateMitigators update executers FAILED!");
            Log.logException(e);
        }
    }

    static void updateMailed(int check_id) {
        try {
            ps_updateMailed.setInt(1, check_id);
            ps_updateMailed.executeUpdate();
        }
        catch (Exception e) {
            Log.log("ic.Check updateEmailSent FAILED to update check for control check " + check_id);
            Log.logException(e);
        }
    }

    static void updateACrisk(int[] check_ids, int ac_risk, boolean ac_auto_report) {
        for (int check_id : check_ids) {
            try {
                ps_updateACrisk.setInt(1, ac_risk);
                ps_updateACrisk.setBoolean(2, ac_auto_report);
                ps_updateACrisk.setInt(3, check_id);
                ps_updateACrisk.executeUpdate();
            }
            catch (Exception e) {
                Log.log("ic.Check updateACrisk FAILED to update check for control check " + check_id + " with ac risk " + ac_risk);
                Log.logException(e);
            }
        }
    }

    static Check getById(int check_id) {
        try {
            ps_getById.setInt(1, check_id);
            ResultSet rs = ps_getById.executeQuery();
            if (rs.next()) {
                return Check.fromResultSet(rs);
            }
        }
        catch (Exception e) {
            Log.log("Check.getById FAILED to load check.");
            Log.logException(e);
        }
        return null;
    }

    static Check fromResultSet(ResultSet rs) {
        Check check = new Check();
        try {
            Control.addPropertiesFromRS(rs.getInt("control_id"), check, rs);
            check.id = rs.getInt("id");
            check.status = rs.getInt("status");
            check.due_date = rs.getDate("due_date");
            check.finding = rs.getBoolean("positive");
        }
        catch (Exception e) {
            Log.log("Check.fromResultSet is unable to add properties from result set.");
            Log.logException(e);
            return null;
        }
        return check;
    }
}

