/*
 * Decompiled with CFR 0.152.
 */
package ic;

import ac.analysis.AnalyzeEngine;
import ac.analysis.UserIterator;
import ac.dashboard.DashboardUserSettings;
import ac.report.standard.Report;
import ac.risk.Risk;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.Translator;
import cn.report.ReportStarter;
import cn.task.Task;
import ic.Settings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Base64;

class AutoReport {
    AutoReport() {
    }

    static void attachAutoReport(int ac_risk_id, ArrayList<Integer> check_ids, String filename) {
        File file = new File(filename);
        if (file.exists()) {
            String encoded = "";
            try {
                encoded = Base64.getEncoder().encodeToString(Files.readAllBytes(file.toPath()));
            }
            catch (Exception e) {
                Log.log("ac.AutoReport.attachAutoReport FAILED to encode file to a base64 string.");
                Log.logException(e);
            }
            PreparedStatement response = DB.prepareStatementInsert("INSERT INTO ic_response (check_id, user, user_role, comment) VALUES (?,'ComplianceN',2,'Auto generated report')");
            for (int check_id : check_ids) {
                try {
                    response.setInt(1, check_id);
                    response.executeUpdate();
                    ResultSet rs = response.getGeneratedKeys();
                    PreparedStatement uploadFile = DB.prepareStatement("INSERT INTO ic_response_file \n\t(response_id, comment, file_name, file_type, file) \nVALUES (\n?,'Auto generated report',?,'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',?\n)");
                    while (rs.next()) {
                        uploadFile.setInt(1, rs.getInt(1));
                        uploadFile.setString(2, filename);
                        uploadFile.setString(3, encoded);
                        uploadFile.executeUpdate();
                    }
                }
                catch (Exception e) {
                    Log.log("ic.AutoReport FAILED while creating response with report.");
                    Log.logException(e);
                }
                Log.log("ic.AutoReport.attachAutoReport deleting report file " + file.getName() + ".");
                file.delete();
            }
        }
    }

    static String makeAutoReport(Task task, int risk_id, String system, String client) {
        Risk risk = Risk.getById(risk_id);
        if (risk.loadAuth()) {
            Risk[] risks = new Risk[]{risk};
            ac.report.tools.Settings params = AutoReport.getBaseParams(system, client);
            params.setRisks(new String[]{risk.signature});
            Report report = Report.createReport(task, params);
            String fileName = ReportStarter.getBaseFilename(18, risk_id);
            report.start(fileName);
            Log.log("Loading user iterator.");
            UserIterator analysisIterator = new UserIterator(params);
            Log.log("Creating engine and adding report listener.");
            AnalyzeEngine engine = new AnalyzeEngine(risks, analysisIterator);
            engine.addListener(report);
            Log.log("Starting analysis.");
            engine.analyze();
            Log.log("Finished analysis.");
            Log.log("AutoReport.makeAutoReport should now convert to Excel.");
            Translator translator = Translator.getInstance(params.getLanguageISO());
            String logfileparam = "logfile=" + Log.getFilename() + "_content.log ";
            int xlsxReturnValue = ReportStarter.convertReport(task, translator, logfileparam, fileName);
            Log.log("AutoReport.makeAutoReport excel converter returned " + xlsxReturnValue + " for risk " + risk_id);
            return Config.getReportPath() + fileName + ".xlsx";
        }
        Log.log(risk.toString() + " has no definition");
        String fileName = Config.getReportPath() + ReportStarter.getBaseFilename(999, risk_id);
        Path path = Paths.get(fileName, new String[0]);
        try {
            BufferedWriter errorFile = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            errorFile.write(risk.toString() + " has no definition");
            errorFile.close();
        }
        catch (IOException e) {
            Log.log("AutoReport.makeAutoReport Failed to create error file");
            Log.logException(e);
        }
        return fileName;
    }

    private static ac.report.tools.Settings getBaseParams(String system, String client) {
        DashboardUserSettings dashboardSettings = new DashboardUserSettings(system, client);
        ac.report.tools.Settings params = dashboardSettings.reportParams;
        params.setLanguageISO(Settings.getSettings((String)system, (String)client).getLanguage().isoString);
        params.setSummary(false);
        return params;
    }
}

