/*
 * Decompiled with CFR 0.152.
 */
package ic;

import cn.DB;
import cn.Log;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class Area {
    int id;
    int system_location_id;
    String system;
    String client;
    String name;
    String description;
    String information;
    String system_location_text;
    int[] executer_ids;
    int[] approver_ids;
    int[] mitigator_ids;
    private static final PreparedStatement ps_Control_Area = DB.prepareStatement("SELECT \tic_control_area.control_id, \tic_control_area.area_id, \tic_system_location.text AS system_location_text, \tic_area_extrainformation.system_location_id, \tic_area_extrainformation.information, \tic_area.*, \n\t(SELECT GROUP_CONCAT(approver_id)  FROM ic_control_executer WHERE ic_control_executer.control_id = ic_control_area.control_id AND ic_control_executer.area_id = ic_control_area.area_id) AS executer_ids, \n\t(SELECT GROUP_CONCAT(approver_id)  FROM ic_control_approver WHERE ic_control_approver.control_id = ic_control_area.control_id AND ic_control_approver.area_id = ic_control_area.area_id) AS approver_ids, \n\t(SELECT GROUP_CONCAT(approver_id)  FROM ic_control_mitigator WHERE ic_control_mitigator.control_id = ic_control_area.control_id AND ic_control_mitigator.area_id = ic_control_area.area_id) AS mitigator_ids \nFROM ic_control_area \nLEFT JOIN ic_area_extrainformation ON \tic_area_extrainformation.control_id = ic_control_area.control_id AND \tic_area_extrainformation.area_id = ic_control_area.area_id \nLEFT JOIN ic_area ON ic_area.id = ic_control_area.area_id \nLEFT JOIN ic_system_location ON ic_system_location.id = ic_area_extrainformation.system_location_id \nWHERE ic_control_area.control_id = ? AND ic_control_area.area_id = ?;");

    static Area getByControlAreaId(int control_id, int area_id) {
        Area area = null;
        try {
            ps_Control_Area.setInt(1, control_id);
            ps_Control_Area.setInt(2, area_id);
            ResultSet rs = ps_Control_Area.executeQuery();
            while (rs.next()) {
                area = new Area(area_id, rs.getInt("system_location_id"), rs.getString("system"), rs.getString("client"), rs.getString("name"), rs.getString("description"), rs.getString("information"), rs.getString("system_location_text"), rs.getString("executer_ids"), rs.getString("approver_ids"), rs.getString("mitigator_ids"));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("ic.Area getByControlAreaId FAILED!");
            Log.logException(e);
        }
        return area;
    }

    private Area(int id, int system_location_id, String system, String client, String name, String description, String information, String system_location_text, String executer_ids, String approver_ids, String mitigator_ids) {
        this.id = id;
        this.system_location_id = system_location_id;
        this.system = system;
        this.client = client;
        this.name = name;
        this.description = description;
        this.information = information;
        this.system_location_text = system_location_text;
        this.executer_ids = Utils.getIdsFromString(executer_ids);
        this.approver_ids = Utils.getIdsFromString(approver_ids);
        this.mitigator_ids = Utils.getIdsFromString(mitigator_ids);
    }
}

