/*
 * Decompiled with CFR 0.152.
 */
package ic;

import cn.DB;
import cn.Log;
import cn.Utils;
import ic.Check;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

class Approver {
    int id;
    int area_id;
    String user;
    String approver;
    String substitute;
    String system;
    String client;
    private String email;
    private static final PreparedStatement ps_GetEmail = DB.prepareStatement("SELECT mail FROM um_user WHERE `user` = ? AND `system` = ? AND `client` = ? ;");
    private static final HashMap<Integer, Approver> activeApprovers = new HashMap();
    private static final PreparedStatement ps_GetApproverById = DB.prepareStatement("SELECT * FROM ic_approvers WHERE id = ? ;");

    Approver(int id, String user, String approver, String email, String substitute, String system, String client, String area_id) {
        this.id = id;
        this.user = user;
        this.approver = approver;
        this.substitute = substitute;
        this.system = system;
        this.client = client;
        this.email = email;
        this.area_id = area_id == null ? -1 : Integer.parseInt(area_id);
    }

    String getEmail() {
        if (Utils.isEmpty(this.email)) {
            try {
                ps_GetEmail.setString(1, this.user);
                ps_GetEmail.setString(2, this.system);
                ps_GetEmail.setString(3, this.client);
            }
            catch (Exception e) {
                Log.log("ic.Approver getEmail FAILED!");
                Log.logException(e);
            }
            this.email = DB.preparedStatementGetOne(ps_GetEmail);
        }
        return this.email;
    }

    ArrayList<Check> getOverdueApprovals() {
        ArrayList<Check> checks = new ArrayList<Check>();
        PreparedStatement ps = DB.prepareStatement("SELECT  ic_check.*, \t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_check_executers ON ic_approvers.id = ic_check_executers.approver_id WHERE ic_check_executers.check_id = ic_check.id) `executer_ids`, \t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_check_approvers ON ic_approvers.id = ic_check_approvers.approver_id WHERE ic_check_approvers.check_id = ic_check.id) `approver_ids`, \t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_check_mitigator ON ic_approvers.id = ic_check_mitigator.approver_id WHERE ic_check_mitigator.check_id = ic_check.id) `mitigator_ids` FROM ic_check JOIN ic_check_approvers ON ic_check.id = ic_check_approvers.check_id JOIN ic_approvers ON ic_check_approvers.approver_id = ic_approvers.id WHERE ic_approvers.id = ? AND \tic_check.status NOT IN (7,5) AND \tDATE(ic_check.due_date) <= DATE_ADD(CURDATE(), INTERVAL 1 WEEK);");
        try {
            ps.setInt(1, this.id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                checks.add(Check.fromResultSet(rs));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("ic.Approver getOverdueApprovals FAILED!");
            Log.logException(e);
        }
        return checks;
    }

    ArrayList<Check> getOverdueChecks() {
        ArrayList<Check> checks = new ArrayList<Check>();
        PreparedStatement ps = DB.prepareStatement("SELECT  ic_check.* ,\t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_check_executers ON ic_approvers.id = ic_check_executers.approver_id WHERE ic_check_executers.check_id = ic_check.id) `executer_ids`, \t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_check_approvers ON ic_approvers.id = ic_check_approvers.approver_id WHERE ic_check_approvers.check_id = ic_check.id) `approver_ids`, \t(SELECT GROUP_CONCAT( ic_approvers.id ) FROM ic_approvers JOIN ic_check_mitigator ON ic_approvers.id = ic_check_mitigator.approver_id WHERE ic_check_mitigator.check_id = ic_check.id) `mitigator_ids` FROM ic_check JOIN ic_check_executers ON ic_check.id = ic_check_executers.check_id JOIN ic_approvers ON ic_check_executers.approver_id = ic_approvers.id WHERE ic_approvers.id = ? AND \tic_check.status NOT IN (5,7) AND \tDATE(ic_check.due_date) <= CURDATE(); ");
        try {
            ps.setInt(1, this.id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                checks.add(Check.fromResultSet(rs));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("ic.Approver getOverdueChecks FAILED!");
            Log.logException(e);
        }
        return checks;
    }

    static ArrayList<Approver> getOverdueApprovers(String system, String client) {
        ArrayList<Approver> approvers = new ArrayList<Approver>();
        PreparedStatement ps = DB.prepareStatement("SELECT DISTINCT(ic_approvers.id), ic_approvers.* FROM ic_approvers \tJOIN ic_check_approvers on ic_approvers.id = ic_check_approvers.approver_id \tJOIN ic_check on ic_check.id = ic_check_approvers.check_id WHERE \tic_approvers.system = ? AND  \tic_approvers.client = ? AND  \tic_check.send_mail = 1 AND \tic_check.status NOT IN (5,7) AND \tDATE(ic_check.due_date) <= DATE_ADD(CURDATE(), INTERVAL 1 WEEK);");
        try {
            ps.setString(1, system);
            ps.setString(2, client);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                approvers.add(new Approver(rs.getInt("id"), rs.getString("user"), rs.getString("approver"), rs.getString("email"), rs.getString("substitute"), rs.getString("system"), rs.getString("client"), rs.getString("area_id")));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("ic.Approver getOverdueApprovers FAILED!");
            Log.logException(e);
        }
        return approvers;
    }

    static ArrayList<Approver> getOverdueExecuters(String system, String client) {
        ArrayList<Approver> executers = new ArrayList<Approver>();
        PreparedStatement ps = DB.prepareStatement("SELECT DISTINCT(ic_approvers.id), ic_approvers.* FROM ic_approvers \tJOIN ic_check_executers on ic_approvers.id = ic_check_executers.approver_id \tJOIN ic_check on ic_check.id = ic_check_executers.check_id WHERE \tic_approvers.system = ? AND \tic_approvers.client = ? AND \tic_check.send_mail = 1 AND \tic_check.status IN (0,3) AND \tDATE(ic_check.due_date) <= CURDATE();");
        try {
            ps.setString(1, system);
            ps.setString(2, client);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                executers.add(new Approver(rs.getInt("id"), rs.getString("user"), rs.getString("approver"), rs.getString("email"), rs.getString("substitute"), rs.getString("system"), rs.getString("client"), rs.getString("area_id")));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("ic.Notifications getOverdueExecuters FAILED!");
            Log.logException(e);
        }
        return executers;
    }

    static Approver getById(int id) {
        if (!activeApprovers.containsKey(id)) {
            try {
                ps_GetApproverById.setInt(1, id);
                ResultSet rs = ps_GetApproverById.executeQuery();
                while (rs.next()) {
                    activeApprovers.put(id, new Approver(id, rs.getString("user"), rs.getString("approver"), rs.getString("email"), rs.getString("substitute"), rs.getString("system"), rs.getString("client"), rs.getString("area_id")));
                }
                rs.close();
            }
            catch (Exception e) {
                Log.log("ic.Approver getById FAILED!");
                Log.logException(e);
            }
        }
        return activeApprovers.get(id);
    }

    static String idsToText(int[] ids) {
        ArrayList<String> approverTexts = new ArrayList<String>();
        for (int id : ids) {
            approverTexts.add(Approver.getById(id).toString());
        }
        return String.join((CharSequence)", ", approverTexts.toArray(Utils.EMPTYSTRINGARRAY));
    }

    public String toString() {
        return this.approver;
    }
}

