/*
 * Decompiled with CFR 0.152.
 */
import cn.Arguments;
import cn.Log;
import cn.Memory;
import cn.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class csvToExcel {
    private static CellStyle boldstyle = null;
    private static final char ZEROCHAR = "0".charAt(0);
    private static XSSFCell cell;

    public static void main(String[] args) {
        Arguments.handle(args);
        Thread.currentThread().setPriority(10);
        String filenamecsv = args.length <= 3 ? args[1] : args[3];
        Path p = Paths.get(filenamecsv, new String[0]);
        if (p.getParent() == null) {
            Log.log("Something went horribly wrong. " + p.toString());
        }
        String folder = p.getParent().toString();
        String filename = p.getFileName().toString();
        String filenamexlsx = folder + File.separator + filename.substring(0, filename.lastIndexOf(46)) + ".xlsx";
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFFont boldFont = workbook.createFont();
        boldFont.setBold(true);
        boldstyle = workbook.createCellStyle();
        boldstyle.setFont((Font)boldFont);
        boolean partial = false;
        for (int i = 1; i < args.length; ++i) {
            filenamecsv = args[i++];
            String sheetName = args[i];
            Log.log("Putting " + filenamecsv + " into sheet " + sheetName);
            XSSFSheet sheet = workbook.createSheet(sheetName);
            boolean addFilter = args.length <= 3 && i == 2 || i >= 3;
            partial = csvToExcel.convertToSheet(filenamecsv, sheet, addFilter);
            try {
                if (Files.deleteIfExists(Paths.get(filenamecsv, new String[0]))) {
                    Log.log("Deleted file '" + filenamecsv + "'");
                    continue;
                }
                Log.log("Failed to delete file '" + filenamecsv + "'");
                continue;
            }
            catch (Exception e) {
                Log.log("Failed to delete file '" + filenamecsv + "'");
                Log.logException(e);
            }
        }
        Memory.garbageCollector();
        Log.log(Memory.statement("Starting to saving to " + filenamexlsx));
        try {
            FileOutputStream fileOut = new FileOutputStream(filenamexlsx);
            workbook.write((OutputStream)fileOut);
            fileOut.close();
            workbook.close();
        }
        catch (Exception e) {
            Log.log("Trouble saving file " + filenamexlsx);
            Log.logException(e);
            System.exit(1);
        }
        Log.log(Memory.statement("Save complete"));
        Log.close();
        if (partial) {
            System.exit(2);
        }
    }

    private static boolean convertToSheet(String filenamecsv, XSSFSheet sheet, boolean addFilter) {
        int MAX_ROWS = 1048574;
        boolean memOK = Memory.ok4Analysis();
        boolean excelHasSpace = true;
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Log.log(filenamecsv + " startet at: " + sdf.format(cal.getTime()));
        int rowCount = 0;
        try {
            int i;
            BufferedReader buffReader = Files.newBufferedReader(Paths.get(filenamecsv, new String[0]), StandardCharsets.UTF_8);
            boolean setColumns = true;
            XSSFRow row = sheet.createRow(rowCount++);
            row.setRowStyle(boldstyle);
            int outnumber = 15;
            int columnCount = 0;
            int columnMax = 0;
            StringBuilder cellContent = new StringBuilder();
            boolean enclosed = false;
            while (buffReader.ready() && memOK && excelHasSpace) {
                char currentChar = (char)buffReader.read();
                switch (currentChar) {
                    case '\"': {
                        enclosed = !enclosed;
                        break;
                    }
                    case ';': {
                        if (enclosed) {
                            cellContent.append(currentChar);
                            break;
                        }
                        csvToExcel.writeCellContent(row, columnCount, cellContent.toString());
                        ++columnCount;
                        cellContent.delete(0, cellContent.length());
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (enclosed) {
                            cellContent.append(currentChar);
                            break;
                        }
                        csvToExcel.writeCellContent(row, columnCount, cellContent.toString());
                        ++columnCount;
                        cellContent.delete(0, cellContent.length());
                        if (rowCount < 1048574) {
                            row = sheet.createRow(rowCount++);
                            if (rowCount % outnumber == 0) {
                                Log.log(Memory.statement("Converted " + rowCount + " lines."));
                                if (setColumns) {
                                    if (addFilter) {
                                        Log.log("Adding autofilter.");
                                        CellRangeAddress cra = new CellRangeAddress(0, rowCount, 0, columnMax);
                                        sheet.setAutoFilter(cra);
                                    }
                                    Log.log("Adding autosize.");
                                    for (i = 0; i < columnMax; ++i) {
                                        sheet.autoSizeColumn(i);
                                    }
                                    setColumns = false;
                                    outnumber = 100000;
                                }
                            }
                            if (columnMax < columnCount - 2 && columnCount - 2 > 0) {
                                columnMax = columnCount - 2;
                            }
                            columnCount = 0;
                            break;
                        }
                        Log.log(Memory.statement("Conversion stopped due to excel row limitations."));
                        row = sheet.createRow(rowCount++);
                        row.setRowStyle(boldstyle);
                        cell = row.createCell(1);
                        cell.setCellValue("Excel file stopped due to excel row limitations. Use CSV format if more rows are needed.");
                        excelHasSpace = false;
                        break;
                    }
                    default: {
                        cellContent.append(currentChar);
                    }
                }
                memOK = Memory.ok4Analysis();
            }
            Log.log(Memory.statement("Converted " + rowCount + " lines."));
            buffReader.close();
            if (!memOK) {
                Log.log(Memory.statement("Conversion stopped due to memory limitations."));
                row = sheet.createRow(rowCount++);
                row.setRowStyle(boldstyle);
                cell = row.createCell(1);
                cell.setCellValue("Excel file stopped due to memory limitations. Select fewer detail columns or use CSV format if all rows are needed.");
            }
            if (addFilter) {
                Log.log("Adding autofilter.");
                CellRangeAddress cra = new CellRangeAddress(0, rowCount, 0, columnMax);
                sheet.setAutoFilter(cra);
                Log.log("Autofilter added.");
                Log.log("Freezing top row.");
                sheet.createFreezePane(0, 1);
                Log.log("Top row freezed.");
            } else {
                Log.log("Autosize columns.");
                for (i = 0; i < columnMax; ++i) {
                    sheet.autoSizeColumn(i);
                }
            }
        }
        catch (Exception e) {
            Log.log("COULD NOT READ FILE!!! " + filenamecsv);
            Log.logException(e);
        }
        return !memOK || !excelHasSpace;
    }

    private static void writeCellContent(XSSFRow row, int columnCount, String content) {
        cell = row.createCell(columnCount);
        if (row.getRowNum() == 0) {
            cell.setCellStyle(boldstyle);
        }
        if (content.length() > 0) {
            if (content.charAt(0) == ZEROCHAR && content.length() > 1 && content.length() < Short.MAX_VALUE) {
                String data = content;
                cell.setCellValue(data);
            } else if (Utils.isNumeric(content)) {
                double d = Double.parseDouble(content);
                cell.setCellValue(d);
            } else {
                if (content.length() >= Short.MAX_VALUE) {
                    content = content.substring(0, 32766);
                }
                cell.setCellValue(content);
            }
        } else {
            cell.setCellValue("");
        }
    }
}

