/*
 * Decompiled with CFR 0.152.
 */
package cn.task;

import cn.Config;
import cn.Log;
import cn.Memory;
import cn.task.Task;
import ic.Scheduler;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TaskHandler {
    private static int WAIT = 5;

    public static boolean handle(Task task) {
        boolean success = false;
        switch (task.type) {
            case 18: {
                success = Scheduler.schedule(task);
                success |= apm.notification.Scheduler.schedule();
                break;
            }
            default: {
                Log.log("No valid task type: '" + task.type + "'");
            }
        }
        return success;
    }

    public static int executeJVM(String executionString, Task task) {
        int exitcode = 0;
        try {
            int n1;
            String javaMemory;
            String javaLocation = Config.getJavaExecutionPath();
            if (Memory.getAvailableSystemMemory() < Memory.toBytes(Config.getJavaXmx())) {
                Thread.sleep(1500L);
                long xmx = Memory.getAvailableSystemMemory() - Memory.toBytes("32M");
                long xms = Memory.toBytes(Config.getJavaXms(xmx));
                javaMemory = " -Xmx" + Memory.bytesToShortText(xmx) + " -Xms" + Memory.bytesToShortText(xms) + " ";
            } else {
                javaMemory = " -Xmx" + Config.getJavaXmx() + " -Xms" + Config.getJavaXms(Memory.toBytes(Config.getJavaXmx())) + " ";
            }
            Log.log("Starting java process: " + javaLocation + javaMemory + executionString);
            Runtime runTime = Runtime.getRuntime();
            Process process = runTime.exec(javaLocation + javaMemory + executionString);
            if (task != null) {
                long jpid = process.pid();
                Log.log("Registrering JVM pid: " + jpid);
                task.getAttributes().setJpid(jpid);
            }
            InputStream inputStream = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(inputStream);
            InputStream errorStream = process.getErrorStream();
            InputStreamReader esr = new InputStreamReader(errorStream);
            char[] c1 = new char[1024];
            StringBuffer standardOutput = new StringBuffer();
            while ((n1 = isr.read(c1)) > 0) {
                standardOutput.append(c1, 0, n1);
            }
            Log.log("Standard output: " + standardOutput.toString());
            char[] c2 = new char[1024];
            int exitNumber = 0;
            StringBuffer standardError = new StringBuffer();
            while ((exitNumber = esr.read(c2)) > 0) {
                standardError.append(c2, 0, exitNumber);
            }
            String errors = standardError.toString();
            if (errors.length() > 0 || standardOutput.toString().contains("insufficient memory")) {
                Log.log("Error output: " + errors);
                if (errors.contains("insufficient memory") || standardOutput.toString().contains("insufficient memory")) {
                    if (WAIT >= 1000) {
                        Log.log("JOB FAILED! NOT RETRYING AGAIN!");
                        WAIT = 5;
                        return 1;
                    }
                    Log.log("JOB FAILED! WILL RETRY IN " + (WAIT *= 2) + " seconds!");
                    Log.log("Job failed due to insuffient memory available. Will wait " + WAIT + " seconds before retrying.");
                    try {
                        Thread.sleep(WAIT * 1000);
                    }
                    catch (Exception e) {
                        Log.log("SLEEPING THREAD FOR " + WAIT + " SECONDS FAILED!!!");
                        Log.logException(e);
                    }
                    Log.log("Retrying...");
                    return TaskHandler.executeJVM(executionString, task);
                }
                WAIT = 5;
            } else {
                WAIT = 5;
            }
            exitcode = process.waitFor();
            Log.log("Standard exit " + exitcode);
        }
        catch (Exception e) {
            Log.log("Task execution in TaskHandler.startTask failed!");
            Log.logException(e);
        }
        return exitcode;
    }

    public static String getConverterExecutionString() {
        return Config.getJavaStandardIncludes() + " csvToExcel ";
    }
}

