/*
 * Decompiled with CFR 0.152.
 */
package cn.task;

import cn.Arguments;
import cn.DB;
import cn.Log;
import cn.task.Task;
import cn.task.TaskHandler;
import java.sql.PreparedStatement;

public class TaskController {
    public static void main(String[] args) {
        Arguments arguments = Arguments.handle(args);
        Task task = Task.getById(arguments.getInt("taskid"));
        while (task != null) {
            boolean success = TaskHandler.handle(task);
            if (!success) continue;
            task = TaskController.findNextTask();
        }
        DB.close();
        Log.log("Task controller shutting down.");
        Log.close();
        System.exit(0);
    }

    private static Task findNextTask() {
        Task task = null;
        task = TaskController.hasTask(new String[]{"17", "1"});
        if (task == null) {
            task = TaskController.hasTask(new String[]{"9"});
        }
        if (task == null) {
            task = TaskController.hasTask(new String[]{"19"});
        }
        if (task == null) {
            task = TaskController.hasTask(new String[]{"23", "22", "21", "36", "7"});
        }
        if (task == null) {
            task = TaskController.hasTask(null);
        }
        return task;
    }

    private static Task hasTask(String[] types) {
        Task task = null;
        PreparedStatement ps = types == null ? DB.prepareStatement("SELECT id FROM queue_task WHERE `class` = 'nc' AND `status` = 0 ORDER BY `created` ASC, `type` ASC LIMIT 1;") : DB.prepareStatement("SELECT id FROM queue_task WHERE `class` = 'nc' AND `status` = 0 AND `type` IN (" + String.join((CharSequence)",", types) + ") ORDER BY `created` ASC, `type` ASC LIMIT 1;");
        int task_id = DB.preparedStatementGetCount(ps);
        if (task_id > 0) {
            task = Task.getById(task_id);
        }
        return task;
    }
}

