/*
 * Decompiled with CFR 0.152.
 */
package cn.task;

import cn.Arguments;
import cn.DB;
import cn.Log;
import cn.TaskParameters;
import cn.task.Attributes;
import cn.task.TaskHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Task {
    public static final int STATUS_QUEUED = 0;
    public static final int STATUS_EXECUTING = 1;
    public static final int STATUS_COMPLETE = 2;
    public static final int STATUS_PARTIAL = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_STOPPED = 5;
    public static final int STATUS_CANCELLED = 6;
    public static final int STATUS_CONTINUE = 7;
    public int id;
    public int type;
    public String username;
    public String system;
    public String client;
    public String params;
    private Attributes attributeParams = null;
    private TaskParameters paramParams = null;

    public Task(int id, int type, String username, String system, String client, String params) {
        this.id = id;
        this.type = type;
        this.username = username;
        this.system = system;
        this.client = client;
        this.params = params;
    }

    public static void main(String[] args) {
        Arguments params = Arguments.handle(args);
        String input = String.join((CharSequence)"|", args);
        System.out.println("Got: " + input);
        Task task = Task.getById(params.getInt("taskid"));
        boolean success = TaskHandler.handle(task);
        DB.close();
        if (success) {
            Log.log("Task successfully completed.");
            System.out.println("Task successfully completed.");
            Log.close();
            System.exit(0);
        } else {
            Log.log("Task partially completed.");
            System.out.println("Task partially completed.");
            Log.close();
            System.exit(2);
        }
    }

    public static Task getById(int task_id) {
        Task newTask = null;
        ResultSet rs = DB.getData("SELECT `type`, `user`, `system`, `client`, `params` FROM queue_task WHERE id = " + task_id);
        try {
            while (rs.next()) {
                newTask = new Task(task_id, rs.getInt("type"), rs.getString("user"), rs.getString("system"), rs.getString("client"), rs.getString("params"));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Failed to create task in Task.getById(task_id)");
            Log.logException(e);
        }
        return newTask;
    }

    public Attributes getAttributes() {
        this.attributeParams = Attributes.get(this.id);
        return this.attributeParams;
    }

    public void setName(String string) {
        this.getAttributes().setName(string);
    }

    public void setStatusDetails(String status) {
        this.getAttributes().setStatus(status);
    }

    public void setStatus(int status) {
        int currentStatus = this.getParameters().getInt("status");
        Log.log("Current status of task is " + currentStatus + ". Setting status " + status + ".");
        PreparedStatement ps = DB.prepareStatement("UPDATE queue_task SET `status` = ? WHERE `id` = " + this.id);
        try {
            ps.setInt(1, status);
            ps.executeUpdate();
        }
        catch (Exception e) {
            Log.log("cn.task.setStatus FAILED!");
            Log.logException(e);
        }
    }

    public TaskParameters getParameters() {
        if (this.paramParams == null) {
            this.paramParams = new TaskParameters(this.params);
        }
        return this.paramParams;
    }

    public String getExecutionPath() {
        switch (this.type) {
            case 22: {
                return "bla abla blabl abl";
            }
            case 23: {
                return "bla ablablab labla";
            }
        }
        return "NO EXECUTION DEFINED FOR TASK TYPE '" + this.type + "' IN CLASS Task.";
    }
}

