/*
 * Decompiled with CFR 0.152.
 */
package cn.task;

import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.json.JSONException;
import org.json.JSONObject;

public class Attributes {
    private static final String REPORTFILENAME = "reportFilename";
    private static final String STATUS = "detailedStatus";
    private static final String NAME = "name";
    private static final String JPID = "jpid";
    private JSONObject attributes;
    private int task_id;
    private static PreparedStatement loadAttributes = null;
    private PreparedStatement PS_saveAttributes = null;

    public static Attributes get(int id) {
        if (loadAttributes == null) {
            loadAttributes = DB.prepareStatement("SELECT attributes FROM queue_task WHERE `id` = ?;");
        }
        try {
            loadAttributes.setInt(1, id);
        }
        catch (SQLException e) {
            Log.log("cn.Task getAttributes() FAILED at getting attributes.");
            Log.logException(e);
        }
        return new Attributes(DB.preparedStatementGetOne(loadAttributes), id);
    }

    private Attributes(String data, int task_id) {
        Log.debug("cn.task.Attributes\n" + data);
        this.task_id = task_id;
        this.attributes = new JSONObject(data);
    }

    void setStatus(String currentStatus) {
        this.attributes.put(STATUS, (Object)currentStatus);
        this.save();
    }

    public void setName(String string) {
        this.attributes.put(NAME, (Object)string);
        this.save();
    }

    public void setJpid(long jpid) {
        this.attributes.put(JPID, jpid);
        this.save();
    }

    public void setReportFilename(String filename) {
        this.attributes.put(REPORTFILENAME, (Object)filename);
        this.save();
    }

    private void save() {
        if (this.PS_saveAttributes == null) {
            this.PS_saveAttributes = DB.prepareStatement("UPDATE queue_task SET `attributes` = ? WHERE `id` = " + this.task_id);
        }
        try {
            this.PS_saveAttributes.setString(1, this.attributes.toString());
            this.PS_saveAttributes.executeUpdate();
        }
        catch (Exception e) {
            Log.log("cn.task.Attributes.save FAILED!");
            Log.logException(e);
        }
    }

    private boolean isSet(String property) {
        return this.attributes.has(property);
    }

    public String getString(String property) {
        if (this.isSet(property)) {
            try {
                return this.attributes.getString(property);
            }
            catch (Exception e) {
                Log.log("cn.task.Attributes cannot find string " + property);
                return null;
            }
        }
        return null;
    }

    public int getInt(String property) {
        try {
            return this.attributes.getInt(property);
        }
        catch (JSONException e) {
            return -1;
        }
    }
}

