/*
 * Decompiled with CFR 0.152.
 */
package cn.report;

import cn.DB;
import cn.Log;
import cn.Memory;
import cn.Translator;
import cn.Utils;
import cn.report.SpanData;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Spreadsheet {
    public static final int MAX_ROWS = 0x100000;
    private final XSSFWorkbook workbook;
    private final XSSFFont boldFont;
    private final Translator translator;
    private XSSFSheet activeSheet;
    private int currentRow = 0;
    private static CellStyle CELLSTYLE_VERTICAL = null;
    private static CellStyle CELLSTYLE_HORISONTAL = null;
    private static CellStyle CELLSTYLE_BOLD = null;

    public Spreadsheet(Translator translator) {
        this.translator = translator;
        this.workbook = new XSSFWorkbook();
        this.boldFont = this.workbook.createFont();
        this.boldFont.setBold(true);
        CELLSTYLE_BOLD = this.workbook.createCellStyle();
        CELLSTYLE_BOLD.setFont((Font)this.boldFont);
        CELLSTYLE_VERTICAL = this.workbook.createCellStyle();
        CELLSTYLE_VERTICAL.setFont((Font)this.boldFont);
        CELLSTYLE_VERTICAL.setRotation((short)90);
        CELLSTYLE_VERTICAL.setVerticalAlignment(VerticalAlignment.BOTTOM);
        CELLSTYLE_VERTICAL.setAlignment(HorizontalAlignment.CENTER);
        CELLSTYLE_HORISONTAL = this.workbook.createCellStyle();
        CELLSTYLE_HORISONTAL.setFont((Font)this.boldFont);
        CELLSTYLE_HORISONTAL.setAlignment(HorizontalAlignment.CENTER);
    }

    public XSSFSheet addSheet(String title) {
        this.activeSheet = this.workbook.createSheet(this.translator.getText(title));
        return this.activeSheet;
    }

    public void writeHeaders(String[] headers) {
        String[] translatedHeaders = new String[headers.length];
        int i = 0;
        for (String header : headers) {
            translatedHeaders[i++] = this.translator.getText(header);
        }
        this.currentRow = 0;
        Spreadsheet.writeExcelHeaders(translatedHeaders, this.activeSheet);
    }

    public boolean writeRow(String[] rowData) {
        if (this.currentRow <= 0x100000) {
            XSSFRow row = this.activeSheet.createRow(++this.currentRow);
            XSSFCell cell = null;
            for (int columnIndex = 0; columnIndex < rowData.length; ++columnIndex) {
                String content = rowData[columnIndex];
                cell = row.createCell(columnIndex);
                if (Utils.isNumeric(content) && content.indexOf(0) > 0) {
                    double d = Double.parseDouble(content);
                    cell.setCellValue(d);
                    continue;
                }
                cell.setCellValue(content);
            }
            return this.currentRow < 0x100000;
        }
        return false;
    }

    public void writeRowBold(String[] rowData) {
        XSSFRow row = this.activeSheet.createRow(++this.currentRow);
        XSSFCell cell = null;
        for (int columnIndex = 0; columnIndex < rowData.length; ++columnIndex) {
            String content = rowData[columnIndex];
            cell = row.createCell(columnIndex);
            cell.setCellStyle(CELLSTYLE_BOLD);
            if (Utils.isNumeric(content)) {
                double d = Double.parseDouble(content);
                cell.setCellValue(d);
                continue;
            }
            cell.setCellValue(content);
        }
    }

    public void writeRowVertically(String[] rowData) {
        XSSFRow row = this.activeSheet.createRow(++this.currentRow);
        XSSFCell cell = null;
        for (int columnIndex = 0; columnIndex < rowData.length; ++columnIndex) {
            String content = rowData[columnIndex];
            cell = row.createCell(columnIndex);
            if (columnIndex < 2) {
                cell.setCellStyle(CELLSTYLE_BOLD);
            } else {
                cell.setCellStyle(CELLSTYLE_VERTICAL);
            }
            if (Utils.isNumeric(content)) {
                double d = Double.parseDouble(content);
                cell.setCellValue(d);
                continue;
            }
            cell.setCellValue(content);
        }
    }

    public void addAutoFilter(int numberOfColumns) {
        Log.log("Adding Autofilter.");
        CellRangeAddress cra = new CellRangeAddress(0, this.currentRow, 0, numberOfColumns - 1);
        this.activeSheet.setAutoFilter(cra);
    }

    public void setAutoFilter(int firstColumnIndex, int firstRowIndex, int lastColumnIndex, int lastRowIndex) {
        CellRangeAddress cra = new CellRangeAddress(firstRowIndex, lastRowIndex, firstColumnIndex, lastColumnIndex);
        this.activeSheet.setAutoFilter(cra);
    }

    public void writeRowSpan(SpanData[] spanData) {
        XSSFRow row = this.activeSheet.createRow(this.currentRow);
        XSSFCell cell = null;
        int columnIndex = 0;
        for (int i = 0; i < spanData.length; ++i) {
            SpanData sd = spanData[i];
            cell = row.createCell(columnIndex);
            cell.setCellValue(sd.text);
            cell.setCellStyle(CELLSTYLE_HORISONTAL);
            if (sd.rowSpan > 1) {
                CellRangeAddress cra = new CellRangeAddress(this.currentRow, this.currentRow, columnIndex, columnIndex + sd.rowSpan - 1);
                this.activeSheet.addMergedRegion(cra);
            }
            columnIndex += sd.rowSpan;
        }
    }

    public void save(String filename) {
        Log.log("Spreadsheet start saving to " + filename);
        try {
            FileOutputStream fileOut = new FileOutputStream(filename);
            this.workbook.write((OutputStream)fileOut);
            fileOut.close();
            this.workbook.close();
        }
        catch (IOException e) {
            Log.log("Spreadsheet Save FAILED!");
            Log.logException(e);
        }
    }

    public XSSFSheet getActiveSheet() {
        return this.activeSheet;
    }

    public int getCurrentRowIndex() {
        return this.currentRow;
    }

    public CellStyle createCellStyle() {
        XSSFCellStyle cs = this.workbook.createCellStyle();
        return cs;
    }

    public static boolean CSVFromStatement(String filename, String statement) {
        boolean success = true;
        FileWriter myWriter = null;
        try {
            myWriter = new FileWriter(filename);
        }
        catch (IOException e) {
            Log.log("CSVFromStatement failed to open writer.");
            Log.logException(e);
            return false;
        }
        ResultSet rs = DB.getData(statement);
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            CharSequence[] line = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String header = rsmd.getColumnLabel(i + 1);
                line[i] = header == null ? "" : header;
            }
            try {
                boolean headercheck = Spreadsheet.writeCSVLine((String[])line, myWriter);
                if (!headercheck) {
                    Log.log("writeCSVLine header check returned false. " + String.join((CharSequence)"\t", line));
                }
            }
            catch (Exception e) {
                Log.log("CSVFromStatement: writing to file failed headers: " + String.join((CharSequence)"\t", line));
                Log.logException(e);
            }
            Log.log("CSVFromStatement: Headers done: " + String.join((CharSequence)"\t", line));
            while (rs.next()) {
                for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                    String data = rs.getString(columnIndex + 1);
                    line[columnIndex] = data == null ? "" : data;
                }
                try {
                    boolean check = Spreadsheet.writeCSVLine((String[])line, myWriter);
                    if (check) continue;
                    Log.log("CSVFromStatement: writeCSVLine check returned false.");
                }
                catch (Exception e) {
                    Log.log("CSVFromStatement: writing to file failed! Failed data: " + String.join((CharSequence)"\t", line));
                    Log.logException(e);
                }
            }
            Log.log("CSVFromStatement: Data done.");
            rs.close();
        }
        catch (SQLException e) {
            Log.log("ResultSet next failed in CSVFromStatement!");
            Log.logException(e);
            success = false;
        }
        Log.log("Closing file " + filename);
        try {
            myWriter.close();
        }
        catch (IOException e) {
            Log.log("Save failed in CSVFromStatement!");
            Log.logException(e);
            success = false;
        }
        return success;
    }

    public static boolean ExcelFromStatement(String filename, String statement, String sheetTitle) {
        boolean success = true;
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFFont boldFont = workbook.createFont();
        boldFont.setBold(true);
        CELLSTYLE_BOLD = workbook.createCellStyle();
        CELLSTYLE_BOLD.setFont((Font)boldFont);
        XSSFSheet sheet = workbook.createSheet(sheetTitle);
        Log.log(Memory.statement("ExcelFromStatement: Workbook started."));
        ResultSet rs = DB.getData(statement);
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] headers = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                headers[i] = rsmd.getColumnLabel(i + 1);
            }
            Spreadsheet.writeExcelHeaders(headers, sheet);
            Log.log(Memory.statement("ExcelFromStatement: Headers done."));
            XSSFCell cell = null;
            while (rs.next()) {
                XSSFRow row = sheet.createRow(rs.getRow());
                for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                    String content = rs.getString(columnIndex + 1);
                    cell = row.createCell(columnIndex);
                    if (Utils.isNumeric(content)) {
                        double d = Double.parseDouble(content);
                        cell.setCellValue(d);
                        continue;
                    }
                    cell.setCellValue(content);
                }
            }
            Log.log(Memory.statement("ExcelFromStatement: Data done."));
            rs.close();
            if (cell != null) {
                Log.log(Memory.statement("Adding Autofilter."));
                CellRangeAddress cra = new CellRangeAddress(0, cell.getRowIndex(), 0, cell.getColumnIndex());
                sheet.setAutoFilter(cra);
                Log.log(Memory.statement("Autofilter added."));
                for (int column = 0; column < headers.length; ++column) {
                    sheet.autoSizeColumn(column + 1);
                }
                Log.log(Memory.statement("Columns autosized."));
            }
        }
        catch (SQLException e1) {
            Log.log("ResultSet next failed in ExcelFromStatement!");
            Log.logException(e1);
            success = false;
        }
        Log.log(Memory.statement("Starting to saving to " + filename));
        try {
            FileOutputStream fileOut = new FileOutputStream(filename);
            workbook.write((OutputStream)fileOut);
            fileOut.close();
            workbook.close();
        }
        catch (IOException e) {
            Log.log("Save failed in ExcelFromStatement!");
            Log.logException(e);
            success = false;
        }
        return success;
    }

    public static void writeExcelHeaders(String[] headers, XSSFSheet sheet) {
        XSSFRow row = sheet.createRow(0);
        row.setRowStyle(CELLSTYLE_BOLD);
        XSSFCell cell = null;
        for (int column = 0; column < headers.length; ++column) {
            cell = row.createCell(column);
            cell.setCellStyle(CELLSTYLE_BOLD);
            cell.setCellValue(headers[column]);
            sheet.autoSizeColumn(column);
            Log.log("Wrote header " + headers[column] + " in column " + column);
        }
        Log.log("Set " + headers.length + " Excel column headers.");
    }

    public static boolean writeCSVLine(String[] data, FileWriter fileWriter) {
        boolean success = true;
        Object line = "";
        for (String field : data) {
            line = (String)line + Spreadsheet.escapeSpecialCharacters(field) + ";";
        }
        line = (String)line + System.lineSeparator();
        try {
            fileWriter.write((String)line);
        }
        catch (IOException e) {
            Log.log("writeCSVLine: fileWriter failed.");
            Log.logException(e);
            success = false;
        }
        return success;
    }

    private static String escapeSpecialCharacters(String data) {
        Object escapedData = data.replaceAll("\\R", " ");
        escapedData = data.replaceAll("\\n", " ");
        if (data.contains(";") || data.contains("\"") || data.contains("'")) {
            data = data.replace("\"", "\"\"");
            escapedData = "\"" + data + "\"";
        }
        return escapedData;
    }

    public void autoSizeAllColumns(int numberOfColumns) {
        for (int i = 0; i < numberOfColumns; ++i) {
            this.activeSheet.autoSizeColumn(i);
            int columnWidth = this.activeSheet.getColumnWidth(i);
            if (columnWidth <= 12000) continue;
            this.activeSheet.setColumnWidth(i, 12000);
        }
    }
}

