/*
 * Decompiled with CFR 0.152.
 */
package cn.report;

import ac.report.standard.ReportHandler;
import ac.report.tools.Settings;
import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.Translator;
import cn.Utils;
import cn.report.CSVfile;
import cn.task.Task;
import cn.task.TaskHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import um.report.Report;

public class ReportStarter {
    public static String getBaseFilename(int type, int id) {
        String baseFilename = "";
        switch (type) {
            case 7: {
                baseFilename = "AC_RiskAnalysis_";
                break;
            }
            case 0: {
                baseFilename = "UM_Report_";
                break;
            }
            case 13: {
                baseFilename = "APM_Report_";
                break;
            }
            case 18: {
                baseFilename = "IC_AC_Auto_Report_";
                break;
            }
            case 999: {
                return id + "ERROR_MESSAGE.txt";
            }
            default: {
                baseFilename = "Unknown";
                Log.log("getBaseFilename Report type '" + type + "' not valid. Returning Unknown.");
            }
        }
        return baseFilename + id;
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        int task_id = myArgs.getInt("taskid");
        Task task = Task.getById(task_id);
        String params = "inifile=" + Config.getIniPath() + " user=" + Config.getRemoteUser() + " system=" + task.system + " client=" + task.client + " taskid=" + task_id + " ";
        String logfileparam = "logfile=" + Log.getFilename() + "_content.log ";
        Settings tp = new Settings(task.params);
        Translator translator = Translator.getInstance(tp.getLanguageISO());
        int exitCode = 3;
        int exitCodeXlsx = 0;
        switch (task.type) {
            case 7: {
                exitCode = TaskHandler.executeJVM(ReportHandler.getExecutionString() + params + logfileparam, task);
                break;
            }
            case 0: {
                exitCode = TaskHandler.executeJVM(Report.getExecutionString() + params + logfileparam, task);
                break;
            }
            case 13: {
                exitCode = TaskHandler.executeJVM(apm.report.Report.getExecutionString() + params + logfileparam, task);
                break;
            }
            default: {
                Log.log("Report type not defined.");
            }
        }
        Log.log("Report had exit code " + exitCode);
        String urReport = tp.getString("type");
        String string = urReport = Utils.isEmpty(urReport) ? "" : urReport;
        if (!"UR".contentEquals(urReport) && task.type != 13) {
            if (exitCode == 1) {
                if (tp.isExcel() && new File(Config.getReportPath() + ReportStarter.getBaseFilename(task.type, task.id) + "_selections.csv ").exists() && new File(Config.getReportPath() + ReportStarter.getBaseFilename(task.type, task.id) + ".csv ").exists()) {
                    exitCode = 2;
                    Log.log("Report had exit code 1 but files exists and we assume it is partial. Setting exitCode = " + exitCode);
                } else if (!tp.isExcel() && new File(Config.getReportPath() + ReportStarter.getBaseFilename(task.type, task.id) + ".csv ").exists()) {
                    exitCode = 2;
                    Log.log("Report had exit code 1 but the file exists and we assume it is partial. Setting exitCode = " + exitCode);
                }
            }
            if (exitCode != 1) {
                if (tp.isExcel()) {
                    task.setStatusDetails(translator.getText("Converting to .xlsx"));
                    exitCodeXlsx = ReportStarter.convertReport(task, translator, logfileparam, null);
                    task.setStatusDetails(translator.getText("Complete"));
                } else {
                    String csvFilename = Config.getReportPath() + ReportStarter.getBaseFilename(task.type, task.id) + ".csv";
                    try {
                        long size = Files.size(Paths.get(csvFilename, new String[0]));
                        if (size > 0x3200000L) {
                            task.setStatusDetails(translator.getText("Compressing file size {1}B", new String[]{"" + size}));
                            task.getAttributes().setReportFilename(CSVfile.compressToZipFile(csvFilename));
                        }
                    }
                    catch (IOException e) {
                        Log.log("Unable to get filesize from '" + csvFilename + "'.");
                        Log.logException(e);
                    }
                }
            }
            task = Task.getById(task_id);
            if (exitCode == 1 || exitCodeXlsx == 1) {
                task.setStatus(4);
            } else if (exitCode == 2 || exitCodeXlsx == 2) {
                task.setStatus(3);
            } else {
                task.setStatus(2);
            }
        }
        DB.close();
        Log.close();
        if (exitCode == 1 || exitCodeXlsx == 1) {
            System.exit(1);
        }
        if (exitCode == 2 || exitCodeXlsx == 2) {
            System.exit(2);
        }
        System.exit(0);
    }

    public static int convertReport(Task task, Translator translator, String logfilename, String filename) {
        int exitCodeXlsx = 0;
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            Log.log("Thread sleep before executing csvToExcel FAILED!");
            Log.logException(e);
        }
        if (Utils.isEmpty(filename)) {
            filename = ReportStarter.getBaseFilename(task.type, task.id);
        }
        exitCodeXlsx = TaskHandler.executeJVM(TaskHandler.getConverterExecutionString() + logfilename + Config.getReportPath() + filename + "_selections.csv " + translator.getText("Selections") + " " + Config.getReportPath() + filename + ".csv " + translator.getText("Data") + " ", task);
        Log.log("csvToExcel had exit code " + exitCodeXlsx);
        return exitCodeXlsx;
    }
}

