/*
 * Decompiled with CFR 0.152.
 */
package cn.report;

import cn.Log;
import cn.report.CSVfile;

public class CSVline {
    private final CSVfile csv;
    private final String[] content;
    private int index = 0;
    private int startIndex = 0;

    public CSVline(CSVfile csv, int length) {
        this.csv = csv;
        this.content = new String[length];
        Log.log("CSVline created for " + csv.getFilename() + " with a length of " + this.content.length);
    }

    public int getLength() {
        return this.content.length;
    }

    public void add(String s) {
        if (this.index < this.content.length) {
            this.content[this.index++] = CSVline.formatCSVcontent(s);
        } else {
            Log.log("CSVline add() is trying to set index " + this.index + " in a " + this.content.length + " array. Data: '" + s + "'.");
        }
    }

    public void add(String[] ss) {
        if (this.index + ss.length <= this.content.length) {
            for (String s : ss) {
                this.content[this.index++] = CSVline.formatCSVcontent(s);
            }
        } else {
            Log.log("CSVline add([]) is trying to add " + ss.length + " to index " + this.index + " in a " + this.content.length + " array. Data: '" + String.join((CharSequence)", ", ss) + "'.");
        }
    }

    public void addFormatted(String[] ss) {
        if (this.index + ss.length <= this.content.length) {
            for (String s : ss) {
                this.content[this.index++] = s;
            }
        } else {
            Log.log("CSVline addFormatted() is trying to add " + ss.length + " to index " + this.index + " in a " + this.content.length + " array. Data: '" + String.join((CharSequence)", ", ss) + "'.");
        }
    }

    public void set(int i, String string) {
        if (i < this.content.length) {
            this.content[i] = CSVline.formatCSVcontent(string);
        } else {
            Log.log("CSVline set() is trying to set index " + i + " in a " + this.content.length + " array. Data: '" + string + "'.");
        }
    }

    public void start(String[] content) {
        System.arraycopy(content, 0, this.content, 0, content.length);
        this.index = this.startIndex = content.length;
    }

    public void start() {
        this.startIndex = this.index;
    }

    public void reset() {
        this.index = this.startIndex;
        while (this.index < this.content.length) {
            this.content[this.index] = "";
            ++this.index;
        }
        this.index = this.startIndex;
    }

    public void clear() {
        this.index = 0;
        this.startIndex = 0;
    }

    public boolean write() {
        this.index = 0;
        return this.csv.writeFormattedLine(CSVline.formatCSVline(this.content));
    }

    public boolean write(String[] content) {
        this.index = 0;
        String[] data = new String[content.length];
        for (int i = 0; i < content.length; ++i) {
            data[i] = CSVline.formatCSVcontent(content[i]);
        }
        return this.csv.writeFormattedLine(CSVline.formatCSVline(data));
    }

    public static String formatCSVline(String[] content) {
        return String.join((CharSequence)";", content) + ";\n";
    }

    public static String formatCSVcontent(String data) {
        if (data != null) {
            String escapedData = data.replaceAll("\n", " ");
            if (data.contains("\"")) {
                escapedData = data.replaceAll("\"", "");
            }
            return "\"" + escapedData + "\"";
        }
        return "\"\"";
    }

    public String toString() {
        return String.join((CharSequence)" | ", this.content);
    }
}

