/*
 * Decompiled with CFR 0.152.
 */
package cn.report;

import cn.Config;
import cn.Log;
import cn.report.CSVline;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CSVfile {
    private final boolean setExcelLineLimit;
    private final long csvFileSizeLimit;
    private final String filename;
    private final BufferedWriter output;
    private boolean continueWriting = true;
    private int lineCount = 0;
    private long filesize = 0L;
    private static long timeSpentWritingToFile = 0L;

    public CSVfile(String filename, boolean setExcelLineLimit) {
        this.filename = Config.getReportPath() + filename;
        this.output = this.getWriter();
        this.setExcelLineLimit = setExcelLineLimit;
        this.csvFileSizeLimit = Config.getCSVlimit();
        Log.log("Created CSV file '" + filename + "' with " + this.csvFileSizeLimit + "B size limit.");
    }

    private BufferedWriter getWriter() {
        Path path = Paths.get(this.filename, new String[0]);
        try {
            return Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            Log.log("CSVfile constructor FAILED! " + this.filename);
            Log.logException(e);
            return null;
        }
    }

    public void close() {
        Log.log("timeSpentWritingToFile: " + timeSpentWritingToFile + " ms.");
        Log.log("Closing file " + this.filename + ". Size " + this.filesize + " / " + this.csvFileSizeLimit + ".");
        try {
            this.output.close();
        }
        catch (IOException e) {
            Log.log("CSVfile closing file FAILED! " + this.filename);
            Log.logException(e);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public boolean writeUnformattedLine(String[] content) {
        String[] data = new String[content.length];
        for (int i = 0; i < content.length; ++i) {
            data[i] = CSVline.formatCSVcontent(content[i]);
        }
        return this.writeFormattedLine(CSVline.formatCSVline(data));
    }

    public boolean writeFormattedLine(String content) {
        if (this.continueWriting) {
            long start = System.currentTimeMillis();
            boolean bl = this.continueWriting = !this.setExcelLineLimit && this.csvFileSizeLimit > this.filesize + (long)content.length() || this.setExcelLineLimit && this.lineCount <= 0x100000;
            if (this.continueWriting) {
                this.continueWriting = CSVfile.writeDirectlyToFile(this, content);
                this.filesize += (long)content.length();
                ++this.lineCount;
            } else {
                Log.log("writeLine: " + this.filename + " has been set to not write any further. Either the file is full or an error happened during write.");
                Log.log("writeLine: " + this.filename + " has " + this.lineCount + " lines, sizing " + this.filesize + " of " + this.csvFileSizeLimit + "B.");
            }
            timeSpentWritingToFile += System.currentTimeMillis() - start;
            return this.continueWriting;
        }
        Log.log("addLine: " + this.filename + " has been set to not write any further. Either the file is full or an error happened during write.");
        Log.log("addLine: This method call should not have been made as method has already returned FALSE on last call.");
        return false;
    }

    public static boolean writeDirectlyToFile(CSVfile csvFile, String data) {
        try {
            csvFile.output.append(data);
        }
        catch (Exception e) {
            Log.log("CSVfile writeLinePreprocessed FAILED to write data to file " + csvFile.filename);
            Log.logException(e);
            return false;
        }
        return true;
    }

    public static String compressToZipFile(String csvFilename) {
        int index = csvFilename.lastIndexOf(".csv");
        String name = csvFilename.substring(0, index);
        String zipfilename = name + ".zip";
        File csvFile = new File(csvFilename);
        try {
            Log.log("Creating file '" + zipfilename + "'.");
            FileOutputStream fout = new FileOutputStream(zipfilename);
            ZipOutputStream zout = new ZipOutputStream(fout);
            zout.setLevel(9);
            ZipEntry ze = new ZipEntry(csvFile.getName());
            ze.setMethod(8);
            zout.putNextEntry(ze);
            FileInputStream csvData = new FileInputStream(csvFile);
            csvData.transferTo(zout);
            csvData.close();
            zout.closeEntry();
            zout.close();
        }
        catch (IOException e) {
            Log.log("cn.CSVfile was unable to create " + zipfilename);
            Log.logException(e);
        }
        Log.log("Deleting file '" + csvFilename + "'.");
        csvFile.delete();
        return zipfilename;
    }
}

