/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.Log;
import java.lang.invoke.CallSite;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.IntStream;

public class Utils {
    public static final String EMPTYSTRING = "";
    public static final String NEWLINE = "\n";
    public static final String TAB = "\t";
    public static final String COMMA = ",";
    public static final String COMMASPACE = ", ";
    public static final String QUOTE = "\"";
    public static final String QUOTE_SINGLE = "'";
    public static final String SEPARATOR = ";";
    public static final String SLASH = " / ";
    public static final String SPACE = " ";
    public static final String STJERNE = "*";
    public static final String ZERO = "0";
    public static final String[] EMPTYSTRINGARRAY = new String[0];
    public static final int[] EMPTYINTARRAY = new int[0];

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static boolean isEmpty(String[] strs) {
        if (strs != null) {
            for (String str : strs) {
                if (str == null || str.length() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmpty(int[] ints) {
        return ints == null || ints.length <= 0;
    }

    public static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static int toInteger(String s) {
        return (int)Double.parseDouble(s);
    }

    public static int ceilDivider(int numerator, int denominator) {
        double x = numerator;
        double y = denominator;
        double r = x / y;
        return (int)Math.ceil(r);
    }

    public static long ceilDivider(long numerator, int denominator) {
        double x = numerator;
        double y = denominator;
        double r = x / y;
        return (long)Math.ceil(r);
    }

    public static String decodeUrlValue(String value) {
        if (value != null) {
            try {
                return URLDecoder.decode(value, StandardCharsets.UTF_8.toString());
            }
            catch (Exception e) {
                Log.log("Utils decodeUrlValue failed!");
                Log.log("decodeUrlValue: " + value);
                Log.logException(e);
            }
        }
        return EMPTYSTRING;
    }

    public static String ltrim(String string, String remove) {
        String newString = string;
        while (newString.contains(remove) && newString.indexOf(remove) == 0) {
            newString = newString.substring(remove.length(), newString.length());
        }
        return newString;
    }

    public static String rtrim(String string, String remove) {
        String newString = string;
        while (newString.contains(remove) && newString.indexOf(remove) == newString.length() - remove.length()) {
            newString = newString.substring(0, newString.length() - remove.length());
        }
        return newString;
    }

    public static int[][] chunk(int[] input, int chunkSize) {
        long limit = Utils.ceilDivider((long)input.length, chunkSize);
        return (int[][])IntStream.iterate(0, i -> i + chunkSize).limit(limit).mapToObj(j -> Arrays.copyOfRange(input, j, j + chunkSize > input.length ? input.length : j + chunkSize)).toArray(x$0 -> new int[x$0][]);
    }

    public static <T> int countUnique(Collection<T> list) {
        return Utils.unique(list).size();
    }

    public static <T> Collection<T> unique(Collection<T> list) {
        ArrayList<T> newList = new ArrayList<T>();
        for (T element : list) {
            if (newList.contains(element)) continue;
            newList.add(element);
        }
        return newList;
    }

    public static <T> void uniquefyArrayList(ArrayList<T> list) {
        ArrayList<T> newList = new ArrayList<T>();
        for (int i = list.size() - 1; i >= 0; --i) {
            T element = list.get(i);
            if (element != null && !newList.contains(element)) {
                newList.add(element);
                continue;
            }
            list.remove(i);
        }
    }

    public static <T> ArrayList<T> uniqueArrayToArrayList(T[] array) {
        ArrayList<T> newList = new ArrayList<T>();
        for (int i = array.length - 1; i >= 0; --i) {
            T element = array[i];
            if (element == null || newList.contains(element)) continue;
            newList.add(element);
        }
        return newList;
    }

    public static int[] unique(int[] numbers) {
        ArrayList<Integer> myNumbers = new ArrayList<Integer>();
        for (int number : numbers) {
            if (myNumbers.contains(number)) continue;
            myNumbers.add(number);
        }
        return myNumbers.stream().mapToInt(i -> i).toArray();
    }

    public static String[] unique(String[] strings) {
        ArrayList<String> myStrings = new ArrayList<String>();
        for (String element : strings) {
            if (element == null || (element = element.trim()).length() <= 0 || myStrings.contains(element)) continue;
            boolean exists = false;
            for (String s : myStrings) {
                if (!s.contentEquals(element)) continue;
                exists = true;
            }
            if (exists) continue;
            myStrings.add(element);
        }
        return myStrings.toArray(EMPTYSTRINGARRAY);
    }

    public static String[] arrayMerge(String[] a1, String[] a2) {
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return Utils.unique(result);
    }

    public static <T> Collection<T> mergeCollections(Collection<T> col1, Collection<T> col2) {
        for (T t : col2) {
            col1.add(t);
        }
        return col1;
    }

    public static <T> ArrayList<T> addArrayToArrayList(ArrayList<T> arrayList, T[] array) {
        for (T o : array) {
            arrayList.add(o);
        }
        return arrayList;
    }

    public static HashMap<String, String> getMultiSettingFromUrl(String rawUrlParams) {
        String[] params;
        HashMap<String, String> result = new HashMap<String, String>();
        String decoded = Utils.decodeUrlValue(rawUrlParams);
        for (String param : params = decoded.split("&")) {
            String[] individual = param.split("=");
            if (individual.length < 2) continue;
            result.put(individual[0], individual[1]);
        }
        return result;
    }

    public static String titleCase(String string) {
        StringBuilder sb = new StringBuilder();
        String upperCase = string.toUpperCase();
        String lowerCase = string.toLowerCase();
        for (int i = 0; i < string.length(); ++i) {
            if (i == 0) {
                sb.append(upperCase.charAt(i));
                continue;
            }
            if (string.charAt(i - 1) == ' ') {
                sb.append(upperCase.charAt(i));
                continue;
            }
            sb.append(lowerCase.charAt(i));
        }
        return sb.toString();
    }

    public static int[] getIdsFromString(String string) {
        if (string != null && string.length() > 0) {
            String[] sids = string.split(COMMA);
            int[] ids = new int[sids.length];
            int i = 0;
            for (String sid : sids) {
                if (!Utils.isNumeric(sid = sid.trim())) continue;
                ids[i++] = Integer.parseInt(sid);
            }
            return Utils.unique(ids);
        }
        return new int[0];
    }

    public static String toQuotedString(String[] strings) {
        if (!Utils.isEmpty(strings)) {
            StringBuilder sb = new StringBuilder();
            for (String s : strings) {
                sb.append(QUOTE_SINGLE);
                sb.append(s);
                sb.append(QUOTE_SINGLE);
                sb.append(COMMA);
            }
            return sb.substring(0, sb.length() - 1);
        }
        return EMPTYSTRING;
    }

    public static String toQuotedString(int[] ints) {
        if (!Utils.isEmpty(ints)) {
            StringBuilder sb = new StringBuilder();
            for (int i : ints) {
                sb.append(QUOTE_SINGLE);
                sb.append(i);
                sb.append(QUOTE_SINGLE);
                sb.append(COMMA);
            }
            return sb.substring(0, sb.length() - 1);
        }
        return EMPTYSTRING;
    }

    public static int[] integerListToIntArray(Collection<Integer> collection) {
        return collection.stream().mapToInt(i -> i).toArray();
    }

    public static Collection<Integer> intArrayToIntegerList(int[] intArray) {
        ArrayList<Integer> ai = new ArrayList<Integer>();
        for (int i : intArray) {
            ai.add(i);
        }
        return ai;
    }

    public static boolean inArray(String[] stringArray, String string) {
        for (String s : stringArray) {
            if (!s.contentEquals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean inArray(int[] intArray, int integer) {
        for (int i : intArray) {
            if (i != integer) continue;
            return true;
        }
        return false;
    }

    public static String integerListToString(Collection<Integer> intList) {
        ArrayList<CallSite> strings = new ArrayList<CallSite>();
        for (int i : intList) {
            strings.add((CallSite)((Object)(EMPTYSTRING + i)));
        }
        return String.join((CharSequence)COMMASPACE, strings.toArray(EMPTYSTRINGARRAY));
    }
}

