/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.Config;
import cn.Language;
import cn.Log;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class Translator {
    private static final String[] validLanguages = new String[]{"da", "de", "en", "fr", "tr"};
    private static final Translator[] currentTranslators = new Translator[validLanguages.length];
    private final String languageISOcode;
    private final Map<String, String> translation = new HashMap<String, String>();
    private final boolean notEnglish;

    public static Translator getInstance(String languageISOcode) {
        int index = Translator.getIndex(languageISOcode = Translator.isLanguageAvailable(languageISOcode = languageISOcode.toLowerCase()) ? languageISOcode : Config.getFallbackLanguageISO());
        if (currentTranslators[index] == null) {
            Translator.currentTranslators[index] = new Translator(languageISOcode);
        }
        return currentTranslators[index];
    }

    private Translator(String languageISOcode) {
        this.languageISOcode = languageISOcode;
        if (this.languageISOcode.contentEquals("en")) {
            this.notEnglish = false;
        } else {
            this.notEnglish = true;
            this.readFile();
        }
    }

    public String getText(String text) {
        if (this.notEnglish && text != null && text.length() > 0 && this.translation.containsKey(text)) {
            return this.translation.get(text);
        }
        return text;
    }

    public String getText(String text, String[] replacementValues) {
        String translation = this.getText(text);
        for (int i = 0; i < replacementValues.length; ++i) {
            translation = translation.replace("{" + (i + 1) + "}", replacementValues[i]);
        }
        return translation;
    }

    public Language getLanguage() {
        return Language.getLanguage(this.languageISOcode);
    }

    private static int getIndex(String languageISOcode) {
        int index = -1;
        for (int i = 0; i < validLanguages.length; ++i) {
            if (!validLanguages[i].equals(languageISOcode)) continue;
            index = i;
            break;
        }
        return index;
    }

    private void readFile() {
        if (!this.languageISOcode.equals("en")) {
            String filename = "CN" + File.separator + "L10N" + File.separator + "translations_" + this.languageISOcode + ".json";
            File f = new File(filename);
            Log.log(f.getAbsolutePath());
            try {
                String jsonString = new String(Files.readAllBytes(Path.of(f.toURI())), StandardCharsets.UTF_8);
                jsonString = this.languageISOcode.equals("da") ? this.removeComments(jsonString) : jsonString;
                JSONObject jsonObject = new JSONObject(jsonString);
                this.traverseAndMapJson(jsonObject);
            }
            catch (Exception e) {
                Log.log("Translator.readFile Exception while reading translation or parsing JSON file: " + filename);
                Log.logException(e);
            }
        } else {
            Log.log("Not reading translation file as the language is English.");
        }
    }

    private String removeComments(String jsonString) {
        return jsonString.replaceAll("/\\*(.|[\\r\\n])*?\\*/|//.*", "");
    }

    private void traverseAndMapJson(JSONObject jsonObject) {
        Iterator keys = jsonObject.keys();
        String key = "not set yet";
        try {
            while (keys.hasNext()) {
                key = (String)keys.next();
                Object value = jsonObject.get(key);
                String stringValue = value.toString();
                this.translation.putIfAbsent(key, stringValue);
            }
        }
        catch (Exception e) {
            Log.log("Translating JSON failed at key: " + key);
        }
    }

    public static boolean isLanguageAvailable(String languageISOcode) {
        boolean contains = Arrays.stream(validLanguages).anyMatch(s -> s.equals(languageISOcode));
        return contains;
    }
}

