/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.DB;
import cn.Log;
import cn.SapUser;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import um.Usage;

public class Tcode {
    public static final Tcode[] EMPTYARRAY = new Tcode[0];
    private static HashMap<Integer, Tcode> loadedTcodes = new HashMap();
    private static HashMap<String, Integer> loadedNames = new HashMap();
    public static long timeUsedLoadingTcodesById = 0L;
    public final int id;
    public final String name;
    public final String description;
    private static PreparedStatement ps_loadByName = null;
    private static PreparedStatement ps_loadById = null;
    private static PreparedStatement PS_DaysUsed = null;
    private static PreparedStatement ps_loadMultipleByNameSearch = null;

    public static boolean isLoaded(int tcode_id) {
        return loadedTcodes.containsKey(tcode_id);
    }

    public static Tcode getById(int tcode_id) {
        if (!loadedTcodes.containsKey(tcode_id)) {
            long start = System.currentTimeMillis();
            if (tcode_id > 0) {
                Tcode.loadFromId(tcode_id);
            }
            if (tcode_id < 1 || !loadedTcodes.containsKey(tcode_id)) {
                loadedTcodes.putIfAbsent(tcode_id, Tcode.create(tcode_id, "", ""));
            }
            timeUsedLoadingTcodesById += System.currentTimeMillis() - start;
        }
        return loadedTcodes.get(tcode_id);
    }

    private Tcode(int id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public static Tcode create(int id, String name, String description) {
        if (!loadedTcodes.containsKey(id)) {
            loadedTcodes.put(id, new Tcode(id, name, description));
            loadedNames.put(name, id);
        }
        return loadedTcodes.get(id);
    }

    public static int getIdFromName(String tcodename, String system, String client) {
        if (!loadedNames.containsKey(tcodename)) {
            if (ps_loadByName == null) {
                String sql = "SELECT `id`, `tcode`, `description` FROM um_tcode WHERE tcode = ? AND `system` = ? AND `client` = ?;";
                ps_loadByName = DB.prepareStatement(sql);
                Log.log("cn.Tcode prepared statement: " + sql);
            }
            try {
                ps_loadByName.setString(1, tcodename);
                ps_loadByName.setString(2, system);
                ps_loadByName.setString(3, client);
                ResultSet rs = ps_loadByName.executeQuery();
                if (rs.next()) {
                    int tcode_id = rs.getInt(1);
                    String name = rs.getString(2);
                    loadedTcodes.put(tcode_id, new Tcode(tcode_id, name, rs.getString(3)));
                    loadedNames.put(name, tcode_id);
                } else {
                    loadedTcodes.put(-1, new Tcode(-1, tcodename, "Deleted tcode"));
                    loadedNames.put(tcodename, -1);
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("Tcode FAILED loading tcode id for " + tcodename);
                Log.logException(e);
            }
        }
        if (loadedNames.containsKey(tcodename)) {
            return loadedNames.get(tcodename);
        }
        return -1;
    }

    private static void loadFromId(int tcode_id) {
        if (ps_loadById == null) {
            ps_loadById = DB.prepareStatement("SELECT `tcode`, `description` FROM um_tcode WHERE id = ? ;");
            Log.log("cn.Tcode prepared statement: SELECT `tcode`, `description` FROM um_tcode WHERE id = ? ;");
        }
        try {
            ps_loadById.setInt(1, tcode_id);
            ResultSet rs = ps_loadById.executeQuery();
            if (rs.next()) {
                Tcode tcode = new Tcode(tcode_id, rs.getString(1), rs.getString(2));
                loadedTcodes.put(tcode_id, tcode);
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Tcode FAILED loading tcode w id " + tcode_id);
            Log.logException(e);
        }
    }

    public static int getDaysUsed(SapUser user, String tcode) {
        if (PS_DaysUsed == null) {
            String table = Usage.getUsageTable(user.system, user.client);
            if (DB.isTable(table)) {
                PS_DaysUsed = DB.prepareStatement("SELECT COUNT(DISTINCT(`date`)) AS total FROM `" + table + "` WHERE user = ? AND tcode = ? ;");
            } else {
                Log.log("Usage table `" + table + "` does NOT exist! Tcode getDaysUsed returning 0.");
                return 0;
            }
        }
        try {
            PS_DaysUsed.setString(1, user.username);
            PS_DaysUsed.setString(2, tcode);
        }
        catch (SQLException e) {
            Log.log("Tcode getDaysUsed FAILED!");
            Log.logException(e);
        }
        return DB.preparedStatementGetCount(PS_DaysUsed);
    }

    public static void loadAllTcodes(String system, String client) {
        long start = System.currentTimeMillis();
        PreparedStatement ps = DB.prepareStatement("SELECT id, tcode, description FROM um_tcode WHERE `system` = ? AND `client` = ?;");
        try {
            ps.setString(1, system);
            ps.setString(2, client);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int tcode_id = rs.getInt(1);
                String tcode_name = rs.getString(2);
                loadedTcodes.put(tcode_id, new Tcode(tcode_id, tcode_name, rs.getString(3)));
                loadedNames.put(tcode_name, tcode_id);
            }
        }
        catch (SQLException e) {
            Log.log("FAILED cn.Tcode.loadAllTcodes (" + system + "/" + client + ")");
            Log.logException(e);
        }
        timeUsedLoadingTcodesById += System.currentTimeMillis() - start;
    }

    public static ArrayList<Integer> getIdsFromAsteriskSearch(String tcodename, String system, String client) {
        ArrayList<Integer> tcode_ids = new ArrayList<Integer>();
        if (ps_loadMultipleByNameSearch == null) {
            String sql = "SELECT `id`, `tcode`, `description` FROM um_tcode WHERE tcode LIKE ? AND `system` = ? AND `client` = ?;";
            ps_loadMultipleByNameSearch = DB.prepareStatement(sql);
            Log.log("cn.Tcode prepared statement: " + sql);
        }
        try {
            String searchPattern = tcodename.replace('*', '%');
            ps_loadMultipleByNameSearch.setString(1, searchPattern);
            ps_loadMultipleByNameSearch.setString(2, system);
            ps_loadMultipleByNameSearch.setString(3, client);
            ResultSet rs = ps_loadMultipleByNameSearch.executeQuery();
            while (rs.next()) {
                int tcode_id = rs.getInt(1);
                String name = rs.getString(2);
                loadedTcodes.put(tcode_id, new Tcode(tcode_id, name, rs.getString(3)));
                loadedNames.put(name, tcode_id);
                tcode_ids.add(tcode_id);
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Tcode FAILED loading tcode id for " + tcodename);
            Log.logException(e);
        }
        return tcode_ids;
    }
}

