/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.DB;
import cn.Log;
import cn.Utils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskParameters {
    private static final String X = "X";
    private static final String T = "true";
    private static final String O = "on";
    private static final String N = "1";
    private final boolean isExcel;
    protected final JSONObject params;
    public final String system;
    public final String client;
    private HashMap<String, Boolean> booleans = new HashMap();

    public TaskParameters(String data) {
        Log.log(data);
        this.params = new JSONObject(data);
        this.system = this.isSet("system") ? this.getString("system") : "";
        this.client = this.isSet("client") ? this.getString("client") : "";
        int output = this.getInt("outputFormat");
        this.isExcel = output == 1 || output == -1;
    }

    public boolean isSet(String property) {
        return this.params.has(property);
    }

    public String getString(String property) {
        if (this.isSet(property)) {
            try {
                return this.params.getString(property);
            }
            catch (JSONException e) {
                Log.log("Parameters cannot find string " + property);
                return null;
            }
        }
        return null;
    }

    public boolean getBoolean(String property) {
        if (!this.booleans.containsKey(property)) {
            this.booleans.put(property, false);
            String content = this.getString(property);
            if (content == null) {
                this.booleans.put(property, false);
            } else if (content.length() > 0) {
                this.booleans.put(property, content.contentEquals(X) || content.equalsIgnoreCase(T) || content.contentEquals(O) || content.contentEquals(N));
            }
        }
        return this.booleans.get(property);
    }

    public int getInt(String property) {
        try {
            return this.params.getInt(property);
        }
        catch (JSONException e) {
            return -1;
        }
    }

    public String[] getStringArray(String property) {
        String[] stringarray = Utils.EMPTYSTRINGARRAY;
        if (this.isSet(property)) {
            try {
                JSONArray jsonarray = this.params.optJSONArray(property);
                if (jsonarray != null) {
                    stringarray = new String[jsonarray.length()];
                    for (int i = 0; i < jsonarray.length(); ++i) {
                        stringarray[i] = jsonarray.getString(i);
                    }
                }
            }
            catch (Exception e) {
                Log.log("Parameters cannot find string array " + property);
            }
        }
        return stringarray;
    }

    public int[] getIntArray(String property) {
        int[] intarray = Utils.EMPTYINTARRAY;
        String[] stringarray = this.getStringArray(property);
        if (stringarray.length > 0) {
            intarray = Stream.of(stringarray).mapToInt(Integer::parseInt).toArray();
        }
        return intarray;
    }

    public String toString() {
        return this.params.toString();
    }

    public String getLanguageISO() {
        return this.getString("language");
    }

    public boolean excludeUsersLocked() {
        if (this.isSet("excludeUsersLocked")) {
            return this.getString("excludeUsersLocked").contentEquals(X);
        }
        if (this.isSet("usersExcludeLocked")) {
            return this.getString("usersExcludeLocked").contentEquals(X);
        }
        return false;
    }

    public boolean excludeUsersExpired() {
        if (this.isSet("excludeUsersExpired")) {
            return this.getString("excludeUsersExpired").contentEquals(X);
        }
        if (this.isSet("usersExcludeExpired")) {
            return this.getString("usersExcludeExpired").contentEquals(X);
        }
        return false;
    }

    public boolean isExcel() {
        return this.isExcel;
    }

    public int[] getUserIdsFromParams() {
        String[] usernames = this.getStringArray("user");
        ArrayList<String> directNames = new ArrayList<String>();
        ArrayList<CallSite> wildcards = new ArrayList<CallSite>();
        if (usernames.length > 0) {
            for (String username : usernames) {
                if (username.contains("*")) {
                    wildcards.add((CallSite)((Object)("user LIKE '" + username.replace('*', '%') + "' ")));
                    continue;
                }
                directNames.add(username);
            }
        }
        StringBuilder sql = new StringBuilder("SELECT id FROM um_user WHERE `system` = '" + this.system + "' AND `client` = '" + this.client + "' ");
        if (wildcards.size() > 0 || directNames.size() > 0) {
            sql.append("AND ( ");
        }
        if (directNames.size() > 0) {
            sql.append("user IN (" + Utils.toQuotedString(directNames.toArray(Utils.EMPTYSTRINGARRAY)) + ") ");
        }
        if (wildcards.size() > 0) {
            if (directNames.size() > 0) {
                sql.append("OR ");
            }
            sql.append(String.join((CharSequence)"OR ", wildcards.toArray(Utils.EMPTYSTRINGARRAY)));
        }
        if (wildcards.size() > 0 || directNames.size() > 0) {
            sql.append(") ");
        }
        CharSequence[] userGroups = this.getStringArray("userGroup");
        CharSequence[] userTypes = this.getStringArray("userType");
        if (!Utils.isEmpty((String[])userGroups)) {
            sql.append("AND um_user.user_group IN ('" + String.join((CharSequence)"', '", userGroups) + "') \n");
        }
        if (!Utils.isEmpty((String[])userTypes)) {
            sql.append("AND um_user.type IN ('" + String.join((CharSequence)"', '", userTypes) + "') \n");
        }
        if (this.excludeUsersLocked()) {
            sql.append("AND IFNULL(um_user.locked, 'U') <> 'L' \n");
        }
        if (this.excludeUsersExpired()) {
            sql.append("AND (um_user.valid_to IS NULL OR um_user.valid_to >= CURDATE() OR um_user.valid_to = '0000-00-00') \n");
        }
        Log.log("cn.TaskParameters Finding user ids: " + sql.toString());
        return DB.getOneNumberColumn(sql.toString());
    }

    public int[] getRoleIds() {
        String[] rolenames = this.getStringArray("role");
        if (rolenames.length > 0) {
            ArrayList<CallSite> wildcards = new ArrayList<CallSite>();
            ArrayList<String> directNames = new ArrayList<String>();
            for (String rolename : rolenames) {
                if (rolename.contains("*")) {
                    wildcards.add((CallSite)((Object)("role LIKE '" + rolename.replace('*', '%') + "' ")));
                    continue;
                }
                directNames.add(rolename);
            }
            StringBuilder sql = new StringBuilder("SELECT id FROM um_role WHERE `system` = '" + this.system + "' AND `client` = '" + this.client + "' AND (");
            if (directNames.size() > 0) {
                sql.append("role IN (" + Utils.toQuotedString(directNames.toArray(Utils.EMPTYSTRINGARRAY)) + ") ");
            }
            if (wildcards.size() > 0) {
                if (directNames.size() > 0) {
                    sql.append("OR ");
                }
                sql.append(String.join((CharSequence)"OR ", wildcards.toArray(Utils.EMPTYSTRINGARRAY)));
            }
            sql.append(") ");
            String roleType = this.getString("roleType");
            if (!Utils.isEmpty(roleType)) {
                switch (roleType) {
                    case "S": {
                        sql.append("AND `type` = 'S' ");
                        break;
                    }
                    case "C": {
                        sql.append("AND `type` = 'C' ");
                        break;
                    }
                    case "A": {
                        sql.append("AND um_role.id IN (SELECT role_id FROM um_user_role \tJOIN um_user AS u ON u.id = um_user_role.user_id AND u.um_delete = 0 \tWHERE \t\tum_user_role.system = '" + this.system + "' AND\t\t\tum_user_role.client = '" + this.client + "' AND \t\tum_user_role.um_delete = 0 AND \t    u.um_delete = 0 \t) ");
                        break;
                    }
                }
            }
            sql.append(" ORDER BY role;");
            String statement = sql.toString();
            Log.log("cn.TaskParameters getRoleIds as " + statement);
            return DB.getOneNumberColumn(statement);
        }
        return Utils.EMPTYINTARRAY;
    }
}

