/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.DB;
import cn.Log;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class SapUser {
    public static final SapUser[] EMPTYARRAY = new SapUser[0];
    public final String username;
    public final String system;
    public final String client;
    public String first_name;
    public String last_name;
    protected int id = -1;
    protected String mail;
    protected String user_group;
    protected String locked;
    protected String licenseSU01;
    protected String licenseSU01Text;
    protected String user_type;
    public int count;
    private static HashMap<Integer, SapUser> LOADED_SapUsers = new HashMap();
    private static PreparedStatement PS_LOAD_USER = null;
    private static PreparedStatement PS_LOAD_USER_DATA = null;
    private static HashMap<String, String> licenseTypes = new HashMap();

    public SapUser(String username, String system, String client) {
        this.username = username;
        this.system = system;
        this.client = client;
    }

    public SapUser(int id, String username, String system, String client) {
        this.id = id;
        this.username = username;
        this.system = system;
        this.client = client;
    }

    public String toString() {
        return String.format("%s (%s/%s)", this.username, this.system, this.client);
    }

    public String getToFullString() {
        return String.format("%s %s %s (%s/%s)", this.getFirstName(), this.getLastName(), this.username, this.system, this.client);
    }

    public String getUserName() {
        if (this.username == null) {
            SapUser.loadData(this);
        }
        return this.username;
    }

    public String getLastName() {
        if (this.last_name == null) {
            SapUser.loadData(this);
        }
        return this.last_name;
    }

    public String getFirstName() {
        if (this.first_name == null) {
            SapUser.loadData(this);
        }
        return this.first_name;
    }

    public String getName() {
        if (!Utils.isEmpty(this.getFirstName())) {
            return this.getFirstName() + " " + this.getLastName();
        }
        return this.getLastName();
    }

    public String getEmail() {
        if (this.mail == null) {
            SapUser.loadData(this);
        }
        return this.mail;
    }

    public String getUserGroup() {
        if (this.user_group == null) {
            SapUser.loadData(this);
        }
        return this.user_group;
    }

    public boolean isLocked() {
        if (this.locked == null) {
            SapUser.loadData(this);
        }
        return this.locked == null ? false : this.locked.equalsIgnoreCase("L");
    }

    public String getSU01License() {
        if (this.licenseSU01Text == null) {
            SapUser.loadData(this);
        }
        return this.licenseSU01Text;
    }

    public String getUserType() {
        if (this.user_type == null) {
            SapUser.loadData(this);
        }
        return this.user_type;
    }

    public void setFirstName(String first_name) {
        this.first_name = first_name;
    }

    public void setLastName(String last_name) {
        this.last_name = last_name;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public void setLocked(String lockedStatus) {
        this.locked = lockedStatus;
    }

    public void setUserGroup(String user_group) {
        this.user_group = user_group;
    }

    public void setUserType(String user_type_text) {
        this.user_type = user_type_text;
    }

    public void setLicenseType(String licenseType) {
        this.licenseSU01 = licenseType;
    }

    public int getId() {
        if (this.id < 0) {
            SapUser.loadData(this);
        }
        return this.id;
    }

    public static SapUser createUser(int id, String username, String system, String client) {
        if (!LOADED_SapUsers.containsKey(id)) {
            LOADED_SapUsers.put(id, new SapUser(id, username, system, client));
        }
        return LOADED_SapUsers.get(id);
    }

    public static boolean exist(int user_id) {
        return LOADED_SapUsers.containsKey(user_id);
    }

    public static SapUser getById(int user_id) {
        if (!SapUser.exist(user_id)) {
            LOADED_SapUsers.put(user_id, SapUser.loadUser(user_id));
        }
        return LOADED_SapUsers.get(user_id);
    }

    protected static SapUser loadUser(int id) {
        if (id > 0) {
            if (PS_LOAD_USER == null) {
                PS_LOAD_USER = DB.prepareStatement("SELECT * FROM um_user WHERE id = ?;");
            }
            try {
                PS_LOAD_USER.setInt(1, id);
                ResultSet rs = PS_LOAD_USER.executeQuery();
                if (rs.next()) {
                    SapUser sapUser = new SapUser(id, rs.getString("user"), rs.getString("system"), rs.getString("client"));
                    sapUser.user_group = rs.getString("user_group");
                    sapUser.first_name = rs.getString("first_name");
                    sapUser.last_name = rs.getString("last_name");
                    sapUser.mail = rs.getString("mail");
                    sapUser.user_type = SapUser.getUserTypeText(rs.getString("type"));
                    sapUser.locked = rs.getString("locked");
                    sapUser.licenseSU01 = rs.getString("license_type");
                    sapUser.licenseSU01Text = sapUser.licenseSU01 == null ? "" : SapUser.getLicenseText(sapUser.licenseSU01, sapUser.system, sapUser.client);
                    return sapUser;
                }
            }
            catch (SQLException e) {
                Log.log("SapUser failed to load by id " + id + ".");
                Log.logException(e);
            }
        }
        return new SapUser("", "", "");
    }

    private static void loadData(SapUser sapUser) {
        if (sapUser.id < 0) {
            if (PS_LOAD_USER_DATA == null) {
                PS_LOAD_USER_DATA = DB.prepareStatement("SELECT * FROM um_user WHERE `system` = ? AND `client` = ? AND `user` = ?;");
            }
            try {
                PS_LOAD_USER_DATA.setString(1, sapUser.system);
                PS_LOAD_USER_DATA.setString(2, sapUser.client);
                PS_LOAD_USER_DATA.setString(3, sapUser.username);
                ResultSet rs = PS_LOAD_USER_DATA.executeQuery();
                while (rs.next()) {
                    sapUser.id = rs.getInt("id");
                    sapUser.user_group = rs.getString("user_group");
                    sapUser.first_name = rs.getString("first_name");
                    sapUser.last_name = rs.getString("last_name");
                    sapUser.mail = rs.getString("mail");
                    sapUser.user_type = SapUser.getUserTypeText(rs.getString("type"));
                    sapUser.locked = rs.getString("locked");
                    sapUser.licenseSU01 = rs.getString("license_type");
                    sapUser.licenseSU01Text = sapUser.licenseSU01 == null ? "" : SapUser.getLicenseText(sapUser.licenseSU01, sapUser.system, sapUser.client);
                }
            }
            catch (SQLException e) {
                Log.log("SapUser failed to load data by name (" + sapUser.toString() + ").");
                Log.logException(e);
            }
        } else if (sapUser.id > 0) {
            SapUser sapUser2 = SapUser.getById(sapUser.id);
            sapUser.id = sapUser2.id;
            sapUser.user_group = sapUser2.user_group;
            sapUser.first_name = sapUser2.first_name;
            sapUser.last_name = sapUser2.last_name;
            sapUser.mail = sapUser2.mail;
            sapUser.user_type = sapUser2.user_type;
            sapUser.locked = sapUser2.locked;
            sapUser.licenseSU01 = sapUser2.licenseSU01;
            sapUser.licenseSU01Text = sapUser2.licenseSU01Text;
        } else {
            sapUser.user_group = "";
            sapUser.first_name = "";
            sapUser.last_name = "";
            sapUser.mail = "";
            sapUser.user_type = "";
            sapUser.locked = "";
            sapUser.licenseSU01 = "";
            sapUser.licenseSU01Text = "";
        }
    }

    private static String getLicenseText(String licenseType, String system, String client) {
        if (!licenseTypes.containsKey(licenseType)) {
            ResultSet rs = DB.getData("SELECT `type`, `text` FROM um_license_text WHERE `system` = '" + system + "' AND `client` = '" + client + "';");
            try {
                while (rs.next()) {
                    licenseTypes.put(rs.getString("type"), rs.getString("text"));
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("SapUser Failed while loading license types.");
                Log.logException(e);
                return "Load failed!";
            }
        }
        return licenseTypes.get(licenseType);
    }

    protected static String getUserTypeText(String user_type_code) {
        if (user_type_code != null) {
            switch (user_type_code) {
                case "A": {
                    return "Dialog";
                }
                case "B": {
                    return "System";
                }
                case "C": {
                    return "Communications Data";
                }
                case "L": {
                    return "Reference";
                }
                case "S": {
                    return "Service";
                }
            }
        }
        return "Unknown";
    }
}

