/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.DB;
import cn.Log;
import cn.SapStarLicense;
import cn.Translator;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import um.RoleJournalAttribute;

public class Role {
    protected static long timeSpentLoading = 0L;
    public final int id;
    public final String name;
    public final String system;
    public final String client;
    public String description;
    private int sapStarCategoryStep = 0;
    public boolean isComposite;
    private static PreparedStatement ps_rj_attributes = null;
    private String rj_attributes = null;
    private static PreparedStatement PS_load_role = null;

    public static long getTimeSpentLoading() {
        return TimeUnit.NANOSECONDS.toMillis(timeSpentLoading);
    }

    protected Role(int id, String name, String description, boolean isComposite, String system, String client) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.isComposite = isComposite;
        this.system = system;
        this.client = client;
    }

    public String getDescription() {
        if (this.description == null) {
            this.loadAttributes();
        }
        return this.description;
    }

    public int getSapStarStep() {
        if (this.sapStarCategoryStep <= 0) {
            this.loadAttributes();
        }
        return this.sapStarCategoryStep;
    }

    public String getSapStarLicense(Translator translator) {
        if (this.sapStarCategoryStep <= 0) {
            this.loadAttributes();
        }
        return SapStarLicense.getLicenseText(this.system, this.client, this.sapStarCategoryStep, translator);
    }

    public void setSapStarStep(int step) {
        this.sapStarCategoryStep = step;
    }

    private void loadAttributes() {
        if (PS_load_role == null) {
            Role.createLoadRoleStatement();
        }
        try {
            PS_load_role.setInt(1, this.id);
            ResultSet rs = PS_load_role.executeQuery();
            while (rs.next()) {
                String description = rs.getString("description");
                this.description = Utils.isEmpty(description) ? "" : description;
                this.sapStarCategoryStep = rs.getInt("star_category_step");
            }
        }
        catch (SQLException e) {
            Log.log("Role.getDescription() failed loading description.");
            Log.logException(e);
        }
    }

    public String toString() {
        return this.id + " " + this.name + " " + (this.isComposite ? "C" : "S") + " " + this.system + " / " + this.client;
    }

    public String getRoleJournalAttributeOutput() {
        if (this.rj_attributes == null) {
            if (ps_rj_attributes == null) {
                String sql = "SELECT attribute_choice_id FROM um_role_attributes WHERE role_id = ? ;";
                Log.log("cn.Role preparing statement: " + sql);
                ps_rj_attributes = DB.prepareStatement(sql);
            }
            try {
                ps_rj_attributes.setInt(1, this.id);
                this.rj_attributes = RoleJournalAttribute.idsToString(this.system, this.client, DB.preparedStatementGetOneIntColumn(ps_rj_attributes));
                if (this.rj_attributes.length() > 0) {
                    Log.log("cn.Role found " + this.rj_attributes + " for role " + this.name);
                }
            }
            catch (Exception e) {
                Log.log("cn.Role getRoleJournalAttributes FAILED!");
                Log.logException(e);
            }
        }
        return this.rj_attributes;
    }

    public static Role getById(int role_id) {
        Role role = null;
        if (PS_load_role == null) {
            Role.createLoadRoleStatement();
        }
        try {
            PS_load_role.setInt(1, role_id);
            ResultSet rs = PS_load_role.executeQuery();
            while (rs.next()) {
                role = new Role(role_id, rs.getString(1), rs.getString(2), rs.getString(3).equalsIgnoreCase("C"), rs.getString(5), rs.getString(6));
                role.sapStarCategoryStep = rs.getInt(4);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("cn.Role.getById FAILED!");
            Log.logException(e);
        }
        return role;
    }

    public static boolean isComposite(String type) {
        boolean isC = false;
        if (!Utils.isEmpty(type)) {
            isC = type.contentEquals("C");
        }
        return isC;
    }

    private static void createLoadRoleStatement() {
        PS_load_role = DB.prepareStatement("SELECT `role`, `description`, `type`, `star_category_step`, `system`, `client` FROM um_role WHERE id = ?;");
    }

    public static String getRolenameFromId(int id) {
        return DB.getOne("SELECT `role` FROM um_role WHERE id = " + id);
    }
}

