/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.Log;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;

public class Memory {
    private static final String MB = "MB";
    private static final long B2MB = 0x100000L;
    public static final long MAXMEMORY = Runtime.getRuntime().maxMemory();
    public static final String MAXMB = Memory.toMB(MAXMEMORY);
    public static long maxUsed = 0L;
    private static final double excelCompare = 2.68435456E9;

    public static boolean ok4Analysis() {
        if ((double)Memory.freeBytes() < 2.68435456E9) {
            long free = Memory.freeMB();
            System.gc();
            long diff = Memory.freeMB() - free;
            Log.log(Memory.statement("Memory.ok4Analysis() GC freed " + diff + " MB."));
            if (diff < 900L || (double)Memory.freeBytes() < 2.68435456E9) {
                Log.log(Memory.statement("Memory.ok4Analysis() Did not gain enough to continue. Returning FALSE."));
                return false;
            }
        }
        return true;
    }

    public static boolean ok() {
        return Memory.freeBytes() > 0x10000000L;
    }

    public static long freeBytes() {
        Runtime c = Runtime.getRuntime();
        long free = MAXMEMORY - c.totalMemory() + c.freeMemory();
        long used = MAXMEMORY - free;
        if (used > maxUsed) {
            maxUsed = used;
        }
        return free;
    }

    public static long freeMB() {
        return Memory.freeBytes() / 0x100000L;
    }

    public static String statement(String msg) {
        Runtime c = Runtime.getRuntime();
        long free = MAXMEMORY - c.totalMemory() + c.freeMemory();
        long used = MAXMEMORY - free;
        if (used > maxUsed) {
            maxUsed = used;
        }
        return "Initialized memory:\t" + Memory.toMB(c.totalMemory()) + " of max: " + MAXMB + "\tused:\t" + Memory.toMB(used) + "\tleaving:\t" + Memory.toMB(free) + ".\t" + msg;
    }

    public static void garbageCollector() {
        long start = System.nanoTime();
        long before = MAXMEMORY - (MAXMEMORY - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory());
        Runtime.getRuntime().gc();
        long freed = before - (MAXMEMORY - (MAXMEMORY - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()));
        Log.log(Memory.statement("Garbage collector freed " + Memory.toMB(freed) + " of memory in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " ms."));
    }

    public static String toMB(long bytes) {
        return bytes / 0x100000L + MB;
    }

    public static String bytesToShortText(long numberOfBytes) {
        long a = numberOfBytes;
        if (a < 1024L) {
            return a + "B";
        }
        a = Math.floorDiv(numberOfBytes, 1024);
        if (a < 1024L) {
            return a + "K";
        }
        a = Math.floorDiv(numberOfBytes, 0x100000);
        if (a < 1024L) {
            return a + "M";
        }
        a = Math.floorDiv(numberOfBytes, 0x40000000);
        if (a < 1024L) {
            return a + "G";
        }
        a = Math.floorDiv(numberOfBytes, 0);
        return a + "T";
    }

    public static long toBytes(String text) {
        text = text.trim();
        char type = text.charAt(text.length() - 1);
        long number = Long.parseLong(text.substring(0, text.length() - 1));
        switch (type) {
            case 'T': {
                return number * 1024L * 1024L * 1024L * 1024L;
            }
            case 'G': {
                return number * 1024L * 1024L * 1024L;
            }
            case 'M': {
                return number * 1024L * 1024L;
            }
            case 'K': {
                return number * 1024L;
            }
        }
        return 0L;
    }

    public static long getAvailableSystemMemory() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Memory.getSystemMemoryWindows();
        }
        return Memory.getSystemMemoryLinux();
    }

    private static long getSystemMemoryWindows() {
        long freeMemoryBytes = -1L;
        try {
            Process process = Runtime.getRuntime().exec("wmic OS get FreePhysicalMemory /Value");
            Scanner scanner = new Scanner(process.getInputStream());
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.contains("FreePhysicalMemory")) continue;
                Log.log("cn.Memory getSystemMemoryWindows " + line);
                String[] parts = line.split("=");
                freeMemoryBytes = Long.parseLong(parts[1].trim());
                freeMemoryBytes *= 1024L;
            }
            scanner.close();
        }
        catch (Exception e) {
            Log.log("cn.Memory getSystemMemoryWindows FAILED!");
            Log.logException(e);
        }
        return freeMemoryBytes;
    }

    private static long getSystemMemoryLinux() {
        long freeMemoryBytes = -1L;
        try {
            Process process = Runtime.getRuntime().exec("cat /proc/meminfo");
            Scanner scanner = new Scanner(process.getInputStream());
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.startsWith("MemAvailable:")) continue;
                Log.log("cn.Memory getSystemMemoryLinux " + line);
                String[] parts = line.split("\\s+");
                long availableMemoryKb = Long.parseLong(parts[1]);
                freeMemoryBytes = availableMemoryKb * 1024L;
            }
            scanner.close();
        }
        catch (Exception e) {
            Log.log("cn.Memory getSystemMemoryLinux FAILED!");
            Log.logException(e);
        }
        return freeMemoryBytes;
    }
}

