/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.Config;
import cn.Memory;
import cn.Utils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.concurrent.TimeUnit;

public class Log {
    public static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("YYYY-MM-dd");
    public static final SimpleDateFormat fullFormat = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
    private static final String DEBUG = "[DEBUG] ";
    private static Log CURRENT_LOG = null;
    private final String filename;
    private final long startTime = System.currentTimeMillis();
    private final long startNano = System.nanoTime();
    private long spentTime = 0L;
    private final Path path;

    private Log(String filename) {
        this.filename = filename;
        this.path = Paths.get(filename, new String[0]);
        try {
            File myObj = new File(this.filename);
            if (myObj.createNewFile()) {
                System.out.println("File created: " + myObj.getName());
            } else {
                System.out.println("File '" + this.filename + "' already exists.");
            }
        }
        catch (Exception e) {
            System.out.println("An error occurred while creating logfile '" + this.filename + "'.");
            e.printStackTrace();
        }
    }

    public static void createLog(String filename) {
        CURRENT_LOG = new Log(filename);
        Log.log(Memory.statement(fullFormat.format(Log.CURRENT_LOG.startTime) + " Java log startet. JVM pid: " + ProcessHandle.current().pid()));
    }

    public static void createStandardLog() {
        long systemtime = System.currentTimeMillis();
        String date = dateFormat.format(systemtime);
        String filename = Config.getLogPath() + "CN_processes_" + Config.getRemoteUser() + "_" + date + ".log";
        CURRENT_LOG = new Log(filename);
        Log.log(fullFormat.format(Log.CURRENT_LOG.startTime) + " Java log attached");
    }

    public static synchronized void log(String entry) {
        if (entry != null) {
            if (CURRENT_LOG == null) {
                Log.createStandardLog();
            }
            long loggingTime = System.nanoTime();
            String logEntry = timeFormat.format(TimeUnit.NANOSECONDS.toMillis(loggingTime - Log.CURRENT_LOG.startNano)) + "\t" + entry + "\n";
            try {
                Files.write(Log.CURRENT_LOG.path, logEntry.getBytes(), StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                System.out.println("Failed to write to log file " + Log.CURRENT_LOG.filename + "\n" + logEntry);
            }
            Log.CURRENT_LOG.spentTime += System.nanoTime() - loggingTime;
        } else {
            Log.log("NULL entry recieved by log.");
        }
    }

    public static synchronized void debug(String entry) {
        if (Config.isDebugLogOn()) {
            Log.log(DEBUG + entry);
        }
    }

    public static boolean isDebug() {
        return Config.isDebugLogOn();
    }

    public static void close() {
        if (CURRENT_LOG != null) {
            Log.log("");
            Log.log("Time spent logging : " + TimeUnit.NANOSECONDS.toMillis(Log.CURRENT_LOG.spentTime) + " ms.");
            Log.log(Memory.statement("Higest registrered memory use " + Memory.toMB(Memory.maxUsed) + " of " + Memory.toMB(Memory.MAXMEMORY)));
            long currentTime = System.currentTimeMillis();
            long open = (currentTime - Log.CURRENT_LOG.startTime) / 1000L;
            long nopen = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Log.CURRENT_LOG.startNano) / 1000L;
            Log.log(fullFormat.format(currentTime) + " Java log closing after having been open for " + open + " / " + nopen + " seconds.\n\n");
            CURRENT_LOG = null;
        }
    }

    public static void logException(Exception e) {
        Log.log(e.getMessage());
        StackTraceElement[] stackTraces = e.getStackTrace();
        StringBuilder exceptionText = new StringBuilder("");
        for (StackTraceElement stackTrace : stackTraces) {
            exceptionText.append(stackTrace.toString());
            exceptionText.append("\n");
        }
        Log.log(exceptionText.toString());
    }

    public static String getFilename() {
        return Utils.rtrim(Log.CURRENT_LOG.filename, ".log");
    }
}

