/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.Config;

public class Language {
    private static final String ENGLISH = "en";
    private static final String DANSK = "da";
    private static final String DEUTSCH = "de";
    private static final String FRANCAIS = "fr";
    private static final String T\u00c3\u0153RKCE = "tr";
    public final String title;
    public final String isoString;

    private Language(String title, String code) {
        this.title = title;
        this.isoString = code.toLowerCase();
    }

    public static Language[] getAvailableLanguages() {
        Language[] languages = new Language[5];
        languages[0] = new Language("Dansk", DANSK);
        languages[1] = new Language("Deutsch", DEUTSCH);
        languages[4] = new Language("English", ENGLISH);
        languages[2] = new Language("Fran\u00e7ais", FRANCAIS);
        languages[3] = new Language("T\u00fcrkce", T\u00c3\u0153RKCE);
        return languages;
    }

    public static boolean isLanguageAvailable(String languageISOcode) {
        if (languageISOcode != null) {
            for (Language language : Language.getAvailableLanguages()) {
                if (!language.isoString.equalsIgnoreCase(languageISOcode)) continue;
                return true;
            }
        }
        return false;
    }

    public static Language getLanguage(String languageISO) {
        Language chosen = null;
        if (!Language.isLanguageAvailable(languageISO)) {
            languageISO = Config.getFallbackLanguageISO();
        }
        for (Language language : Language.getAvailableLanguages()) {
            if (!language.isoString.equalsIgnoreCase(languageISO)) continue;
            chosen = language;
        }
        return chosen;
    }

    public static Language getFallbackLanguage() {
        return Language.getLanguage(Config.getFallbackLanguageISO());
    }
}

