/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.Log;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.commons.lang3.ArrayUtils;

public class Frequency {
    public static final int DAILY = 0;
    public static final int WEEKLY = 1;
    public static final int FORTNIGHT = 2;
    public static final int MONTHLY = 3;
    public static final int QUARTERLY = 4;
    public static final int SEMIANNUAL = 5;
    public static final int YEARLY = 6;
    public static final int NEVER = 9;
    public static final int DEFAULT = 10;
    private static final int[] allFrequencies = new int[]{0, 1, 2, 3, 4, 5, 6, 9};
    private static final Frequency[] CURRENT_INSTANCES = new Frequency[allFrequencies.length];
    private int frequency;
    private Date timePeriodStart = null;
    private Date timePeriodEnd = null;

    public static Frequency getFrequency(int frequency_int) {
        int frequency;
        int n = frequency = ArrayUtils.contains((int[])allFrequencies, (int)frequency_int) ? frequency_int : 10;
        if (CURRENT_INSTANCES[frequency] == null) {
            Frequency.CURRENT_INSTANCES[frequency] = new Frequency(frequency);
        }
        return CURRENT_INSTANCES[frequency];
    }

    public static boolean isOverdue(Date lastDate, int frequency_int) {
        return Frequency.getFrequency(frequency_int).isOverdue(lastDate);
    }

    public Frequency(int frequency) {
        this.frequency = ArrayUtils.contains((int[])allFrequencies, (int)frequency) ? frequency : 10;
    }

    public boolean isOverdue(Date thisDate) {
        if (this.frequency == 9) {
            return false;
        }
        if (this.frequency == 10) {
            Log.log("Frequency DEFAULT should never be asked if overdue, but should already have been converted to actual value. Returning FALSE.");
            return false;
        }
        if (thisDate == null) {
            return true;
        }
        Calendar last = Calendar.getInstance();
        last.setTimeInMillis(thisDate.getTime());
        last.set(11, 0);
        last.set(12, 1);
        last.set(13, 1);
        switch (this.frequency) {
            case 0: {
                last.add(5, 1);
                break;
            }
            case 1: {
                last.add(5, 7);
                last.set(7, 2);
                break;
            }
            case 2: {
                last.add(5, 14);
                last.set(7, 2);
                break;
            }
            case 3: {
                last.add(2, 1);
                last.set(5, 1);
                break;
            }
            case 4: {
                last.add(2, 3);
                last.set(5, 1);
                switch (last.get(2)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        last.set(2, 0);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        last.set(2, 3);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        last.set(2, 6);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        last.set(2, 9);
                    }
                }
                break;
            }
            case 5: {
                last.add(2, 6);
                last.set(5, 1);
                if (last.get(2) >= 6) {
                    last.set(2, 6);
                    break;
                }
                last.set(2, 0);
                break;
            }
            case 6: {
                last.add(1, 1);
                last.set(2, 0);
                last.set(5, 1);
            }
        }
        Calendar today = Calendar.getInstance();
        today.set(11, 0);
        today.set(12, 1);
        today.set(13, 1);
        long diff = today.getTimeInMillis() - last.getTimeInMillis();
        Log.log("Frequency " + Frequency.getFrequencyAsText(this.frequency) + "\nDiff between " + Timestamp.from(today.toInstant()).toString() + " >= " + Timestamp.from(last.toInstant()).toString() + (diff >= 0L ? "TRUE" : "FALSE") + "\n" + today.getTimeInMillis() + " >= " + last.getTimeInMillis() + " is " + diff + "\t overdue = " + (diff >= 0L ? "TRUE" : "FALSE"));
        return today.getTimeInMillis() >= last.getTimeInMillis();
    }

    public Date getPeriodStart() {
        return this.timePeriodStart == null ? Date.valueOf("0001-01-01") : this.timePeriodStart;
    }

    public Date getPeriodEnd() {
        return this.timePeriodEnd == null ? Date.valueOf("0001-01-01") : this.timePeriodEnd;
    }

    public void findTimePeriod(Date lastDate) {
        Calendar date = Calendar.getInstance();
        Calendar last = Calendar.getInstance();
        last.setTime(lastDate);
        switch (this.frequency) {
            case 9: {
                this.timePeriodStart = Date.valueOf("0001-01-01");
                this.timePeriodEnd = Date.valueOf("0001-01-01");
                break;
            }
            case 0: {
                this.timePeriodStart = lastDate;
                this.timePeriodEnd = new Date(date.getTimeInMillis());
                break;
            }
            case 1: {
                date.add(5, -7);
                date.set(7, 2);
                this.timePeriodStart = new Date(date.getTimeInMillis()).compareTo(lastDate) > 0 ? (Date)lastDate.clone() : new Date(date.getTimeInMillis());
                date.add(5, 6);
                this.timePeriodEnd = new Date(date.getTimeInMillis());
                break;
            }
            case 2: {
                date.add(5, -14);
                date.set(7, 2);
                this.timePeriodStart = new Date(date.getTimeInMillis()).compareTo(lastDate) > 0 ? (Date)lastDate.clone() : new Date(date.getTimeInMillis());
                date.add(5, 13);
                this.timePeriodEnd = new Date(date.getTimeInMillis());
                break;
            }
            case 3: {
                date.add(2, -1);
                date.set(5, 1);
                this.timePeriodStart = new Date(date.getTimeInMillis()).compareTo(lastDate) > 0 ? (Date)lastDate.clone() : new Date(date.getTimeInMillis());
                date.set(5, date.getActualMaximum(5));
                this.timePeriodEnd = new Date(date.getTimeInMillis());
                break;
            }
            case 4: {
                date.add(2, -3);
                date.set(5, 1);
                switch (date.get(2)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        date.set(2, 0);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        date.set(2, 3);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        date.set(2, 6);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        date.set(2, 9);
                    }
                }
                this.timePeriodStart = new Date(date.getTimeInMillis()).compareTo(lastDate) > 0 ? (Date)lastDate.clone() : new Date(date.getTimeInMillis());
                date.add(2, 2);
                date.set(5, date.getActualMaximum(5));
                this.timePeriodEnd = new Date(date.getTimeInMillis());
                break;
            }
            case 5: {
                date.add(5, -6);
                date.set(5, 1);
                if (date.get(2) >= 6) {
                    date.set(2, 6);
                } else {
                    date.set(2, 0);
                }
                this.timePeriodStart = new Date(date.getTimeInMillis()).compareTo(lastDate) > 0 ? (Date)lastDate.clone() : new Date(date.getTimeInMillis());
                date.add(2, 5);
                date.set(5, date.getActualMaximum(5));
                this.timePeriodEnd = new Date(date.getTimeInMillis());
                break;
            }
            case 6: {
                last.add(1, -1);
                last.set(2, 0);
                last.set(5, 1);
                this.timePeriodStart = new Date(date.getTimeInMillis()).compareTo(lastDate) > 0 ? (Date)lastDate.clone() : new Date(date.getTimeInMillis());
                date.add(2, 11);
                date.set(5, date.getActualMaximum(5));
                this.timePeriodEnd = new Date(date.getTimeInMillis());
            }
        }
    }

    public static String getFrequencyAsText(int frequency) {
        switch (frequency) {
            case 0: {
                return "Daily";
            }
            case 1: {
                return "Weekly";
            }
            case 2: {
                return "Fortnight";
            }
            case 3: {
                return "Monthly";
            }
            case 4: {
                return "Quarterly";
            }
            case 5: {
                return "Semi-annual";
            }
            case 6: {
                return "Yearly";
            }
            case 9: {
                return "Never";
            }
            case 10: {
                return "Default";
            }
        }
        return frequency + " is not a valid Frequency value";
    }

    public String toString() {
        switch (this.frequency) {
            case 0: {
                return "Daily";
            }
            case 1: {
                return "Weekly";
            }
            case 2: {
                return "Fortnight";
            }
            case 3: {
                return "Monthly";
            }
            case 4: {
                return "Quarterly";
            }
            case 5: {
                return "Semi-annual";
            }
            case 6: {
                return "Yearly";
            }
            case 9: {
                return "Never";
            }
            case 10: {
                return "Default";
            }
        }
        return this.frequency + " is not a valid Frequency value";
    }

    public int getIntegerValue() {
        return this.frequency;
    }
}

