/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.Config;
import cn.DB;
import cn.Log;
import cn.Utils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class Email {
    private String from;
    private InternetAddress[] to = null;
    private InternetAddress[] cc = null;
    private InternetAddress[] bcc = null;
    private String subject;
    private String body;
    private ArrayList<String> attachments = new ArrayList();
    private static final String nagarro_Green = "#47D7AC";
    private static String AC_Email = null;

    public Email(String from, String to, String cc, String bcc, String subject, String body) {
        this.from = from;
        this.to = Email.convertEmailString(to);
        this.cc = Email.convertEmailString(cc);
        this.bcc = Email.convertEmailString(bcc);
        this.subject = subject;
        Calendar cal = Calendar.getInstance();
        String timestamp = new Timestamp(cal.getTime().getTime()).toString();
        this.body = body + "<br /><br /><span style='font-size: 8px; font-style: italic; color:#47D7AC;'> " + timestamp + " (" + cal.getTimeZone().getDisplayName() + ")</span>";
    }

    public Email(String from, InternetAddress[] receiverEmails, String subject, String body) {
        this.from = from;
        this.to = receiverEmails;
        this.subject = subject;
        Calendar cal = Calendar.getInstance();
        String timestamp = new Timestamp(cal.getTime().getTime()).toString();
        this.body = body + "<br /><br /><span style='font-size: 8px; font-style: italic; color:#47D7AC;'> " + timestamp + " (" + cal.getTimeZone().getDisplayName() + ")</span>";
    }

    public void attachFile(String filename) {
        Log.log("Email attachFile adding '" + filename + "'");
        this.attachments.add(filename);
    }

    public boolean send() {
        Properties props = Config.getMailProperties();
        Session session = Session.getDefaultInstance((Properties)props);
        MimeMessage message = new MimeMessage(session);
        MimeMultipart multipart = new MimeMultipart("mixed");
        MimeBodyPart messageTextPart = new MimeBodyPart();
        try {
            message.setFrom((Address)new InternetAddress(this.from));
            if (this.to != null) {
                message.setRecipients(Message.RecipientType.TO, (Address[])this.to);
            }
            if (this.cc != null) {
                message.setRecipients(Message.RecipientType.CC, (Address[])this.cc);
            }
            if (this.bcc != null) {
                message.setRecipients(Message.RecipientType.BCC, (Address[])this.bcc);
            }
            try {
                message.setSubject(MimeUtility.encodeText((String)this.subject, (String)"UTF-8", (String)"B"));
            }
            catch (UnsupportedEncodingException e) {
                Log.log("Email Failed to encode subject.");
                Log.logException(e);
                return false;
            }
            messageTextPart.setContent((Object)this.body, "text/html; charset=utf-8");
            multipart.addBodyPart((BodyPart)messageTextPart);
        }
        catch (Exception e) {
            Log.log("Email Failed set recipients.");
            Log.log("from " + this.from);
            Log.log("to   " + this.to);
            Log.log("cc   " + this.cc);
            Log.log("bcc  " + this.bcc);
            Log.logException(e);
            return false;
        }
        if (this.attachments.size() > 0) {
            for (String filename : this.attachments) {
                try {
                    Log.log("Adding to email '" + filename + "'");
                    MimeBodyPart attachmentPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(filename);
                    attachmentPart.setDataHandler(new DataHandler((DataSource)source));
                    attachmentPart.setFileName(new File(filename).getName());
                    multipart.addBodyPart((BodyPart)attachmentPart);
                }
                catch (Exception e) {
                    Log.log("Email Failed to attach file " + filename);
                    Log.logException(e);
                    return false;
                }
            }
        }
        try {
            message.setContent((Multipart)multipart);
            Log.log("Succesfully set email content to " + this.to.toString());
        }
        catch (MessagingException e) {
            Log.log("Email Failed set content.");
            Log.logException((Exception)((Object)e));
            return false;
        }
        Log.log("Transport params: host '" + Config.getMailHost() + "' user '" + Config.getMailUsername() + "' pswd " + Config.getMailPassword());
        try {
            Transport transport = session.getTransport();
            transport.connect(Config.getMailHost(), Config.getMailUsername(), Config.getMailPassword());
            transport.sendMessage((Message)message, message.getAllRecipients());
            Log.log("Sent message successfully.");
            return true;
        }
        catch (Exception e) {
            Log.log("Email Failed to send email.");
            Log.logException(e);
            return false;
        }
    }

    public static InternetAddress[] convertEmailString(String emailString) {
        InternetAddress[] emails = null;
        if (!Utils.isEmpty(emailString)) {
            String newFormat = emailString.replaceAll(";", ",");
            try {
                emails = InternetAddress.parse((String)newFormat);
            }
            catch (AddressException e) {
                Log.log("Email convertEmailString failed to parse '" + newFormat + "'");
                Log.logException((Exception)((Object)e));
            }
        }
        return emails;
    }

    public static InternetAddress[] convertEmailList(String[] emailStrings) {
        InternetAddress[] emails = null;
        if (!Utils.isEmpty(emailStrings)) {
            ArrayList<String> validEmails = new ArrayList<String>();
            for (String emailString : emailStrings) {
                if (!Email.isValidEmail(emailString)) continue;
                validEmails.add(emailString);
            }
            if (validEmails.size() > 0) {
                String addresses = String.join((CharSequence)",", validEmails.toArray(Utils.EMPTYSTRINGARRAY));
                try {
                    emails = InternetAddress.parse((String)addresses);
                }
                catch (AddressException e) {
                    Log.log("Email convertEmailString failed to parse '" + addresses + "'");
                    Log.logException((Exception)((Object)e));
                }
            }
        }
        return emails;
    }

    public static boolean isValidEmail(String emailAddress) {
        try {
            InternetAddress emailAddr = new InternetAddress(emailAddress);
            emailAddr.validate();
        }
        catch (Exception e) {
            Log.log("Email '" + emailAddress + "' is not a valid email.");
            return false;
        }
        return true;
    }

    public static String[] isValidEmails(String[] emailArray) {
        ArrayList<String> validArray = new ArrayList<String>();
        for (String email : emailArray) {
            if (!Email.isValidEmail(email)) continue;
            validArray.add(email);
        }
        return validArray.toArray(Utils.EMPTYSTRINGARRAY);
    }

    public static String getFromAC(String system, String client) {
        if (AC_Email == null) {
            PreparedStatement ps = DB.prepareStatement("SELECT workflow_notifications_email FROM settings_sod WHERE `system` = ? AND `client` = ? ;");
            try {
                ps.setString(1, system);
                ps.setString(2, client);
                AC_Email = DB.preparedStatementGetOne(ps);
            }
            catch (Exception e) {
                Log.log("cn.Email FAILED trying to load workflow_notifications_email from settings_sod " + system + "/" + client);
                Log.logException(e);
            }
        }
        return AC_Email;
    }
}

