/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.Config;
import cn.Log;
import cn.Memory;
import cn.Utils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;

public class DB {
    private static Connection[] multiConnections = null;
    private static int multiConnectionIndex = -1;
    private static Connection connection = null;
    private static ResultSet resultSet = null;
    private static PreparedStatement PS_getRowCount = null;
    private static boolean dbTxActive = false;
    private static boolean dbTxErrOccurred = false;
    private static Savepoint dbTxSavepoint = null;

    public static ResultSet getData(String sqlStatement) {
        try {
            Statement st = DB.getDB().createStatement(1004, 1008);
            resultSet = st.executeQuery(sqlStatement);
        }
        catch (Exception e) {
            Log.log("Failed statement: " + sqlStatement);
            Log.logException(e);
        }
        return resultSet;
    }

    public static String getOne(String sqlStatement) {
        String s = null;
        try {
            ResultSet rs = DB.getData(sqlStatement);
            if (rs.next()) {
                s = rs.getString(1);
            }
        }
        catch (Exception e) {
            Log.log("Failed getOne statement: " + sqlStatement);
            Log.logException(e);
        }
        return s;
    }

    public static int getOneInt(String sqlStatement) {
        int s = -1;
        try {
            ResultSet rs = DB.getData(sqlStatement);
            if (rs.next()) {
                s = rs.getInt(1);
            }
        }
        catch (Exception e) {
            Log.log("Failed getCount statement: " + sqlStatement);
            Log.logException(e);
        }
        return s;
    }

    public static Date getDate(String sqlStatement) {
        Date date = null;
        try {
            ResultSet rs = DB.getData(sqlStatement);
            if (rs.next()) {
                date = rs.getDate(1);
            }
        }
        catch (Exception e) {
            Log.log("Failed getDate statement: " + sqlStatement);
            Log.logException(e);
        }
        return date;
    }

    public static int[] getOneNumberColumn(String sqlStatement) {
        try {
            ResultSet rs = DB.getData(sqlStatement);
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            while (rs.next()) {
                numbers.add(rs.getInt(1));
            }
            rs.close();
            return Utils.integerListToIntArray(numbers);
        }
        catch (Exception e) {
            Log.log("Failed statement: " + sqlStatement);
            Log.logException(e);
            return new int[0];
        }
    }

    public static String[] getOneTextColumn(String sqlStatement) {
        ArrayList<String> texts = new ArrayList<String>();
        try {
            ResultSet rs = DB.getData(sqlStatement);
            while (rs.next()) {
                texts.add(rs.getString(1));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("Failed statement (getOneTextColumn): " + sqlStatement);
            Log.logException(e);
        }
        return texts.toArray(Utils.EMPTYSTRINGARRAY);
    }

    public static int update(String sqlStatement) {
        try {
            int affectedRows = DB.getDB().createStatement().executeUpdate(sqlStatement);
            return affectedRows;
        }
        catch (Exception e) {
            Log.log("Failed statement: " + sqlStatement);
            Log.logException(e);
            if (dbTxActive) {
                dbTxErrOccurred = true;
                Log.log("Error occurred during transaction. Rollback will be initiated during commit.");
            }
            return -1;
        }
    }

    public static PreparedStatement prepareStatement(String sql) {
        PreparedStatement ps = null;
        try {
            ps = DB.getDB().prepareStatement(sql, 1004, 1007);
            Log.debug("Prepared statement:\n" + sql);
        }
        catch (Exception e) {
            Log.log("Failed as preparing statement:\n" + sql);
            Log.logException(e);
        }
        return ps;
    }

    public static PreparedStatement prepareStatementSilent(String sql) {
        PreparedStatement ps = null;
        try {
            ps = DB.getDB().prepareStatement(sql, 1003, 1007);
        }
        catch (Exception e) {
            Log.log("Failed as preparing statement:\n" + sql);
            Log.logException(e);
        }
        return ps;
    }

    public static PreparedStatement prepareStatementOnConnection(Connection conn, String sql) {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql, 1003, 1007);
            Log.debug("Prepared statement on separate connection: \n" + sql);
        }
        catch (Exception e) {
            Log.log("Failed as preparing statement to specific connection:\n" + sql);
            Log.logException(e);
        }
        return ps;
    }

    public static PreparedStatement prepareStatementInsert(String sql) {
        PreparedStatement ps = null;
        try {
            ps = DB.getDB().prepareStatement(sql, 1);
        }
        catch (Exception e) {
            Log.log("Failed as preparing insert statement.\nstatement: " + sql);
            Log.logException(e);
        }
        return ps;
    }

    public static int preparedStatementGetCount(PreparedStatement preparedStatement) {
        int i = -1;
        try {
            ResultSet rs = preparedStatement.executeQuery();
            if (rs.next()) {
                i = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("Failed prepared statement preparedStatementGetCount.");
            Log.logException(e);
        }
        return i;
    }

    public static String preparedStatementGetOne(PreparedStatement preparedStatement) {
        String s = "";
        try {
            ResultSet rs = preparedStatement.executeQuery();
            if (rs.next()) {
                s = rs.getString(1);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("Failed prepared statement preparedStatementGetOne.");
            Log.logException(e);
        }
        return s;
    }

    public static Date preparedStatementGetDate(PreparedStatement preparedStatement) {
        Date d = null;
        try {
            ResultSet rs = preparedStatement.executeQuery();
            if (rs.next()) {
                d = rs.getDate(1);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("Failed prepared statement preparedStatementGetDate.");
            Log.logException(e);
        }
        return d;
    }

    public static String[] preparedStatementGetOneTextColumn(PreparedStatement preparedStatement) {
        ArrayList<String> data = new ArrayList<String>();
        try {
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                data.add(rs.getString(1));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("Failed prepared statement preparedStatementGetOneTextColumn.");
            Log.logException(e);
        }
        return data.toArray(Utils.EMPTYSTRINGARRAY);
    }

    public static int[] preparedStatementGetOneIntColumn(PreparedStatement preparedStatement) {
        ArrayList<Integer> data = new ArrayList<Integer>();
        try {
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                data.add(rs.getInt(1));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("Failed prepared statement preparedStatementGetOneIntColumn.");
            Log.logException(e);
        }
        return Utils.integerListToIntArray(data);
    }

    public static boolean isTable(String tablename) {
        ResultSet rs = DB.getData("SHOW TABLES LIKE '" + tablename + "';");
        try {
            return rs.next();
        }
        catch (Exception e) {
            Log.log("DB isTable failed on '" + tablename + "'");
            Log.logException(e);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Connection getNewConnection() {
        if (multiConnections == null) {
            multiConnections = new Connection[Config.getDBThreadPoolSize()];
        }
        if (++multiConnectionIndex >= multiConnections.length) {
            multiConnectionIndex = 0;
            Log.debug("DB connections resetting the connection pool " + multiConnections.length);
        }
        if (multiConnections[multiConnectionIndex] == null) {
            DB.multiConnections[DB.multiConnectionIndex] = DB.connect();
            Log.debug(Memory.statement("DB created connection ID " + multiConnectionIndex));
            try {
                multiConnections[multiConnectionIndex].setAutoCommit(false);
                if (multiConnections[multiConnectionIndex].isValid(30)) {
                    return multiConnections[multiConnectionIndex];
                }
                if (multiConnections[multiConnectionIndex].isClosed()) {
                    DB.multiConnections[DB.multiConnectionIndex] = DB.connect();
                    return multiConnections[multiConnectionIndex];
                }
                if (multiConnections[multiConnectionIndex].isValid(30)) return multiConnections[multiConnectionIndex];
                DB.multiConnections[DB.multiConnectionIndex] = DB.connect();
                return multiConnections[multiConnectionIndex];
            }
            catch (Exception e) {
                Log.log("cn.DB.getNewConnection() FAILED to get a valid connection. Will retry in a second.");
                Log.logException(e);
                try {
                    Thread.sleep(1000L);
                    return DB.getNewConnection();
                }
                catch (Exception e2) {
                    Log.log("cn.DB.getNewConnection() FAILED to wait before retrying.");
                    Log.logException(e2);
                }
                return DB.getNewConnection();
            }
        }
        Log.log(Memory.statement("DB recycling connection ID " + multiConnectionIndex));
        return multiConnections[multiConnectionIndex];
    }

    public static Connection getDB() {
        if (connection == null) {
            connection = DB.connect();
        } else {
            try {
                if (connection.isValid(30)) {
                    return connection;
                }
                if (connection.isClosed()) {
                    connection = DB.connect();
                } else if (!connection.isValid(30)) {
                    connection = DB.connect();
                }
            }
            catch (Exception e) {
                Log.log("cn.DB getDB() reconnecting af closed FAILED");
                Log.logException(e);
            }
        }
        return connection;
    }

    private static Connection connect() {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(Config.getDBurl(), Config.getDBproperties());
        }
        catch (Exception e) {
            Log.log("Getting DB connection failed!\n" + Config.getDBstring());
            Log.logException(e);
            e.printStackTrace();
            System.exit(1);
        }
        return conn;
    }

    public static void close() {
        try {
            if (connection != null) {
                connection.close();
            }
            if (multiConnections != null) {
                for (Connection c : multiConnections) {
                    if (c == null) continue;
                    c.close();
                }
            }
        }
        catch (Exception e) {
            Log.log("DB class failed while closing connection.");
            Log.logException(e);
            System.exit(1);
        }
    }

    public static int getRowCount() {
        if (PS_getRowCount == null) {
            PS_getRowCount = DB.prepareStatement("SELECT found_rows() AS t;");
        }
        return DB.preparedStatementGetCount(PS_getRowCount);
    }

    public static int resultSetGetSize(ResultSet rs) {
        int numberOfRows = 0;
        try {
            int pointer = rs.getRow();
            if (rs.last()) {
                numberOfRows = rs.getRow();
                rs.absolute(pointer);
            } else {
                Log.log("DB trying to get size of empty resultset.");
            }
        }
        catch (Exception e) {
            Log.log("DB class failed while trying to get result size.");
            Log.log(e.getMessage());
        }
        return numberOfRows;
    }

    public static void clearTempTable(String guiid, String tablename) {
        DB.update("DELETE FROM `" + tablename + "` WHERE guiid='" + guiid + "' OR guiid IN (\tSELECT guiid FROM temp_mgr \tWHERE `table`='" + tablename + "' AND timestamp < TIMESTAMPADD(DAY, -1, NOW()));");
        DB.update("DELETE FROM temp_mgr WHERE `table`='" + tablename + "' AND (guiid='" + guiid + "' OR timestamp < TIMESTAMPADD(DAY, -1, NOW()));");
    }

    public static void resetAutoIncrement(String tablename, String id_property) {
        String id = Utils.isEmpty(id_property) ? "id" : id_property;
        int autoValue = DB.getOneInt("SELECT MAX(`" + id + "`) FROM `" + tablename + "`;");
        DB.update("ALTER TABLE `" + tablename + "` AUTO_INCREMENT = " + ++autoValue + ";");
        Log.log("resetAutoIncrement sat " + tablename + " auto_increment value to " + autoValue);
    }

    public static void transactionStart() {
        Connection c = DB.getDB();
        if (dbTxActive) {
            Log.log("Invalid state for DB_TX_START. Transaction already active.");
        } else {
            dbTxActive = true;
            dbTxErrOccurred = false;
            try {
                c.setAutoCommit(false);
                dbTxSavepoint = c.setSavepoint();
            }
            catch (Exception e) {
                Log.log("DB failed while starting transaction.");
                Log.logException(e);
            }
        }
    }

    public static boolean transactionCommit() {
        Connection c = DB.getDB();
        if (dbTxActive) {
            dbTxActive = false;
            try {
                if (!dbTxErrOccurred) {
                    c.commit();
                    c.setAutoCommit(true);
                    return true;
                }
                dbTxErrOccurred = false;
                Log.log("Errors occurred during transaction. Rolling back.");
                c.rollback(dbTxSavepoint);
                c.setAutoCommit(true);
                return false;
            }
            catch (Exception e) {
                Log.log("DB transaction failed during commit. Trying to roll back.");
                Log.logException(e);
                try {
                    c.rollback(dbTxSavepoint);
                    c.setAutoCommit(true);
                }
                catch (Exception e1) {
                    Log.log("DB transaction failed during rollback.");
                    Log.logException(e);
                }
                return false;
            }
        }
        Log.log("Invalid state for DB_TX_COMMIT. No active transaction.");
        return false;
    }
}

