/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.Log;
import cn.Memory;
import cn.Utils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.HashMap;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.lang3.SystemUtils;

public class Config {
    private static Config currentConfig = null;
    private String remote_user = null;
    private String dbname;
    private String dbhost;
    private String dbusername;
    private String dbpassword;
    private String dbport;
    private String mailhost;
    private String mailport;
    private String mailauth;
    private String mailusername;
    private String mailpassword;
    private String mailssl;
    private String report_path;
    private String background_log_path;
    private String java_path;
    private String java_xmx;
    private int threadpoolsize;
    private String inifilename;
    private int log_level = 7;
    private String fallbackLanguage = "en";
    private long csvLimit = Memory.toBytes("2G");
    private int dbthreadcount = 3;
    private HashMap<String, Boolean> features = new HashMap();
    private static Properties DBprops = null;
    private static Properties MailProps = null;

    private Config(String remote_user) {
        this.remote_user = remote_user.trim();
    }

    public static String getRemoteUser() {
        return Config.currentConfig.remote_user;
    }

    public static void initialize(String remote_user) {
        currentConfig = new Config(remote_user);
    }

    public static void readConfig(String filename) {
        Config.readIniFile(filename);
    }

    public static long getCSVlimit() {
        return Config.currentConfig.csvLimit;
    }

    static String getLogPath() {
        return Config.currentConfig.background_log_path + File.separator;
    }

    static boolean isDebugLogOn() {
        return Config.currentConfig.log_level >= 7;
    }

    public static String getIniPath() {
        return Config.currentConfig.inifilename;
    }

    public static String getReportPath() {
        return Config.currentConfig.report_path + File.separator;
    }

    public static String getJavaExecutionPath() {
        return Config.currentConfig.java_path + " ";
    }

    public static String getJavaPath() {
        return FileSystems.getDefault().getPath("", new String[0]).toAbsolutePath().toString() + File.separator + "Java" + File.separator;
    }

    public static String getJavaStandardIncludes() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "-cp " + Config.getJavaPath() + "CNS.jar;" + Config.getJavaPath() + "lib" + File.separator + "*;" + Config.getJavaPath() + "lib" + File.separator + "apache" + File.separator + "*";
        }
        return "-cp " + Config.getJavaPath() + "CNS.jar:" + Config.getJavaPath() + "lib" + File.separator + "*:" + Config.getJavaPath() + "lib" + File.separator + "apache" + File.separator + "*";
    }

    public static String getJavaXmx() {
        return Config.currentConfig.java_xmx;
    }

    public static String getJavaXms(long xmx) {
        long bytes = Utils.ceilDivider(xmx, 3);
        return Memory.bytesToShortText(bytes);
    }

    public static int getJavaThreadPoolSize() {
        return Config.currentConfig.threadpoolsize;
    }

    public static int getDBThreadPoolSize() {
        return Config.currentConfig.dbthreadcount;
    }

    public static String getDBstring() {
        String password = Config.currentConfig.dbpassword;
        Log.log(password);
        return "jdbc:mysql://" + Config.currentConfig.dbhost + ":" + Config.currentConfig.dbport + "/" + Config.currentConfig.dbname + "?autoReconnect=true&cmaxReconnets=100&initialTimeout=5&user=" + Config.currentConfig.dbusername + "&password=" + password + "&useServerPrepStmts=true&cachePrepStmts=true";
    }

    public static String getDBurl() {
        return "jdbc:mysql://" + Config.currentConfig.dbhost + ":" + Config.currentConfig.dbport + "/" + Config.currentConfig.dbname + "?autoReconnect=true&cmaxReconnets=100&initialTimeout=5";
    }

    public static Properties getDBproperties() {
        if (DBprops == null) {
            DBprops = new Properties();
            try {
                DBprops.setProperty("user", Config.currentConfig.dbusername);
                DBprops.setProperty("password", Config.currentConfig.dbpassword);
            }
            catch (Exception e) {
                Log.log("cn.Config getDBproperties() FAILED because of dbusername and/or dbpassword");
                Log.logException(e);
                System.exit(1);
            }
            DBprops.setProperty("useServerPrepStmts", "true");
            DBprops.setProperty("cachePrepStmts", "true");
        }
        return DBprops;
    }

    public static Properties getMailProperties() {
        if (MailProps == null) {
            MailProps = new Properties();
            if (Config.currentConfig.mailauth != null && Config.currentConfig.mailssl != null && Config.currentConfig.mailhost != null && Config.currentConfig.mailport != null && Config.currentConfig.mailusername != null && Config.currentConfig.mailpassword != null) {
                MailProps.put("mail.transport.protocol", "smtp");
                MailProps.put("mail.smtp.port", Config.currentConfig.mailport);
                MailProps.put("mail.smtp.starttls.enable", "true");
                MailProps.put("mail.smtp.auth", "true");
            } else {
                Log.log("All properties needed to send mail is not present!!!");
            }
        }
        return MailProps;
    }

    public static String getMailHost() {
        return Config.currentConfig.mailhost;
    }

    public static String getMailUsername() {
        return Config.currentConfig.mailusername;
    }

    public static String getMailPassword() {
        return Config.currentConfig.mailpassword;
    }

    public static String getFallbackLanguageISO() {
        return Config.currentConfig.fallbackLanguage;
    }

    private static void readIniFile(String filename) {
        Config.currentConfig.inifilename = filename;
        String remoteUser = "REMOTE_USER";
        boolean payAttention = false;
        String semi = ";";
        String equal = "=";
        String quote = "\"";
        String single = "'";
        String line = "";
        String[] linecontent = new String[2];
        try {
            String remoteUserSection = "[" + Config.currentConfig.remote_user + "]";
            File f = new File(filename);
            Scanner scanner = new Scanner(f, StandardCharsets.UTF_8);
            while (scanner.hasNextLine()) {
                line = scanner.nextLine().trim();
                int indexOfSemi = line.indexOf(";");
                if (line.length() == 0 || indexOfSemi == 0 || indexOfSemi >= 0 && indexOfSemi < line.indexOf("=")) continue;
                if (line.equalsIgnoreCase("[main]") || line.equalsIgnoreCase(remoteUserSection)) {
                    payAttention = true;
                    continue;
                }
                if (line.contains("[")) {
                    payAttention = false;
                    continue;
                }
                if (!payAttention) continue;
                linecontent = line.split("=");
                if (linecontent.length > 1) {
                    linecontent[0] = linecontent[0].trim();
                    linecontent[1] = linecontent[1].replaceAll("\"", "").replaceAll("'", "").trim();
                    if (linecontent.length > 2) {
                        for (int i = 2; i < linecontent.length; ++i) {
                            linecontent[1] = linecontent[1] + "=" + linecontent[i].replaceAll("\"", "").replaceAll("'", "").trim();
                        }
                    }
                    if (linecontent[1].equalsIgnoreCase("REMOTE_USER")) {
                        linecontent[1] = Config.currentConfig.remote_user;
                    } else if (linecontent[1].indexOf("REMOTE_USER") > -1) {
                        linecontent[1] = linecontent[1].replace("REMOTE_USER", Config.currentConfig.remote_user);
                    }
                }
                if (linecontent[0].contentEquals("resources.db.params.dbname")) {
                    Config.currentConfig.dbname = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.db.host")) {
                    Config.currentConfig.dbhost = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.db.params.host")) {
                    Config.currentConfig.dbhost = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.db.params.port")) {
                    Config.currentConfig.dbport = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.db.params.username")) {
                    Config.currentConfig.dbusername = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.db.params.password")) {
                    Config.currentConfig.dbpassword = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.smtp.host")) {
                    Config.currentConfig.mailhost = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.smtp.params.host")) {
                    Config.currentConfig.mailhost = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.smtp.params.port")) {
                    Config.currentConfig.mailport = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.smtp.params.auth")) {
                    Config.currentConfig.mailauth = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.smtp.params.ssl")) {
                    Config.currentConfig.mailssl = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.smtp.params.username")) {
                    Config.currentConfig.mailusername = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.smtp.params.password")) {
                    Config.currentConfig.mailpassword = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.file.background_log_path")) {
                    Config.currentConfig.background_log_path = linecontent[1];
                    continue;
                }
                if (linecontent[0].equalsIgnoreCase("log.background.level")) {
                    Config.currentConfig.log_level = Integer.parseInt(linecontent[1]);
                    continue;
                }
                if (linecontent[0].contentEquals("resources.file.report_path")) {
                    Config.currentConfig.report_path = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.java.executable")) {
                    Config.currentConfig.java_path = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.java.memory.xmx")) {
                    Config.currentConfig.java_xmx = linecontent[1];
                    continue;
                }
                if (linecontent[0].contentEquals("resources.java.csvlimit")) {
                    Config.currentConfig.csvLimit = Memory.toBytes(linecontent[1]);
                    continue;
                }
                if (linecontent[0].contentEquals("resources.java.dbthreadcount")) {
                    Config.currentConfig.dbthreadcount = Utils.isNumeric(linecontent[1]) ? Utils.toInteger(linecontent[1]) : 6;
                    continue;
                }
                if (linecontent[0].contentEquals("l10n.fallback_language")) {
                    Config.currentConfig.fallbackLanguage = linecontent[1].toLowerCase();
                    continue;
                }
                if (!linecontent[0].startsWith("feature.")) continue;
                Config.currentConfig.features.put(linecontent[0].substring(8, linecontent[0].length()), linecontent[1].equalsIgnoreCase("1"));
            }
            scanner.close();
        }
        catch (Exception e) {
            Log.log("Config file reading crashed at '" + line + "'");
            if (linecontent.length > 1) {
                Log.log("Config file reading crashed reading '" + linecontent[0] + "' and '" + linecontent[1] + "'");
            }
            Log.logException(e);
        }
    }

    public static boolean isFeature(String featurename, boolean defaultValue) {
        if (Config.currentConfig.features.containsKey(featurename)) {
            return Config.currentConfig.features.get(featurename);
        }
        Log.log("Did not find feature '" + featurename + "'. Will be set to " + defaultValue + ". Currently set Features in apm.ini:\n" + String.join((CharSequence)"\n", Config.currentConfig.features.keySet()));
        Config.currentConfig.features.put(featurename, defaultValue);
        return defaultValue;
    }
}

