/*
 * Decompiled with CFR 0.152.
 */
package cn;

import cn.Config;
import cn.Log;
import java.util.HashMap;
import java.util.Map;

public class Arguments {
    private Map<String, String> properties = new HashMap<String, String>();

    public String get(String property) {
        if (this.properties.containsKey(property)) {
            return this.properties.get(property);
        }
        return null;
    }

    public int getInt(String property) {
        if (this.properties.containsKey(property)) {
            return Integer.parseInt(this.properties.get(property));
        }
        return 0;
    }

    public static Arguments handle(String[] args) {
        Arguments current = new Arguments();
        for (String arg : args) {
            String[] array = arg.trim().split("=");
            if (array.length < 2) continue;
            String property = array[0].trim();
            String value = array[1].trim();
            if (property.length() <= 0 || value.length() <= 0) continue;
            current.properties.putIfAbsent(property, value);
        }
        current.doStandards();
        return current;
    }

    private void doStandards() {
        String property = this.properties.get("user");
        if (property != null) {
            Config.initialize(property);
        }
        if ((property = this.properties.get("logfile")) != null) {
            Log.createLog(property);
        }
        if ((property = this.properties.get("inifile")) != null) {
            Config.readConfig(property);
        }
    }

    public void printString() {
        this.properties.forEach((key, value) -> System.out.println(key + ":\t" + value + "\n"));
    }
}

