/*
 * Decompiled with CFR 0.152.
 */
package apm.report;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.TaskParameters;
import cn.Translator;
import cn.report.ReportStarter;
import cn.report.Spreadsheet;
import cn.task.Task;

public class Report {
    private Task task;
    private TaskParameters params;
    private Translator translator;
    private String projects;
    private boolean success = true;
    private static final int Project_Status = 1;
    private static final int Project_Issue_details = 2;
    private static final int Project_Issue_similar = 3;
    private static final int Test_user = 4;
    private static final int Test_overview = 5;
    private static final int NonProject_Issue_details = 7;

    public static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " apm/report/Report ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        int task_id = myArgs.getInt("taskid");
        Task task = Task.getById(task_id);
        boolean success = Report.doReport(task);
        DB.close();
        if (success) {
            Log.log("Task successfully completed.");
            System.out.println("Task successfully completed.");
            Log.close();
            System.exit(0);
        } else {
            Log.log("Task partially completed.");
            System.out.println("Task partially completed.");
            Log.close();
            System.exit(2);
        }
    }

    public static boolean doReport(Task task) {
        Report report = new Report(task);
        report.createReport();
        return report.success;
    }

    private Report(Task task) {
        this.task = task;
        this.params = new TaskParameters(this.task.params);
        this.translator = Translator.getInstance(this.params.getString("language"));
        CharSequence[] projs = this.params.getStringArray("projects");
        this.projects = String.join((CharSequence)"','", projs);
    }

    private void createReport() {
        String statement = "";
        String title = "";
        int reportType = this.params.getInt("id");
        switch (reportType) {
            case 1: {
                statement = this.getProjectStatus();
                title = "Project status";
                break;
            }
            case 2: {
                DB.update("SET group_concat_max_len=100000;");
                statement = this.getIssueDetails();
                title = "Issue details";
                break;
            }
            case 3: {
                DB.update("SET group_concat_max_len=100000;");
                statement = this.getIssueSimilar();
                title = "Similar issues";
                break;
            }
            case 4: {
                statement = this.getTestUser();
                title = "Test user";
                break;
            }
            case 5: {
                statement = this.getTestOverview();
                title = "Test overview";
                break;
            }
            case 7: {
                DB.update("SET group_concat_max_len=100000;");
                statement = this.getIssueDetailsNonProject();
                title = "Non-project issue details";
                break;
            }
            default: {
                Log.log("No such report type in apm reports: " + reportType);
                this.success = false;
                return;
            }
        }
        String format = this.params.isExcel() ? ".xlsx" : ".csv";
        String filename = Config.getReportPath() + ReportStarter.getBaseFilename(this.task.type, this.task.id) + format;
        Log.log(filename + "\n" + title + "\n" + statement);
        if (this.params.isExcel()) {
            Log.log("Trying to create Excel file from:\n" + statement);
            this.success = Spreadsheet.ExcelFromStatement(filename, statement, this.translator.getText(title));
        } else {
            Log.log("Trying to create CSV file from:\n" + statement);
            this.success = Spreadsheet.CSVFromStatement(filename, statement);
        }
    }

    private String getProjectStatus() {
        Log.log("Statement getProjectStatus");
        String statement = "SELECT b.proj_name AS `" + this.translator.getText("Project") + "`, rolle AS `" + this.translator.getText("Role") + "`, (SELECT MIN(datetime) FROM cehior_auth_proj_test_rolle_use ru \t\tJOIN trace_tcodes_header tr ON ru.proj_name = tr.project AND ru.bruger = tr.user AND ru.tcode = tr.tcode \t\tWHERE ru.proj_name = b.proj_name AND ru.rolle = b.rolle ) AS `" + this.translator.getText("First execution") + "`, (SELECT MAX(datetime) FROM cehior_auth_proj_test_rolle_use ru \t\tJOIN trace_tcodes_header tr ON ru.proj_name = tr.project AND ru.bruger = tr.user AND ru.tcode = tr.tcode \t\tWHERE ru.proj_name = b.proj_name AND ru.rolle = b.rolle ) AS `" + this.translator.getText("Latest execution") + "`, ST AS `" + this.translator.getText("Tcodes total") + "`, S0 AS `" + this.translator.getText("Tcodes not started") + "`, S1 AS `" + this.translator.getText("Tcodes started") + "`, S3 AS `" + this.translator.getText("Tcodes rejected") + "`, S2 AS `" + this.translator.getText("Tcodes accepted") + "`, FLOOR(100*(S2+S3)/ST) AS `" + this.translator.getText("% Completed") + "`, `system` AS `" + this.translator.getText("System") + "`, `client` AS `" + this.translator.getText("Client") + "` FROM ( \tSELECT proj_name, rolle, \t\tCOUNT(tcode) as ST, \t\tSUM(CASE stat WHEN 4 THEN NULL WHEN 0 THEN 1 ELSE 0 END) as S0, \t\tSUM(CASE stat WHEN 4 THEN NULL WHEN 1 THEN 1 ELSE 0 END) as S1, \t\tSUM(CASE stat WHEN 4 THEN NULL WHEN 2 THEN 1 ELSE 0 END) as S2, \t\tSUM(CASE stat WHEN 4 THEN NULL WHEN 3 THEN 1 ELSE 0 END) as S3, \t\t`system`, `client` FROM ( \tSELECT cehior_auth_proj_test_roller.proj_name, \t\tcehior_auth_proj_test_roller.system, \t\tcehior_auth_proj_test_roller.client, bruger, \t\tcehior_auth_proj_test_roller.rolle, tcode, \t\tIF(tcode IS NULL, 4, IF(test_stat='accepted',2, IF(test_stat='notaccepted',3, IF(hits>0,1,0)))) AS stat \tFROM cehior_auth_proj_test_roller \t\tLEFT JOIN cehior_auth_proj_test_rolle_use ON \t\t\tcehior_auth_proj_test_rolle_use.proj_name = cehior_auth_proj_test_roller.proj_name AND \t\t\tcehior_auth_proj_test_rolle_use.rolle = cehior_auth_proj_test_roller.rolle \tWHERE \t\tcehior_auth_proj_test_roller.proj_name IN ('" + this.projects + "') AND \t\tcehior_auth_proj_test_roller.rolle NOT LIKE '/APPLISOL/%' \tGROUP BY proj_name, `system`, client, bruger, rolle, tcode \tORDER BY proj_name, `system`, client, bruger, rolle ) a GROUP BY proj_name, rolle ) b ";
        return statement;
    }

    private String getIssueDetails() {
        Log.log("Statement getIssueDetails");
        StringBuilder statement = new StringBuilder("SELECT p.proj_name AS `" + this.translator.getText("Project") + "`, \n");
        statement.append((String)(this.params.getBoolean("Description") ? " o.description AS `" + this.translator.getText("Description") + "`, " : ""));
        statement.append("\n\t\tSTR_TO_DATE(CONCAT(o.dato, ' ', o.tid), '%Y%m%d %H%i%s') AS `" + this.translator.getText("Timestamp") + "`, \n\t\to.responsible AS `" + this.translator.getText("Responsible") + "`, \n\t\tr.description AS `" + this.translator.getText("Responsible text") + "`,\n\t\to.tcode AS `" + this.translator.getText("Tcode") + "`, \n\t\to.object AS `" + this.translator.getText("Object") + "`, \n     o.felt AS `" + this.translator.getText("Field") + "`, \n     o.value AS `" + this.translator.getText("Value") + "`, \n\t\tCASE o.status \t\t\tWHEN 'new' THEN '" + this.translator.getText("New") + "'\t\t\tWHEN 'analyze' THEN '" + this.translator.getText("Analysis") + "'\t\t\tWHEN 'solved' THEN '" + this.translator.getText("Solved") + "'\t\t\tWHEN 'rejected' THEN '" + this.translator.getText("Rejected") + "'\t\t\tWHEN 'in_test' THEN '" + this.translator.getText("Test") + "'\t\tEND AS `" + this.translator.getText("Status") + "`, \n\t\to.serial_no AS `" + this.translator.getText("Issue") + "`, \n\t\to.container AS `" + this.translator.getText("T.C.") + "`, \n\t\to.user AS `" + this.translator.getText("Username") + "`, \n\t\to.fornavn AS `" + this.translator.getText("First name") + "`, \n\t\to.efternavn AS `" + this.translator.getText("Last name") + "` \n");
        if (this.params.getBoolean("Comments")) {
            statement.append(", (SELECT GROUP_CONCAT(CONCAT(issue_event.timestamp, ' ', issue_event.user, ': ', issue_comment.comment) SEPARATOR ' " + System.lineSeparator() + "') \t\tFROM issue_event \t\tJOIN issue_comment ON issue_comment.issue_event_id = issue_event.id \t\tWHERE issue_event.issue_id = o.unikid \t\tORDER BY `timestamp` DESC \t) AS `" + this.translator.getText("Comments") + "` ");
            statement.append("\n");
        }
        statement.append("FROM ( \n\t\tSELECT c.*, d.object, d.felt, d.value FROM (  \n\t\t\tSELECT unikid, serial_no, class, user, titel, fornavn, efternavn, dato, tid, `system`, client, status, container, testcase, testcasestep, trin, responsible, extissueno, tcode, description, proj_name \t\t\tFROM cehior_auth_header \n\t\t\tWHERE source IN ('original', 'crm') ");
        statement.append(") AS c \n\t\tLEFT OUTER JOIN ( \n\t\t\tSELECT unikid, object, felt, `value` \n\t\t\tFROM cehior_auth_obj_value \n\t\t) AS d \t\tON c.unikid = d.unikid \n\t) AS o \n\tLEFT OUTER JOIN (  \n\t\tSELECT p.proj_name, p.system, p.client, p.start_date, p.end_date \n\t\tFROM cehior_auth_proj_header as p  \n\t) AS p ON ");
        statement.append("p.proj_name=o.proj_name ");
        statement.append("AND p.system=o.system AND p.client=o.client AND p.start_date<=DATE(o.dato) AND DATE(o.dato)<=p.end_date \n\tLEFT JOIN cehior_auth_resp AS r ON r.responsible = o.responsible \nWHERE p.proj_name IN ('" + this.projects + "') \nORDER BY p.proj_name ASC, `" + this.translator.getText("Timestamp") + "` DESC, o.serial_no DESC;");
        return statement.toString();
    }

    private String getIssueSimilar() {
        Log.log("Statement getIssueSimilar");
        Object statement = "SELECT p.proj_name AS `Project`, \n";
        statement = (String)statement + (String)(this.params.getString("Description").equals("X") ? " o.description AS `" + this.translator.getText("Description") + "`, \n" : "");
        statement = (String)statement + "\to.tcode AS `" + this.translator.getText("Tcode//Service") + "`, \n\t\t\to.object AS `" + this.translator.getText("Object") + "`, \n\t\t\to.field AS `" + this.translator.getText("Field") + "`, \n\t\t\to.value AS `" + this.translator.getText("Value") + "`, \n\t\t\to.serial_no AS `" + this.translator.getText("Issue") + "`, \n\t\t\to.extissueno AS `" + this.translator.getText("Ext. issue no.") + "`, \n\t\t\to.user AS `" + this.translator.getText("User") + "`, \n\t\t\to.fornavn AS `" + this.translator.getText("First name") + "`, \n\t\t\to.efternavn AS `" + this.translator.getText("Last name") + "`,\n\t\t\tCASE o.status \t\t\t\tWHEN 'new' THEN '" + this.translator.getText("New") + "'\t\t\t\tWHEN 'analyze' THEN '" + this.translator.getText("Analysis") + "'\t\t\t\tWHEN 'solved' THEN '" + this.translator.getText("Solved") + "'\t\t\t\tWHEN 'rejected' THEN '" + this.translator.getText("Rejected") + "'\t\t\t\tWHEN 'in_test' THEN '" + this.translator.getText("Test") + "'\t\t\tEND AS `" + this.translator.getText("Status") + "`, \t\t\to.responsible AS `" + this.translator.getText("Responsible") + "`,\n\t\t\tr.description AS `" + this.translator.getText("Responsible text") + "`,\n\t\t\to.master AS `" + this.translator.getText("Master") + "`,\n\t\t\to.system AS `" + this.translator.getText("System") + "`, \n\t\t\to.client AS `" + this.translator.getText("Client") + "` \n";
        if (this.params.getString("Comments").equals("X")) {
            statement = (String)statement + ", (SELECT GROUP_CONCAT(CONCAT(issue_event.timestamp, ' ', issue_event.user, ': ', issue_comment.comment) SEPARATOR '" + System.lineSeparator() + "') \t\tFROM issue_event \t\tLEFT JOIN issue_comment ON issue_comment.issue_event_id = issue_event.id \t\tWHERE issue_event.issue_id = o.unikid \t\tORDER BY `timestamp` DESC \t) AS `" + this.translator.getText("Comments") + "` \n";
        }
        statement = (String)statement + "FROM ( \tSELECT c.*, d.object, d.field, d.value \n\tFROM ( \n\t\tSELECT unikid, serial_no, class, user, titel, fornavn, efternavn, dato, tid, `system`, client, status, container, testcase, testcasestep, trin, responsible, extissueno, tcode, master, description, proj_name \n\t\tFROM cehior_auth_header \n\t) AS c \n\tLEFT OUTER JOIN ( \n\t\tSELECT unikid, object, felt field, value FROM cehior_auth_obj_value \n\t) AS d ON c.unikid = d.unikid \n) AS o \nLEFT OUTER JOIN ( \n\tSELECT p.proj_name, p.system, p.client, p.start_date, p.end_date \n\tFROM cehior_auth_proj_header as p \n) AS p ON p.proj_name=o.proj_name AND p.system=o.system AND p.client=o.client AND p.start_date<=DATE(o.dato) AND DATE(o.dato)<=p.end_date \nLEFT JOIN cehior_auth_resp AS r ON r.responsible = o.responsible \nWHERE p.proj_name IN ('" + this.projects + "') \nORDER BY o.tcode, o.object, o.serial_no, o.field, o.value ;";
        return statement;
    }

    private String getTestUser() {
        Log.log("Statement getTestUser");
        String statement = "SELECT a.proj_name AS `" + this.translator.getText("Project") + "`, \ta.user `" + this.translator.getText("User") + "`, \tfirst_name AS `" + this.translator.getText("First name") + "`, \tlast_name AS `" + this.translator.getText("Last name") + "`, \ta.rolle AS `" + this.translator.getText("Role") + "`,  \tb.tcode AS `" + this.translator.getText("Tcode/Service") + "`, \tIF(test_stat='accepted','" + this.translator.getText("Accepted") + "',  \t\tIF(test_stat='notaccepted','" + this.translator.getText("Rejected") + "',  \t\t\tIF(hits=0,'" + this.translator.getText("Not started") + "','" + this.translator.getText("Started") + "') \t\t) \t) AS `" + this.translator.getText("Status") + "`, \thits AS `" + this.translator.getText("Dynpros") + "`, \ta.system AS `" + this.translator.getText("System") + "`,  \ta.client AS `" + this.translator.getText("Client") + "` FROM cehior_auth_proj_test_roller AS a  \tINNER JOIN cehior_auth_proj_roller_tcode AS b \t\tON a.proj_name=b.proj_name AND a.system=b.system AND a.client=b.client AND a.rolle=b.rolle \tLEFT JOIN cehior_auth_proj_test_user AS c \t\tON a.proj_name=c.proj_name AND a.system=c.system AND a.client=c.client AND a.user=c.test_user \tLEFT JOIN cehior_auth_proj_test_rolle_use AS d \t\tON a.proj_name=d.proj_name AND a.system=d.system AND a.client=d.client AND a.user=d.bruger AND a.rolle=d.rolle AND b.tcode = d.tcode WHERE \ta.proj_name IN ('" + this.projects + "') AND \ta.rolle NOT LIKE '/APPLISOL/%' AND \tb.test='X' ORDER BY a.proj_name, a.system, a.client, a.user, a.rolle, b.tcode ";
        return statement;
    }

    private String getTestOverview() {
        Log.log("Statement getTestOverview");
        String statement = "SELECT \t\ta.proj_name AS `" + this.translator.getText("Project") + "`, \n\t\ta.user AS `" + this.translator.getText("User") + "`,\n\t\tb.first_name AS `" + this.translator.getText("First name") + "`,\n\t\tb.last_name AS `" + this.translator.getText("Last name") + "`,\n\t\tb.pw AS `" + this.translator.getText("Initial password") + "`,\n\t\ta.rolle AS `" + this.translator.getText("Role") + "`,\n\t\tST AS `" + this.translator.getText("Tcodes total") + "`, \n\t\tS0 AS `" + this.translator.getText("Tcodes not started") + "`, \n\t\tS1 AS `" + this.translator.getText("Tcodes started") + "`, \n\t\tS3 AS `" + this.translator.getText("Tcodes rejected") + "`, \n\t\tS2 AS `" + this.translator.getText("Tcodes accepted") + "`, \n\t\tFLOOR(100*(S2+S3)/ST) AS `" + this.translator.getText("% Completed") + "`,\n\t\ta.system AS `" + this.translator.getText("System") + "`, \n\t\ta.client AS `" + this.translator.getText("Client") + "` \n\tFROM cehior_auth_proj_test_roller AS a\n\t\tLEFT JOIN cehior_auth_proj_test_user AS b\n\t\t\tON a.proj_name=b.proj_name AND a.system=b.system AND a.client=b.client AND a.user=b.test_user\n\t\tLEFT JOIN (SELECT proj_name, `system`, client, bruger, rolle,\n\t\t\tCOUNT(tcode) as ST,\n\t\t\tSUM(CASE stat WHEN 0 THEN 1 ELSE 0 END) as S0,\n\t\t\tSUM(CASE stat WHEN 1 THEN 1 ELSE 0 END) as S1,\n\t\t\tSUM(CASE stat WHEN 2 THEN 1 ELSE 0 END) as S2,\n\t\t\tSUM(CASE stat WHEN 3 THEN 1 ELSE 0 END) as S3\n\t\tFROM (SELECT proj_name, `system`, client, bruger, rolle, tcode,  \t\t\tif(test_stat='accepted',2,if(test_stat='notaccepted',3,if(hits=0,0,1))) stat \t\t\tFROM cehior_auth_proj_test_rolle_use\n\t\t\tWHERE proj_name in ('" + this.projects + "')\n\t\t\tGROUP BY proj_name, `system`, client, bruger, rolle, tcode \t\t\tORDER BY proj_name, `system`, client, bruger, rolle \t\t) AS c \t\tGROUP BY proj_name, `system`, client, bruger, rolle \t) AS d ON\t\t\td.proj_name = a.proj_name AND d.system = a.system AND d.client = a.client AND d.bruger = a.user AND d.rolle = a.rolle WHERE a.proj_name in ('" + this.projects + "') AND a.rolle NOT LIKE '/APPLISOL/%'\nORDER BY a.proj_name, a.system, a.client, a.user, a.rolle ;";
        return statement;
    }

    private String getIssueDetailsNonProject() {
        Log.log("Statement getIssueDetails");
        StringBuilder statement = new StringBuilder("SELECT ");
        statement.append((String)(this.params.getBoolean("Description") ? " o.description AS `" + this.translator.getText("Description") + "`, " : ""));
        statement.append("\n\t\tSTR_TO_DATE(CONCAT(o.dato, ' ', o.tid), '%Y%m%d %H%i%s') AS `" + this.translator.getText("Timestamp") + "`, \n\t\to.responsible AS `" + this.translator.getText("Responsible") + "`, \n\t\tr.description AS `" + this.translator.getText("Responsible text") + "`,\n\t\to.tcode AS `" + this.translator.getText("Tcode") + "`, \n\t\to.object AS `" + this.translator.getText("Object") + "`, \n     o.felt AS `" + this.translator.getText("Field") + "`, \n     o.value AS `" + this.translator.getText("Value") + "`, \n\t\tCASE o.status \t\t\tWHEN 'new' THEN '" + this.translator.getText("New") + "'\t\t\tWHEN 'analyze' THEN '" + this.translator.getText("Analysis") + "'\t\t\tWHEN 'solved' THEN '" + this.translator.getText("Solved") + "'\t\t\tWHEN 'rejected' THEN '" + this.translator.getText("Rejected") + "'\t\t\tWHEN 'in_test' THEN '" + this.translator.getText("Test") + "'\t\tEND AS `" + this.translator.getText("Status") + "`, \n\t\to.serial_no AS `" + this.translator.getText("Issue") + "`, \n\t\to.container AS `" + this.translator.getText("T.C.") + "`, \n\t\to.user AS `" + this.translator.getText("Username") + "`, \n\t\to.fornavn AS `" + this.translator.getText("First name") + "`, \n\t\to.efternavn AS `" + this.translator.getText("Last name") + "` \n");
        if (this.params.getBoolean("Comments")) {
            statement.append(", (SELECT GROUP_CONCAT(CONCAT(issue_event.timestamp, ' ', issue_event.user, ': ', issue_comment.comment) SEPARATOR ' " + System.lineSeparator() + "') \t\tFROM issue_event \t\tJOIN issue_comment ON issue_comment.issue_event_id = issue_event.id \t\tWHERE issue_event.issue_id = o.unikid \t\tORDER BY `timestamp` DESC \t) AS `" + this.translator.getText("Comments") + "` ");
            statement.append("\n");
        }
        statement.append("FROM ( \n\t\tSELECT c.*, d.object, d.felt, d.value FROM (  \n\t\t\tSELECT unikid, serial_no, class, user, titel, fornavn, efternavn, dato, tid, `system`, client, status, container, testcase, testcasestep, trin, responsible, extissueno, tcode, description, proj_name \t\t\tFROM cehior_auth_header \n\t\t\tWHERE source IN ('original', 'crm') AND (proj_name IS NULL OR LENGTH(proj_name) = 0)) AS c \n\t\tLEFT OUTER JOIN ( \n\t\t\tSELECT unikid, object, felt, `value` \n\t\t\tFROM cehior_auth_obj_value \n\t\t) AS d \t\tON c.unikid = d.unikid \n\t) AS o \n");
        statement.append("\tLEFT JOIN cehior_auth_resp AS r ON r.responsible = o.responsible \nORDER BY `" + this.translator.getText("Timestamp") + "` DESC, o.serial_no DESC;");
        return statement.toString();
    }
}

